/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.entity;

import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.DigitalObjectService;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.Collection;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.identifiable.entity.Project;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.paging.Order;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.SearchPageRequest;
import de.digitalcollections.model.api.paging.SearchPageResponse;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.api.paging.enums.Direction;
import de.digitalcollections.model.api.paging.enums.NullHandling;
import de.digitalcollections.model.impl.identifiable.entity.DigitalObjectImpl;
import de.digitalcollections.model.impl.paging.OrderImpl;
import de.digitalcollections.model.impl.paging.PageRequestImpl;
import de.digitalcollections.model.impl.paging.SearchPageRequestImpl;
import de.digitalcollections.model.impl.paging.SortingImpl;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.jsondoc.core.annotation.Api;
import org.jsondoc.core.annotation.ApiMethod;
import org.jsondoc.core.annotation.ApiPathParam;
import org.jsondoc.core.annotation.ApiResponseObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(description="The digital object controller", name="Digital object controller")
public class DigitalObjectController {
    @Autowired
    private DigitalObjectService service;

    @ApiMethod(description="Get count of digital objects")
    @GetMapping(value={"/latest/digitalobjects/count", "/v2/digitalobjects/count"}, produces={"application/json"})
    @ApiResponseObject
    public long count() {
        return this.service.count();
    }

    @ApiMethod(description="Get all digital objects")
    @GetMapping(value={"/latest/digitalobjects", "/v2/digitalobjects"}, produces={"application/json"})
    @ApiResponseObject
    public PageResponse<DigitalObject> findAll(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="sortField", required=false, defaultValue="lastModified") String sortField, @RequestParam(name="sortDirection", required=false, defaultValue="DESC") Direction sortDirection, @RequestParam(name="nullHandling", required=false, defaultValue="NATIVE") NullHandling nullHandling) {
        OrderImpl order = new OrderImpl(sortDirection, sortField, nullHandling);
        SortingImpl sorting = new SortingImpl(new Order[]{order});
        PageRequestImpl pageRequest = new PageRequestImpl(pageNumber, pageSize, (Sorting)sorting);
        return this.service.find((PageRequest)pageRequest);
    }

    @ApiMethod(description="Get all digital objects, reduced to their metadata fields (only all identifiers and last modification date)")
    @GetMapping(value={"/latest/digitalobjects/reduced", "/v3/digitalobjects/reduced"}, produces={"application/json"})
    @ApiResponseObject
    public List<DigitalObject> findAllReduced() {
        return this.service.findAllReduced();
    }

    @ApiMethod(description="Find limited amount of digital objects containing searchTerm in label or description")
    @GetMapping(value={"/latest/digitalobjects/search", "/v3/digitalobjects/search"}, produces={"application/json"})
    @ApiResponseObject
    public SearchPageResponse<DigitalObject> findDigitalObjects(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortField", required=false, defaultValue="uuid") String sortField, @RequestParam(name="sortDirection", required=false, defaultValue="ASC") Direction sortDirection, @RequestParam(name="nullHandling", required=false, defaultValue="NATIVE") NullHandling nullHandling, @RequestParam(name="searchTerm", required=false) String searchTerm) {
        OrderImpl order = new OrderImpl(sortDirection, sortField, nullHandling);
        SortingImpl sorting = new SortingImpl(new Order[]{order});
        SearchPageRequestImpl pageRequest = new SearchPageRequestImpl(searchTerm, pageNumber, pageSize, (Sorting)sorting);
        return this.service.find((SearchPageRequest)pageRequest);
    }

    @ApiMethod(description="Get digital object by uuid")
    @GetMapping(value={"/latest/digitalobjects/{uuid}", "/v2/digitalobjects/{uuid}"}, produces={"application/json"})
    @ApiResponseObject
    public DigitalObject findById(@PathVariable UUID uuid) {
        return (DigitalObject)this.service.get(uuid);
    }

    @ApiMethod(description="Get digital object by namespace and id")
    @GetMapping(value={"/latest/digitalobjects/identifier/{namespace}:{id}", "/v2/digitalobjects/identifier/{namespace}:{id}"}, produces={"application/json"})
    @ApiResponseObject
    public DigitalObject findByIdentifier(@ApiPathParam(description="Namespace of the identifier") @PathVariable(value="namespace") String namespace, @ApiPathParam(description="value of the identifier") @PathVariable(value="id") String id) throws IdentifiableServiceException {
        return (DigitalObject)this.service.getByIdentifier(namespace, id);
    }

    @ApiMethod(description="Get (active) paged collections of a digital objects")
    @GetMapping(value={"/latest/digitalobjects/{uuid}/collections", "/v3/digitalobjects/{uuid}/collections"}, produces={"application/json"})
    @ApiResponseObject
    public PageResponse<Collection> getCollections(@ApiPathParam(description="UUID of the digital object") @PathVariable(value="uuid") UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize, @RequestParam(name="active", required=false) String active) {
        PageRequestImpl pageRequest = new PageRequestImpl(pageNumber, pageSize, (Sorting)new SortingImpl());
        DigitalObjectImpl digitalObject = new DigitalObjectImpl();
        digitalObject.setUuid(uuid);
        if (active != null) {
            return this.service.getActiveCollections((DigitalObject)digitalObject, (PageRequest)pageRequest);
        }
        return this.service.getCollections((DigitalObject)digitalObject, (PageRequest)pageRequest);
    }

    @ApiMethod(description="Get image file resources of a digital object")
    @GetMapping(value={"/latest/digitalobjects/{uuid}/fileresources/images", "/v2/digitalobjects/{uuid}/fileresources/images"}, produces={"application/json"})
    @ApiResponseObject
    public List<ImageFileResource> getImageFileResources(@PathVariable UUID uuid) {
        return this.service.getImageFileResources(uuid);
    }

    @ApiMethod(description="Get file resources of a digital object")
    @GetMapping(value={"/latest/digitalobjects/{uuid}/fileresources", "/v2/digitalobjects/{uuid}/fileresources"}, produces={"application/json"})
    @ApiResponseObject
    public List<FileResource> getFileResources(@PathVariable UUID uuid) {
        return this.service.getFileResources(uuid);
    }

    @ApiMethod(description="Get paged projects of a digital objects")
    @GetMapping(value={"/latest/digitalobjects/{uuid}/projects", "/v3/digitalobjects/{uuid}/projects"}, produces={"application/json"})
    @ApiResponseObject
    public PageResponse<Project> getProjects(@ApiPathParam(description="UUID of the digital object") @PathVariable(value="uuid") UUID uuid, @RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="25") int pageSize) {
        PageRequestImpl pageRequest = new PageRequestImpl(pageNumber, pageSize, (Sorting)new SortingImpl());
        DigitalObjectImpl digitalObject = new DigitalObjectImpl();
        digitalObject.setUuid(uuid);
        return this.service.getProjects((DigitalObject)digitalObject, (PageRequest)pageRequest);
    }

    @ApiMethod(description="Save a newly created digital object")
    @PostMapping(value={"/latest/digitalobjects", "/v2/digitalobjects"}, produces={"application/json"})
    @ApiResponseObject
    public DigitalObject save(@RequestBody DigitalObject digitalObject, BindingResult errors) throws IdentifiableServiceException {
        return (DigitalObject)this.service.save((Identifiable)digitalObject);
    }

    @ApiMethod(description="Save list of fileresources for a given digital object")
    @PostMapping(value={"/latest/digitalobjects/{uuid}/fileresources", "/v3/digitalobjects/{uuid}/fileresources"}, produces={"application/json"})
    @ApiResponseObject
    public List<FileResource> saveFileResources(@ApiPathParam(description="UUID of the digital object") @PathVariable(value="uuid") UUID uuid, @RequestBody List<FileResource> fileResources) {
        return this.service.saveFileResources(uuid, fileResources);
    }

    @ApiMethod(description="Update a digital object")
    @PutMapping(value={"/latest/digitalobjects/{uuid}", "/v2/digitalobjects/{uuid}"}, produces={"application/json"})
    @ApiResponseObject
    public DigitalObject update(@ApiPathParam(description="UUID of the digital object") @PathVariable(value="uuid") UUID uuid, @RequestBody DigitalObject digitalObject, BindingResult errors) throws IdentifiableServiceException {
        assert (Objects.equals(uuid, digitalObject.getUuid()));
        return (DigitalObject)this.service.update((Identifiable)digitalObject);
    }

    @ApiMethod(description="Delete a digital object with all its relations")
    @DeleteMapping(value={"/latest/digitalobjects/{uuid}", "/v2/digitalobjects/{uuid}"}, produces={"application/json"})
    @ApiResponseObject
    public ResponseEntity delete(@ApiPathParam(description="UUID of the digital object") @PathVariable(value="uuid") UUID uuid) {
        boolean successful = this.service.delete(uuid);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }
}

