/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.commons.springmvc.thymeleaf.SpacesDialect;
import de.digitalcollections.model.jackson.DigitalCollectionsObjectMapper;
import de.digitalcollections.model.xml.xstream.DigitalCollectionsXStreamMarshaller;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Primary;
import org.springframework.format.FormatterRegistry;
import org.springframework.format.datetime.standard.DateTimeFormatterRegistrar;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.format.support.FormattingConversionService;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.xml.MarshallingHttpMessageConverter;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.web.servlet.config.annotation.ContentNegotiationConfigurer;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.thymeleaf.dialect.AbstractProcessorDialect;

@Configuration
@EnableAspectJAutoProxy
public class SpringConfigWeb
implements WebMvcConfigurer {
    @Value(value="${server.port:80}")
    Integer port;
    @Value(value="${info.app.project.version:unknown}")
    String projectVersion;

    @Bean
    @Primary
    public ObjectMapper objectMapper() {
        return new DigitalCollectionsObjectMapper();
    }

    @Bean
    public FormattingConversionService conversionService() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService(false);
        DateTimeFormatterRegistrar registrar = new DateTimeFormatterRegistrar();
        registrar.setDateFormatter(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        registrar.setDateTimeFormatter(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss"));
        registrar.registerFormatters((FormatterRegistry)conversionService);
        return conversionService;
    }

    public void configurePathMatch(PathMatchConfigurer configurer) {
        configurer.setUseRegisteredSuffixPatternMatch(Boolean.TRUE);
    }

    public void configureContentNegotiation(ContentNegotiationConfigurer configurer) {
        configurer.favorParameter(true).favorPathExtension(true).ignoreUnknownPathExtensions(true).useRegisteredExtensionsOnly(false).defaultContentType(new MediaType[]{MediaType.APPLICATION_JSON});
        configurer.mediaType("html", MediaType.TEXT_HTML);
        configurer.mediaType("json", MediaType.APPLICATION_JSON);
        configurer.mediaType("xml", MediaType.APPLICATION_XML);
    }

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add(this.createXmlHttpMessageConverter());
    }

    private HttpMessageConverter<Object> createXmlHttpMessageConverter() {
        MarshallingHttpMessageConverter xmlConverter = new MarshallingHttpMessageConverter();
        DigitalCollectionsXStreamMarshaller xstreamMarshaller = new DigitalCollectionsXStreamMarshaller();
        xmlConverter.setMarshaller((Marshaller)xstreamMarshaller);
        xmlConverter.setUnmarshaller((Unmarshaller)xstreamMarshaller);
        return xmlConverter;
    }

    @Bean
    public AbstractProcessorDialect whiteSpaceNormalizedDialect() {
        return new SpacesDialect();
    }
}

