/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.controller.identifiable.entity;

import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.CorporationService;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.Corporation;
import de.digitalcollections.model.api.paging.Order;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.api.paging.enums.Direction;
import de.digitalcollections.model.api.paging.enums.NullHandling;
import de.digitalcollections.model.impl.paging.OrderImpl;
import de.digitalcollections.model.impl.paging.PageRequestImpl;
import de.digitalcollections.model.impl.paging.SortingImpl;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import org.jsondoc.core.annotation.Api;
import org.jsondoc.core.annotation.ApiMethod;
import org.jsondoc.core.annotation.ApiPathParam;
import org.jsondoc.core.annotation.ApiQueryParam;
import org.jsondoc.core.annotation.ApiResponseObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(description="The corporation controller", name="Corporation controller")
public class CorporationController {
    private CorporationService corporationService;

    @Autowired
    public CorporationController(CorporationService corporationService) {
        this.corporationService = corporationService;
    }

    @ApiMethod(description="Get all corporations")
    @RequestMapping(value={"/latest/corporations", "/v2/corporations"}, produces={"application/json"}, method={RequestMethod.GET})
    @ApiResponseObject
    public PageResponse<Corporation> findAll(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="sortField", required=false, defaultValue="uuid") String sortField, @RequestParam(name="sortDirection", required=false, defaultValue="ASC") Direction sortDirection, @RequestParam(name="nullHandling", required=false, defaultValue="NATIVE") NullHandling nullHandling) {
        OrderImpl order = new OrderImpl(sortDirection, sortField, nullHandling);
        SortingImpl sorting = new SortingImpl(new Order[]{order});
        PageRequestImpl pageRequest = new PageRequestImpl(pageNumber, pageSize, (Sorting)sorting);
        return this.corporationService.find((PageRequest)pageRequest);
    }

    @ApiMethod(description="Get an corporation as JSON or XML, depending on extension or <tt>format</tt> request parameter or accept header")
    @RequestMapping(value={"/latest/corporations/{uuid}", "/v2/corporations/{uuid}"}, produces={"application/json", "application/xml"}, method={RequestMethod.GET})
    @ApiResponseObject
    public ResponseEntity<Corporation> getWebpage(@ApiPathParam(description="UUID of the corporation, e.g. <tt>599a120c-2dd5-11e8-b467-0ed5f89f718b</tt>") @PathVariable(value="uuid") UUID uuid, @ApiQueryParam(name="pLocale", description="Desired locale, e.g. <tt>de_DE</tt>. If unset, contents in all languages will be returned") @RequestParam(name="pLocale", required=false) Locale pLocale) throws IdentifiableServiceException {
        Corporation corporation = pLocale == null ? (Corporation)this.corporationService.get(uuid) : (Corporation)this.corporationService.get(uuid, pLocale);
        return new ResponseEntity((Object)corporation, HttpStatus.OK);
    }

    @ApiMethod(description="Save a newly created corporation")
    @RequestMapping(value={"/latest/corporations", "/v2/corporations"}, produces={"application/json"}, method={RequestMethod.POST})
    @ApiResponseObject
    public Corporation save(@RequestBody Corporation corporation, BindingResult errors) throws IdentifiableServiceException {
        return (Corporation)this.corporationService.save((Identifiable)corporation);
    }

    @ApiMethod(description="Update an corporation")
    @RequestMapping(value={"/latest/corporations/{uuid}", "/v2/corporations/{uuid}"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ApiResponseObject
    public Corporation update(@PathVariable UUID uuid, @RequestBody Corporation corporation, BindingResult errors) throws IdentifiableServiceException {
        assert (Objects.equals(uuid, corporation.getUuid()));
        return (Corporation)this.corporationService.update((Identifiable)corporation);
    }
}

