/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.api.service.identifiable;

import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifiableService;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import java.util.List;
import java.util.Locale;

public interface NodeService<N extends Identifiable>
extends IdentifiableService<N> {
    public boolean addChild(N var1, N var2) throws ServiceException;

    public boolean addChildren(N var1, List<N> var2) throws ServiceException;

    public PageResponse<N> findChildren(N var1, PageRequest var2) throws ServiceException;

    public PageResponse<N> findRootNodes(PageRequest var1) throws ServiceException;

    default public BreadcrumbNavigation getBreadcrumbNavigation(N node, Locale locale, Locale fallbackLocale) throws ServiceException {
        BreadcrumbNavigation localizedBreadcrumbNavigation = this.getBreadcrumbNavigation(node);
        localizedBreadcrumbNavigation.getNavigationItems().stream().forEach(n -> this.cleanupLabelFromUnwantedLocales(locale, fallbackLocale, n.getLabel()));
        return localizedBreadcrumbNavigation;
    }

    public BreadcrumbNavigation getBreadcrumbNavigation(N var1) throws ServiceException;

    public List<N> getChildren(N var1) throws ServiceException;

    public N getParent(N var1) throws ServiceException;

    public List<N> getParents(N var1) throws ServiceException;

    public List<Locale> getRootNodesLanguages() throws ServiceException;

    public boolean removeChild(N var1, N var2) throws ServiceException;

    public N saveWithParent(N var1, N var2) throws ServiceException;

    public boolean updateChildrenOrder(N var1, List<N> var2) throws ServiceException;
}

