/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.entity.relation;

import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.relation.EntityToEntityRelationRepository;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.relation.EntityToEntityRelationService;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.relation.EntityRelation;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class EntityToEntityRelationServiceImpl
implements EntityToEntityRelationService {
    private final EntityToEntityRelationRepository repository;

    @Autowired
    public EntityToEntityRelationServiceImpl(EntityToEntityRelationRepository repository) {
        this.repository = repository;
    }

    @Override
    public void addRelation(EntityRelation relation) throws ServiceException {
        try {
            this.repository.addRelation(relation);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Cannot add the relation: %s %s %s".formatted(relation.getSubject(), relation.getPredicate(), relation.getObject()), e);
        }
    }

    @Override
    public void deleteByObject(Entity objectEntity) throws ServiceException {
        try {
            this.repository.deleteByObject(objectEntity);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public void deleteBySubject(Entity subjectEntity) throws ServiceException {
        try {
            this.repository.deleteBySubject(subjectEntity);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    private Entity extractEntityWithUuidOnly(Entity entity) {
        Entity entityWithUuidOnly;
        try {
            entityWithUuidOnly = (Entity)entity.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            entityWithUuidOnly.setUuid(entity.getUuid());
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            entityWithUuidOnly = ((Entity.EntityBuilder)Entity.builder().uuid(entity.getUuid())).build();
        }
        return entityWithUuidOnly;
    }

    @Override
    public PageResponse<EntityRelation> find(PageRequest pageRequest) throws ServiceException {
        try {
            return this.repository.find(pageRequest);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public PageResponse<EntityRelation> findBySubject(Entity subjectEntity, PageRequest pageRequest) throws ServiceException {
        try {
            return this.repository.findBySubject(subjectEntity, pageRequest);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public void save(List<EntityRelation> entityRelations) throws ServiceException {
        try {
            this.repository.save(entityRelations);
        }
        catch (Exception e) {
            throw new ServiceException("Cannot persist EntityRelations " + entityRelations + ": " + e, e);
        }
    }

    @Override
    public void setEntityRelations(Entity entity, List<EntityRelation> relations, boolean deleteExisting) throws ServiceException {
        if (deleteExisting) {
            this.deleteByObject(entity);
        }
        relations.stream().forEach(r -> r.setObject(this.extractEntityWithUuidOnly(entity)));
        this.save(relations);
    }
}

