/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.resource;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource.FileResourceMetadataRepository;
import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ConflictException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifierService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.alias.UrlAliasService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.ApplicationFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.AudioFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.FileResourceMetadataService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.ImageFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.LinkedDataFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.TextFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.VideoFileResourceService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.IdentifiableServiceImpl;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.resource.ApplicationFileResource;
import de.digitalcollections.model.identifiable.resource.AudioFileResource;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.identifiable.resource.LinkedDataFileResource;
import de.digitalcollections.model.identifiable.resource.TextFileResource;
import de.digitalcollections.model.identifiable.resource.VideoFileResource;
import de.digitalcollections.model.text.LocalizedText;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="fileResourceMetadataService")
public class FileResourceMetadataServiceImpl
extends IdentifiableServiceImpl<FileResource, FileResourceMetadataRepository<FileResource>>
implements FileResourceMetadataService<FileResource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileResourceMetadataServiceImpl.class);
    protected final ApplicationFileResourceService applicationFileResourceService;
    protected final AudioFileResourceService audioFileResourceService;
    protected final ImageFileResourceService imageFileResourceService;
    protected final LinkedDataFileResourceService linkedDataFileResourceService;
    private final LocaleService localeService;
    protected final TextFileResourceService textFileResourceService;
    protected final VideoFileResourceService videoFileResourceService;

    public FileResourceMetadataServiceImpl(FileResourceMetadataRepository<FileResource> metadataRepository, ApplicationFileResourceService applicationFileResourceService, AudioFileResourceService audioFileResourceService, ImageFileResourceService imageFileResourceService, LinkedDataFileResourceService linkedDataFileResourceService, TextFileResourceService textFileResourceService, VideoFileResourceService videoFileResourceService, LocaleService localeService, IdentifierService identifierService, UrlAliasService urlAliasService, CudamiConfig cudamiConfig) {
        super(metadataRepository, identifierService, urlAliasService, localeService, cudamiConfig);
        this.applicationFileResourceService = applicationFileResourceService;
        this.audioFileResourceService = audioFileResourceService;
        this.imageFileResourceService = imageFileResourceService;
        this.linkedDataFileResourceService = linkedDataFileResourceService;
        this.textFileResourceService = textFileResourceService;
        this.videoFileResourceService = videoFileResourceService;
        this.localeService = localeService;
    }

    @Override
    public FileResource createByMimeType(MimeType mimeType) {
        return ((FileResourceMetadataRepository)this.repository).createByMimeType(mimeType);
    }

    @Override
    public boolean delete(FileResource fileResource) throws ConflictException, ServiceException {
        switch (fileResource.getFileResourceType()) {
            case APPLICATION: {
                ApplicationFileResource applicationFileResource = (ApplicationFileResource)this.applicationFileResourceService.create();
                BeanUtils.copyProperties((Object)fileResource, (Object)applicationFileResource);
                return this.applicationFileResourceService.delete(applicationFileResource);
            }
            case AUDIO: {
                AudioFileResource audioFileResource = (AudioFileResource)this.audioFileResourceService.create();
                BeanUtils.copyProperties((Object)fileResource, (Object)audioFileResource);
                return this.audioFileResourceService.delete(audioFileResource);
            }
            case IMAGE: {
                ImageFileResource imageFileResource = (ImageFileResource)this.imageFileResourceService.create();
                BeanUtils.copyProperties((Object)fileResource, (Object)imageFileResource);
                return this.imageFileResourceService.delete(imageFileResource);
            }
            case LINKED_DATA: {
                LinkedDataFileResource linkedDataFileResource = (LinkedDataFileResource)this.linkedDataFileResourceService.create();
                BeanUtils.copyProperties((Object)fileResource, (Object)linkedDataFileResource);
                return this.linkedDataFileResourceService.delete(linkedDataFileResource);
            }
            case TEXT: {
                TextFileResource textFileResource = (TextFileResource)this.textFileResourceService.create();
                BeanUtils.copyProperties((Object)fileResource, (Object)textFileResource);
                return this.textFileResourceService.delete(textFileResource);
            }
            case VIDEO: {
                VideoFileResource videoFileResource = (VideoFileResource)this.videoFileResourceService.create();
                BeanUtils.copyProperties((Object)fileResource, (Object)videoFileResource);
                return this.videoFileResourceService.delete(videoFileResource);
            }
        }
        return super.delete(fileResource);
    }

    @Override
    public FileResource getByExample(FileResource example) throws ServiceException {
        FileResource fileResource;
        try {
            fileResource = (FileResource)((FileResourceMetadataRepository)this.repository).getByExample((UniqueObject)example);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        return this.getTypeSpecific(fileResource);
    }

    @Override
    public FileResource getByIdentifier(Identifier identifier) throws ServiceException {
        FileResource fileResource;
        try {
            fileResource = (FileResource)((FileResourceMetadataRepository)this.repository).getByIdentifier(identifier);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        return this.getTypeSpecific(fileResource);
    }

    private FileResource getTypeSpecific(FileResource fileResource) {
        if (fileResource == null) {
            return null;
        }
        FileResource specificFileResource = this.createByMimeType(fileResource.getMimeType());
        try {
            switch (specificFileResource.getFileResourceType()) {
                case APPLICATION: {
                    ApplicationFileResource applicationFileResource = (ApplicationFileResource)this.applicationFileResourceService.create();
                    BeanUtils.copyProperties((Object)fileResource, (Object)applicationFileResource);
                    return (FileResource)this.applicationFileResourceService.getByExample(applicationFileResource);
                }
                case AUDIO: {
                    AudioFileResource audioFileResource = (AudioFileResource)this.audioFileResourceService.create();
                    BeanUtils.copyProperties((Object)fileResource, (Object)audioFileResource);
                    return (FileResource)this.audioFileResourceService.getByExample(audioFileResource);
                }
                case IMAGE: {
                    ImageFileResource imageFileResource = (ImageFileResource)this.imageFileResourceService.create();
                    BeanUtils.copyProperties((Object)fileResource, (Object)imageFileResource);
                    return (FileResource)this.imageFileResourceService.getByExample(imageFileResource);
                }
                case LINKED_DATA: {
                    LinkedDataFileResource linkedDataFileResource = (LinkedDataFileResource)this.linkedDataFileResourceService.create();
                    BeanUtils.copyProperties((Object)fileResource, (Object)linkedDataFileResource);
                    return (FileResource)this.linkedDataFileResourceService.getByExample(linkedDataFileResource);
                }
                case TEXT: {
                    TextFileResource textFileResource = (TextFileResource)this.textFileResourceService.create();
                    BeanUtils.copyProperties((Object)fileResource, (Object)textFileResource);
                    return (FileResource)this.textFileResourceService.getByExample(textFileResource);
                }
                case VIDEO: {
                    VideoFileResource videoFileResource = (VideoFileResource)this.videoFileResourceService.create();
                    BeanUtils.copyProperties((Object)fileResource, (Object)videoFileResource);
                    return (FileResource)this.videoFileResourceService.getByExample(videoFileResource);
                }
            }
            return fileResource;
        }
        catch (ServiceException ex) {
            LOGGER.error("Cannot get type specific data for fileresource. Returning generic fileresource.", (Throwable)ex);
            return fileResource;
        }
    }

    @Override
    public void save(FileResource fileResource) throws ServiceException, ValidationException {
        if (fileResource.getLabel() == null && fileResource.getFilename() != null) {
            fileResource.setLabel(new LocalizedText(new Locale(this.localeService.getDefaultLanguage()), fileResource.getFilename()));
        }
        switch (fileResource.getFileResourceType()) {
            case APPLICATION: {
                ApplicationFileResource applicationFileResource = (ApplicationFileResource)this.applicationFileResourceService.create();
                BeanUtils.copyProperties((Object)fileResource, (Object)applicationFileResource);
                this.applicationFileResourceService.save(applicationFileResource);
                BeanUtils.copyProperties((Object)applicationFileResource, (Object)fileResource);
                break;
            }
            case AUDIO: {
                AudioFileResource audioFileResource = (AudioFileResource)this.audioFileResourceService.create();
                BeanUtils.copyProperties((Object)fileResource, (Object)audioFileResource);
                this.audioFileResourceService.save(audioFileResource);
                BeanUtils.copyProperties((Object)audioFileResource, (Object)fileResource);
                break;
            }
            case IMAGE: {
                ImageFileResource imageFileResource = (ImageFileResource)this.imageFileResourceService.create();
                BeanUtils.copyProperties((Object)fileResource, (Object)imageFileResource);
                this.imageFileResourceService.save(imageFileResource);
                BeanUtils.copyProperties((Object)imageFileResource, (Object)fileResource);
                break;
            }
            case TEXT: {
                TextFileResource textFileResource = (TextFileResource)this.textFileResourceService.create();
                BeanUtils.copyProperties((Object)fileResource, (Object)textFileResource);
                this.textFileResourceService.save(textFileResource);
                BeanUtils.copyProperties((Object)textFileResource, (Object)fileResource);
                break;
            }
            case VIDEO: {
                VideoFileResource videoFileResource = (VideoFileResource)this.videoFileResourceService.create();
                BeanUtils.copyProperties((Object)fileResource, (Object)videoFileResource);
                this.videoFileResourceService.save(videoFileResource);
                BeanUtils.copyProperties((Object)videoFileResource, (Object)fileResource);
                break;
            }
            default: {
                super.save(fileResource);
            }
        }
    }

    @Override
    public void update(FileResource fileResource) throws ServiceException, ValidationException {
        switch (fileResource.getFileResourceType()) {
            case APPLICATION: {
                ApplicationFileResource applicationFileResource = (ApplicationFileResource)this.applicationFileResourceService.create();
                BeanUtils.copyProperties((Object)fileResource, (Object)applicationFileResource);
                this.applicationFileResourceService.update(applicationFileResource);
                BeanUtils.copyProperties((Object)applicationFileResource, (Object)fileResource);
                break;
            }
            case AUDIO: {
                AudioFileResource audioFileResource = (AudioFileResource)this.audioFileResourceService.create();
                BeanUtils.copyProperties((Object)fileResource, (Object)audioFileResource);
                this.audioFileResourceService.update(audioFileResource);
                BeanUtils.copyProperties((Object)audioFileResource, (Object)fileResource);
                break;
            }
            case IMAGE: {
                ImageFileResource imageFileResource = (ImageFileResource)this.imageFileResourceService.create();
                BeanUtils.copyProperties((Object)fileResource, (Object)imageFileResource);
                this.imageFileResourceService.update(imageFileResource);
                BeanUtils.copyProperties((Object)imageFileResource, (Object)fileResource);
                break;
            }
            case TEXT: {
                TextFileResource textFileResource = (TextFileResource)this.textFileResourceService.create();
                BeanUtils.copyProperties((Object)fileResource, (Object)textFileResource);
                this.textFileResourceService.update(textFileResource);
                BeanUtils.copyProperties((Object)textFileResource, (Object)fileResource);
                break;
            }
            case VIDEO: {
                VideoFileResource videoFileResource = (VideoFileResource)this.videoFileResourceService.create();
                BeanUtils.copyProperties((Object)fileResource, (Object)videoFileResource);
                this.videoFileResourceService.update(videoFileResource);
                BeanUtils.copyProperties((Object)videoFileResource, (Object)fileResource);
                break;
            }
            default: {
                super.update(fileResource);
            }
        }
    }
}

