/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.entity;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.DigitalObjectRepository;
import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.content.ManagedContentService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ConflictException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifierService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.alias.UrlAliasService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.CollectionService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.DigitalObjectService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.ProjectService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.work.ItemService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.DigitalObjectLinkedDataFileResourceService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.resource.DigitalObjectRenderingFileResourceService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.entity.EntityServiceImpl;
import de.digitalcollections.cudami.server.config.HookProperties;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.Project;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.identifiable.entity.item.Item;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.identifiable.resource.LinkedDataFileResource;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DigitalObjectServiceImpl
extends EntityServiceImpl<DigitalObject>
implements DigitalObjectService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigitalObjectServiceImpl.class);
    private final CollectionService collectionService;
    private final DigitalObjectLinkedDataFileResourceService digitalObjectLinkedDataFileResourceService;
    private final DigitalObjectRenderingFileResourceService digitalObjectRenderingFileResourceService;
    private final ItemService itemService;
    private final ProjectService projectService;

    public DigitalObjectServiceImpl(DigitalObjectRepository repository, CollectionService collectionService, ProjectService projectService, IdentifierService identifierService, ItemService itemService, UrlAliasService urlAliasService, DigitalObjectLinkedDataFileResourceService digitalObjectLinkedDataFileResourceService, DigitalObjectRenderingFileResourceService digitalObjectRenderingFileResourceService, HookProperties hookProperties, LocaleService localeService, CudamiConfig cudamiConfig) {
        super(repository, identifierService, urlAliasService, hookProperties, localeService, cudamiConfig);
        this.collectionService = collectionService;
        this.itemService = itemService;
        this.projectService = projectService;
        this.digitalObjectRenderingFileResourceService = digitalObjectRenderingFileResourceService;
        this.digitalObjectLinkedDataFileResourceService = digitalObjectLinkedDataFileResourceService;
    }

    @Override
    public boolean delete(DigitalObject digitalObject) throws ServiceException, ConflictException {
        DigitalObject digitalObjectFromRepo = this.getByExample(digitalObject);
        if (digitalObjectFromRepo == null) {
            return false;
        }
        this.collectionService.removeDigitalObjectFromAllCollections(digitalObjectFromRepo);
        this.projectService.removeDigitalObjectFromAllProjects(digitalObjectFromRepo);
        this.deleteFileResources(digitalObjectFromRepo);
        try {
            this.deleteLinkedDatafileResources(digitalObjectFromRepo);
        }
        catch (ServiceException e) {
            throw new ServiceException("Cannot remove LinkedDataFileResource from digitalObject=" + digitalObjectFromRepo + ": " + e, e);
        }
        try {
            this.deleteRenderingFileResourceResource(digitalObjectFromRepo);
        }
        catch (ServiceException e) {
            throw new ServiceException("Cannot remove RenderingFileResource from digitalObject=" + digitalObjectFromRepo + ": " + e, e);
        }
        return super.delete(digitalObjectFromRepo);
    }

    @Override
    public void deleteFileResources(DigitalObject digitalObject) throws ServiceException {
        try {
            ((DigitalObjectRepository)this.repository).deleteFileResources(digitalObject);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    private void deleteLinkedDatafileResources(DigitalObject digitalObject) throws ServiceException {
        this.digitalObjectLinkedDataFileResourceService.deleteLinkedDataFileResources(digitalObject);
    }

    private void deleteRenderingFileResourceResource(DigitalObject digitalObject) throws ServiceException {
        this.digitalObjectRenderingFileResourceService.deleteRenderingFileResources(digitalObject);
    }

    private void fillDigitalObject(DigitalObject digitalObject) throws ServiceException {
        List<FileResource> renderingResources;
        if (digitalObject == null) {
            return;
        }
        List<LinkedDataFileResource> linkedDataFileResources = this.getLinkedDataFileResources(digitalObject);
        if (linkedDataFileResources != null && !linkedDataFileResources.isEmpty()) {
            digitalObject.setLinkedDataResources(new ArrayList<LinkedDataFileResource>(linkedDataFileResources));
        }
        if ((renderingResources = this.getRenderingFileResources(digitalObject)) != null && !renderingResources.isEmpty()) {
            digitalObject.setRenderingResources(new ArrayList<FileResource>(renderingResources));
        }
    }

    @Override
    public PageResponse<Collection> findActiveCollections(DigitalObject digitalObject, PageRequest pageRequest) throws ServiceException {
        Filtering filtering = ManagedContentService.filteringForActive();
        pageRequest.add(filtering);
        try {
            return ((DigitalObjectRepository)this.repository).findCollections(digitalObject, pageRequest);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public PageResponse<Collection> findCollections(DigitalObject digitalObject, PageRequest pageRequest) throws ServiceException {
        try {
            return ((DigitalObjectRepository)this.repository).findCollections(digitalObject, pageRequest);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public PageResponse<Project> findProjects(DigitalObject digitalObject, PageRequest pageRequest) throws ServiceException {
        try {
            return ((DigitalObjectRepository)this.repository).findProjects(digitalObject, pageRequest);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public DigitalObject getByExample(DigitalObject example) throws ServiceException {
        DigitalObject digitalObject = super.getByExample(example);
        this.fillDigitalObject(digitalObject);
        return digitalObject;
    }

    @Override
    public DigitalObject getByExampleAndLocale(DigitalObject example, Locale locale) throws ServiceException {
        DigitalObject digitalObject = super.getByExampleAndLocale(example, locale);
        this.fillDigitalObject(digitalObject);
        return digitalObject;
    }

    @Override
    public DigitalObject getByIdentifier(Identifier identifier) throws ServiceException {
        DigitalObject digitalObject = (DigitalObject)super.getByIdentifier(identifier);
        this.fillDigitalObject(digitalObject);
        return digitalObject;
    }

    @Override
    public DigitalObject getByIdentifierWithWEMI(Identifier identifier) throws ServiceException {
        DigitalObject digitalObject = this.getByIdentifier(identifier);
        if (digitalObject == null) {
            return null;
        }
        if (digitalObject.getItem() != null) {
            Item item = this.itemService.getByExample(digitalObject.getItem());
            digitalObject.setItem(item);
        }
        return digitalObject;
    }

    @Override
    public DigitalObject getByRefId(long refId) throws ServiceException {
        DigitalObject digitalObject = (DigitalObject)super.getByRefId(refId);
        this.fillDigitalObject(digitalObject);
        return digitalObject;
    }

    @Override
    public List<FileResource> getFileResources(DigitalObject digitalObject) throws ServiceException {
        try {
            return ((DigitalObjectRepository)this.repository).getFileResources(digitalObject);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public List<ImageFileResource> getIiifImageFileResources(DigitalObject digitalObject) throws ServiceException {
        try {
            return ((DigitalObjectRepository)this.repository).getIiifImageFileResources(digitalObject);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public List<ImageFileResource> getImageFileResources(DigitalObject digitalObject) throws ServiceException {
        try {
            return ((DigitalObjectRepository)this.repository).getImageFileResources(digitalObject);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public Item getItem(DigitalObject example) throws ServiceException {
        DigitalObject digitalObject = this.getByExample(example);
        if (digitalObject == null) {
            return null;
        }
        return digitalObject.getItem();
    }

    @Override
    public List<Locale> getLanguagesOfCollections(DigitalObject digitalObject) throws ServiceException {
        try {
            return ((DigitalObjectRepository)this.repository).getLanguagesOfCollections(digitalObject);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public List<Locale> getLanguagesOfContainedDigitalObjects(DigitalObject digitalObject) throws ServiceException {
        try {
            return ((DigitalObjectRepository)this.repository).getLanguagesOfContainedDigitalObjects(digitalObject);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public List<Locale> getLanguagesOfProjects(DigitalObject digitalObject) throws ServiceException {
        try {
            return ((DigitalObjectRepository)this.repository).getLanguagesOfProjects(digitalObject);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public List<LinkedDataFileResource> getLinkedDataFileResources(DigitalObject digitalObject) throws ServiceException {
        try {
            return this.digitalObjectLinkedDataFileResourceService.getLinkedDataFileResources(digitalObject);
        }
        catch (ServiceException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public List<DigitalObject> getRandom(int count) throws ServiceException {
        List<DigitalObject> digitalObjects = super.getRandom(count);
        if (digitalObjects == null || digitalObjects.isEmpty()) {
            return digitalObjects;
        }
        for (DigitalObject digitalObject : digitalObjects) {
            this.fillDigitalObject(digitalObject);
        }
        return digitalObjects;
    }

    @Override
    public List<FileResource> getRenderingFileResources(DigitalObject digitalObject) throws ServiceException {
        return this.digitalObjectRenderingFileResourceService.getRenderingFileResources(digitalObject);
    }

    @Override
    public void save(DigitalObject digitalObject) throws ServiceException, ValidationException {
        List linkedDataResources = digitalObject.getLinkedDataResources();
        List renderingResources = digitalObject.getRenderingResources();
        super.save(digitalObject);
        this.setLinkedDataFileResources(digitalObject, linkedDataResources);
        try {
            this.setRenderingFileResources(digitalObject, renderingResources);
        }
        catch (ServiceException e) {
            throw new ServiceException("Cannot save DigitalObject: " + e, e);
        }
        this.fillDigitalObject(digitalObject);
    }

    @Override
    public List<FileResource> setFileResources(DigitalObject digitalObject, List<FileResource> fileResources) throws ServiceException {
        try {
            return ((DigitalObjectRepository)this.repository).setFileResources(digitalObject, fileResources);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public boolean setItem(DigitalObject digitalObject, Item item) throws ConflictException, ValidationException, ServiceException {
        if (item == null) {
            return false;
        }
        DigitalObject digitalObjectFromRepo = this.getByExample(digitalObject);
        if (digitalObjectFromRepo == null) {
            return false;
        }
        Item digitalObjectItem = digitalObjectFromRepo.getItem();
        if (digitalObjectItem != null && digitalObjectItem.getUuid().equals(item.getUuid())) {
            return true;
        }
        if (digitalObjectItem != null && !digitalObjectItem.getUuid().equals(item.getUuid())) {
            LOGGER.warn("Trying to connect DigitalObject " + digitalObject + " to item " + item.getUuid() + ", but it already belongs to item " + digitalObjectItem.getUuid());
            throw new ConflictException("DigitalObject " + digitalObjectFromRepo.getUuid() + " already belongs to item " + digitalObjectFromRepo.getItem().getUuid());
        }
        digitalObjectFromRepo.setItem(item);
        this.update(digitalObjectFromRepo);
        return true;
    }

    @Override
    public List<LinkedDataFileResource> setLinkedDataFileResources(DigitalObject digitalObject, List<LinkedDataFileResource> linkedDataFileResources) throws ServiceException {
        return this.digitalObjectLinkedDataFileResourceService.setLinkedDataFileResources(digitalObject, linkedDataFileResources);
    }

    @Override
    public List<FileResource> setRenderingFileResources(DigitalObject digitalObject, List<FileResource> renderingFileResources) throws ServiceException {
        return this.digitalObjectRenderingFileResourceService.setRenderingFileResources(digitalObject, renderingFileResources);
    }

    @Override
    public void update(DigitalObject digitalObject) throws ValidationException, ServiceException {
        List linkedDataResources = digitalObject.getLinkedDataResources();
        List renderingResources = digitalObject.getRenderingResources();
        super.update(digitalObject);
        this.setLinkedDataFileResources(digitalObject, linkedDataResources);
        try {
            this.setRenderingFileResources(digitalObject, renderingResources);
        }
        catch (ServiceException e) {
            throw new ServiceException("Cannot update DigitalObject: " + e, e);
        }
        this.fillDigitalObject(digitalObject);
    }
}

