/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.entity;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.NodeRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.CollectionRepository;
import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.content.ManagedContentService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ConflictException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifierService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.alias.UrlAliasService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.CollectionService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.entity.EntityServiceImpl;
import de.digitalcollections.cudami.server.config.HookProperties;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CollectionServiceImpl
extends EntityServiceImpl<Collection>
implements CollectionService,
ManagedContentService<Collection> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionServiceImpl.class);

    public CollectionServiceImpl(CollectionRepository repository, IdentifierService identifierService, UrlAliasService urlAliasService, HookProperties hookProperties, LocaleService localeService, CudamiConfig cudamiConfig) {
        super(repository, identifierService, urlAliasService, hookProperties, localeService, cudamiConfig);
    }

    @Override
    public boolean addChild(Collection parent, Collection child) throws ServiceException {
        try {
            return ((NodeRepository)this.repository).addChild((Identifiable)parent, (Identifiable)child);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public boolean addChildren(Collection parent, List<Collection> children) throws ServiceException {
        try {
            return ((NodeRepository)this.repository).addChildren((Identifiable)parent, children);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public boolean addDigitalObject(Collection collection, DigitalObject digitalObject) throws ServiceException {
        try {
            return ((CollectionRepository)this.repository).addDigitalObject(collection, digitalObject);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public boolean addDigitalObjects(Collection collection, List<DigitalObject> digitalObjects) throws ServiceException {
        try {
            return ((CollectionRepository)this.repository).addDigitalObjects(collection, digitalObjects);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public boolean delete(Collection collection) throws ConflictException, ServiceException {
        long amountChildrenCollections = this.findChildren(collection, PageRequest.builder().pageNumber(0).pageSize(1).build()).getTotalElements();
        if (amountChildrenCollections > 0L) {
            throw new ConflictException("Collection cannot be deleted, because it has children collections!");
        }
        long amountDigitalObjects = this.findDigitalObjects(collection, PageRequest.builder().pageNumber(0).pageSize(1).build()).getTotalElements();
        if (amountDigitalObjects > 0L) {
            throw new ConflictException("Collection cannot be deleted, because it has corresponding digital objects!");
        }
        return super.delete(collection);
    }

    @Override
    public PageResponse<Collection> find(PageRequest pageRequest) throws ServiceException {
        PageResponse pageResponse;
        try {
            pageResponse = super.find(pageRequest);
        }
        catch (ServiceException e) {
            throw new ServiceException("Backend failure", e);
        }
        this.setPublicationStatus(pageResponse.getContent());
        return pageResponse;
    }

    @Override
    public PageResponse<Collection> findActive(PageRequest pageRequest) throws ServiceException {
        Filtering filtering = ManagedContentService.filteringForActive();
        pageRequest.add(filtering);
        PageResponse<Collection> pageResponse = this.find(pageRequest);
        return pageResponse;
    }

    @Override
    public PageResponse<Collection> findActiveChildren(Collection collection, PageRequest pageRequest) throws ServiceException {
        Filtering filtering = ManagedContentService.filteringForActive();
        pageRequest.add(filtering);
        PageResponse<Collection> pageResponse = this.findChildren(collection, pageRequest);
        return pageResponse;
    }

    @Override
    public PageResponse<Collection> findByLanguageAndInitial(PageRequest pageRequest, String language, String initial) throws ServiceException {
        PageResponse pageResponse = super.findByLanguageAndInitial(pageRequest, language, initial);
        this.setPublicationStatus(pageResponse.getContent());
        return pageResponse;
    }

    @Override
    public PageResponse<Collection> findChildren(Collection collection, PageRequest pageRequest) throws ServiceException {
        PageResponse pageResponse;
        try {
            pageResponse = ((CollectionRepository)this.repository).findChildren((Identifiable)collection, pageRequest);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        this.setPublicationStatus(pageResponse.getContent());
        return pageResponse;
    }

    @Override
    public PageResponse<DigitalObject> findDigitalObjects(Collection collection, PageRequest pageRequest) throws ServiceException {
        try {
            return ((CollectionRepository)this.repository).findDigitalObjects(collection, pageRequest);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public List<CorporateBody> findRelatedCorporateBodies(Collection collection, Filtering filtering) throws ServiceException {
        try {
            return ((CollectionRepository)this.repository).findRelatedCorporateBodies(collection, filtering);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public PageResponse<Collection> findRootNodes(PageRequest pageRequest) throws ServiceException {
        PageResponse pageResponse;
        this.setDefaultSorting(pageRequest);
        try {
            pageResponse = ((NodeRepository)this.repository).findRootNodes(pageRequest);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        this.setPublicationStatus(pageResponse.getContent());
        return pageResponse;
    }

    @Override
    public List<Collection> getActiveChildren(Collection collection) throws ServiceException {
        Filtering filtering = ManagedContentService.filteringForActive();
        PageRequest pageRequest = new PageRequest();
        pageRequest.add(filtering);
        List children = this.findChildren(collection, pageRequest).getContent();
        this.setPublicationStatus(children);
        return children;
    }

    @Override
    public BreadcrumbNavigation getBreadcrumbNavigation(Collection collection) throws ServiceException {
        try {
            return ((NodeRepository)this.repository).getBreadcrumbNavigation((Identifiable)collection);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public Collection getByExample(Collection example) throws ServiceException {
        Collection collection = super.getByExample(example);
        this.setPublicationStatus(collection);
        return collection;
    }

    @Override
    public Collection getByExampleAndActive(Collection example) throws ServiceException {
        Collection collection;
        Filtering filtering = ManagedContentService.filteringForActive();
        try {
            collection = (Collection)((CollectionRepository)this.repository).getByExampleAndFiltering((UniqueObject)example, filtering);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        if (collection != null) {
            this.setPublicationStatus(collection);
            collection.setChildren(this.getActiveChildren(collection));
        }
        return collection;
    }

    @Override
    public Collection getByExampleAndActiveAndLocale(Collection example, Locale pLocale) throws ServiceException {
        Collection collection = this.getByExampleAndActive(example);
        collection = this.reduceMultilanguageFieldsToGivenLocale(collection, pLocale);
        return collection;
    }

    @Override
    public Collection getByExampleAndLocale(Collection example, Locale locale) throws ServiceException {
        Collection collection = super.getByExampleAndLocale(example, locale);
        this.setPublicationStatus(collection);
        return collection;
    }

    @Override
    public Collection getByIdentifier(Identifier identifier) throws ServiceException {
        Collection collection = (Collection)super.getByIdentifier(identifier);
        this.setPublicationStatus(collection);
        return collection;
    }

    @Override
    public Collection getByRefId(long refId) throws ServiceException {
        Collection collection = (Collection)super.getByRefId(refId);
        this.setPublicationStatus(collection);
        return collection;
    }

    @Override
    public List<Collection> getChildren(Collection collection) throws ServiceException {
        List children;
        try {
            children = ((NodeRepository)this.repository).getChildren((Identifiable)collection);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        this.setPublicationStatus(children);
        return children;
    }

    @Override
    public Collection getParent(Collection collection) throws ServiceException {
        Collection parent;
        try {
            parent = (Collection)((NodeRepository)this.repository).getParent((Identifiable)collection);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        this.setPublicationStatus(parent);
        return parent;
    }

    @Override
    public List<Collection> getParents(Collection collection) throws ServiceException {
        List parents;
        try {
            parents = ((NodeRepository)this.repository).getParents((Identifiable)collection);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
        this.setPublicationStatus(parents);
        return parents;
    }

    @Override
    public List<Collection> getRandom(int count) throws ServiceException {
        List<Collection> collections = super.getRandom(count);
        this.setPublicationStatus(collections);
        return collections;
    }

    @Override
    public List<Locale> getRootNodesLanguages() throws ServiceException {
        try {
            return ((NodeRepository)this.repository).getRootNodesLanguages();
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public boolean removeChild(Collection parent, Collection child) throws ServiceException {
        try {
            return ((NodeRepository)this.repository).removeChild((Identifiable)parent, (Identifiable)child);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public boolean removeDigitalObject(Collection collection, DigitalObject digitalObject) throws ServiceException {
        try {
            return ((CollectionRepository)this.repository).removeDigitalObject(collection, digitalObject);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public boolean removeDigitalObjectFromAllCollections(DigitalObject digitalObject) throws ServiceException {
        try {
            return ((CollectionRepository)this.repository).removeDigitalObjectFromAllCollections(digitalObject);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public void save(Collection entity) throws ServiceException, ValidationException {
        super.save(entity);
        this.setPublicationStatus(entity);
    }

    @Override
    public Collection saveWithParent(Collection child, Collection parent) throws ServiceException {
        try {
            Collection collection = (Collection)((NodeRepository)this.repository).saveWithParent((Identifiable)child, (Identifiable)parent);
            this.setPublicationStatus(collection);
            return collection;
        }
        catch (Exception e) {
            LOGGER.error("Cannot save collection " + child + ": ", (Throwable)e);
            throw new ServiceException(e.getMessage());
        }
    }

    @Override
    public boolean setDigitalObjects(Collection collection, List<DigitalObject> digitalObjects) throws ServiceException {
        try {
            return ((CollectionRepository)this.repository).setDigitalObjects(collection, digitalObjects);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }

    @Override
    public void update(Collection entity) throws ServiceException, ValidationException {
        super.update(entity);
        this.setPublicationStatus(entity);
    }

    @Override
    public boolean updateChildrenOrder(Collection parent, List<Collection> children) throws ServiceException {
        try {
            return ((NodeRepository)this.repository).updateChildrenOrder((Identifiable)parent, children);
        }
        catch (RepositoryException e) {
            throw new ServiceException("Backend failure", e);
        }
    }
}

