/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.CudamiServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifiableService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifierService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.alias.UrlAliasService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.IdentifiableUrlAliasAlignHelper;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.alias.LocalizedUrlAliases;
import de.digitalcollections.model.identifiable.alias.UrlAlias;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.FilterOperation;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import de.digitalcollections.model.text.LocalizedText;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="identifiableService")
@Transactional(rollbackFor={Exception.class})
public class IdentifiableServiceImpl<I extends Identifiable>
implements IdentifiableService<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifiableServiceImpl.class);
    private CudamiConfig cudamiConfig;
    protected IdentifierService identifierService;
    private LocaleService localeService;
    protected IdentifiableRepository<I> repository;
    private UrlAliasService urlAliasService;

    public IdentifiableServiceImpl(@Qualifier(value="identifiableRepositoryImpl") IdentifiableRepository<I> repository, IdentifierService identifierService, UrlAliasService urlAliasService, LocaleService localeService, CudamiConfig cudamiConfig) {
        this.repository = repository;
        this.identifierService = identifierService;
        this.urlAliasService = urlAliasService;
        this.localeService = localeService;
        this.cudamiConfig = cudamiConfig;
    }

    @Override
    public void addRelatedEntity(UUID identifiableUuid, UUID entityUuid) {
        this.repository.addRelatedEntity(identifiableUuid, entityUuid);
    }

    @Override
    public void addRelatedFileresource(UUID identifiableUuid, UUID fileResourceUuid) {
        this.repository.addRelatedFileresource(identifiableUuid, fileResourceUuid);
    }

    @Override
    public long count() {
        return this.repository.count();
    }

    @Override
    public boolean delete(List<UUID> uuids) throws IdentifiableServiceException {
        for (UUID uuid : uuids) {
            try {
                this.deleteIdentifiers(uuid);
            }
            catch (CudamiServiceException e) {
                throw new IdentifiableServiceException("Error while removing Identifiers. Rollback.", e);
            }
            try {
                this.urlAliasService.deleteAllForTarget(uuid, true);
            }
            catch (CudamiServiceException e) {
                throw new IdentifiableServiceException("Error while removing UrlAliases. Rollback.", e);
            }
        }
        return this.repository.delete(uuids);
    }

    private boolean deleteIdentifiers(UUID identifiableUuid) throws CudamiServiceException {
        I identifiable = this.getByUuid(identifiableUuid);
        if (identifiable == null || identifiable.getIdentifiers() == null) {
            return false;
        }
        this.identifierService.delete(identifiable.getIdentifiers());
        return true;
    }

    protected void filterByLabel(PageResponse<I> pageResponse, FilterCriterion<String> labelFilter) {
        if (!pageResponse.hasContent()) {
            return;
        }
        if (labelFilter.getOperation() == FilterOperation.EQUALS) {
            return;
        }
        Matcher matchLanguage = Pattern.compile("\\.(\\w{1,3})$").matcher(labelFilter.getExpression());
        if (matchLanguage.find()) {
            Locale language = Locale.forLanguageTag(matchLanguage.group(1));
            List<String> searchTerms = Arrays.asList(IdentifiableRepository.splitToArray((String)((String)labelFilter.getValue())));
            List filteredContent = pageResponse.getContent().parallelStream().filter(identifiable -> {
                String label = (String)identifiable.getLabel().get((Object)language);
                if (label == null) {
                    return false;
                }
                List<String> splitLabel = Arrays.asList(IdentifiableRepository.splitToArray((String)label));
                return splitLabel.containsAll(searchTerms);
            }).collect(Collectors.toList());
            pageResponse.setTotalElements(pageResponse.getTotalElements() - (long)(pageResponse.getContent().size() - filteredContent.size()));
            pageResponse.setContent(filteredContent);
        }
    }

    @Override
    public PageResponse<I> find(PageRequest pageRequest) {
        this.setDefaultSorting(pageRequest);
        FilterCriterion labelFilter = null;
        if (pageRequest.hasFiltering()) {
            labelFilter = pageRequest.getFiltering().getFilterCriteria().stream().filter(fc -> fc.getExpression().startsWith("label")).findAny().orElse(null);
        }
        PageResponse response = this.repository.find(pageRequest);
        if (labelFilter == null) {
            return response;
        }
        this.filterByLabel(response, (FilterCriterion<String>)labelFilter);
        return response;
    }

    @Override
    public List<I> find(String searchTerm, int maxResults) {
        return this.repository.find(searchTerm, maxResults);
    }

    @Override
    public PageResponse<I> findByLanguageAndInitial(PageRequest pageRequest, String language, String initial) {
        PageResponse result = this.repository.findByLanguageAndInitial(pageRequest, language, initial);
        return result;
    }

    @Override
    public List<I> getAllFull() {
        return this.repository.getAllFull();
    }

    @Override
    public List<I> getAllReduced() {
        return this.repository.getAllReduced();
    }

    @Override
    public I getByIdentifier(Identifier identifier) {
        return (I)this.repository.getByIdentifier(identifier);
    }

    @Override
    public I getByIdentifier(String namespace, String id) {
        return (I)this.repository.getByIdentifier(namespace, id);
    }

    @Override
    public I getByUuid(UUID uuid) {
        return (I)this.repository.getByUuid(uuid);
    }

    @Override
    public I getByUuidAndLocale(UUID uuid, Locale locale) throws IdentifiableServiceException {
        I identifiable = this.getByUuid(uuid);
        return this.reduceMultilanguageFieldsToGivenLocale(identifiable, locale);
    }

    @Override
    public List<Locale> getLanguages() {
        return this.repository.getLanguages();
    }

    @Override
    public List<Entity> getRelatedEntities(UUID identifiableUuid) {
        return this.repository.getRelatedEntities(identifiableUuid);
    }

    @Override
    public List<FileResource> getRelatedFileResources(UUID identifiableUuid) {
        return this.repository.getRelatedFileResources(identifiableUuid);
    }

    protected I reduceMultilanguageFieldsToGivenLocale(I identifiable, Locale locale) {
        if (identifiable == null) {
            return null;
        }
        LocalizedText label = identifiable.getLabel();
        if (!(label.containsKey((Object)locale) && locale != null || label.containsKey((Object)(locale = new Locale(this.localeService.getDefaultLanguage()))))) {
            locale = (Locale)label.getLocales().iterator().next();
        }
        if (locale == null) {
            return null;
        }
        Locale fLocale = locale;
        label.entrySet().removeIf(entry -> !((Locale)entry.getKey()).equals(fLocale));
        if (identifiable.getDescription() != null) {
            identifiable.getDescription().entrySet().removeIf(entry -> !((Locale)entry.getKey()).equals(fLocale));
        }
        return identifiable;
    }

    @Override
    public I save(I identifiable) throws IdentifiableServiceException, ValidationException {
        Identifiable savedIdentifiable;
        try {
            this.identifierService.validate(identifiable.getIdentifiers());
        }
        catch (CudamiServiceException e) {
            throw new IdentifiableServiceException(e.getMessage());
        }
        try {
            savedIdentifiable = this.repository.save(identifiable);
        }
        catch (Exception e) {
            throw new IdentifiableServiceException("Cannot save identifiable " + identifiable + ": " + e, e);
        }
        try {
            savedIdentifiable.setIdentifiers(this.identifierService.saveForIdentifiable(savedIdentifiable.getUuid(), identifiable.getIdentifiers()));
        }
        catch (CudamiServiceException e) {
            LOGGER.error(String.format("Cannot save Identifiers %s: %s for %s", identifiable.getIdentifiers(), e.getMessage(), identifiable), (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
        try {
            savedIdentifiable.setLocalizedUrlAliases(identifiable.getLocalizedUrlAliases());
            IdentifiableUrlAliasAlignHelper.checkDefaultAliases(savedIdentifiable, this.cudamiConfig, this.urlAliasService::generateSlug);
            this.urlAliasService.validate(identifiable.getLocalizedUrlAliases());
            if (savedIdentifiable.getLocalizedUrlAliases() != null && !savedIdentifiable.getLocalizedUrlAliases().isEmpty()) {
                LocalizedUrlAliases savedUrlAliases = new LocalizedUrlAliases();
                for (UrlAlias urlAlias : savedIdentifiable.getLocalizedUrlAliases().flatten()) {
                    urlAlias.setTargetUuid(savedIdentifiable.getUuid());
                    UrlAlias savedAlias = this.urlAliasService.save(urlAlias);
                    savedUrlAliases.add(new UrlAlias[]{savedAlias});
                }
                savedIdentifiable.setLocalizedUrlAliases(savedUrlAliases);
            }
        }
        catch (CudamiServiceException e) {
            LOGGER.error(String.format("Cannot save UrlAliases for: %s", identifiable), (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
        return (I)savedIdentifiable;
    }

    protected void setDefaultSorting(PageRequest pageRequest) {
        if (!pageRequest.hasSorting()) {
            Sorting sorting = new Sorting(new Order[]{new Order(Direction.DESC, "lastModified"), new Order("uuid")});
            pageRequest.setSorting(sorting);
        }
    }

    @Override
    public List<Entity> setRelatedEntities(UUID identifiableUuid, List<Entity> entities) {
        return this.repository.setRelatedEntities(identifiableUuid, entities);
    }

    @Override
    public List<FileResource> setRelatedFileResources(UUID identifiableUuid, List<FileResource> fileResources) {
        return this.repository.setRelatedFileResources(identifiableUuid, fileResources);
    }

    @Override
    public I update(I identifiable) throws IdentifiableServiceException, ValidationException {
        try {
            this.identifierService.validate(identifiable.getIdentifiers());
        }
        catch (CudamiServiceException e) {
            throw new IdentifiableServiceException(e.getMessage());
        }
        Identifiable identifiableInDb = this.repository.getByUuid(identifiable.getUuid());
        try {
            this.repository.update(identifiable);
        }
        catch (Exception e) {
            throw new IdentifiableServiceException("Cannot update identifiable " + identifiable + ": " + e, e);
        }
        try {
            Set existingIdentifiers = identifiableInDb.getIdentifiers();
            Set providedIdentifiers = identifiable.getIdentifiers();
            Set<Identifier> obsoleteIdentifiers = existingIdentifiers.stream().filter(i -> !providedIdentifiers.contains(i)).collect(Collectors.toSet());
            Set<Identifier> missingIdentifiers = providedIdentifiers.stream().filter(i -> !existingIdentifiers.contains(i)).collect(Collectors.toSet());
            if (!obsoleteIdentifiers.isEmpty()) {
                this.identifierService.delete(obsoleteIdentifiers);
            }
            if (!missingIdentifiers.isEmpty()) {
                this.identifierService.saveForIdentifiable(identifiable.getUuid(), missingIdentifiers);
            }
        }
        catch (CudamiServiceException e) {
            LOGGER.error(String.format("Cannot save Identifiers %s: %s for %s", identifiable.getIdentifiers(), e.getMessage(), identifiable), (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
        try {
            if (IdentifiableUrlAliasAlignHelper.checkIdentifiableExcluded(identifiable, this.cudamiConfig)) {
                return (I)this.repository.getByUuid(identifiable.getUuid());
            }
            IdentifiableUrlAliasAlignHelper.alignForUpdate(identifiable, identifiableInDb, this.cudamiConfig, this.urlAliasService::generateSlug);
            this.urlAliasService.deleteAllForTarget(identifiable.getUuid());
            try {
                this.urlAliasService.validate(identifiable.getLocalizedUrlAliases());
            }
            catch (ValidationException e) {
                throw new ValidationException("Validation error: " + e, e);
            }
            if (identifiable.getLocalizedUrlAliases() != null) {
                for (UrlAlias urlAlias : identifiable.getLocalizedUrlAliases().flatten()) {
                    if (urlAlias.getUuid() != null && urlAlias.getLastPublished() != null) {
                        this.urlAliasService.update(urlAlias);
                        continue;
                    }
                    this.urlAliasService.save(urlAlias, true);
                }
            }
        }
        catch (CudamiServiceException e) {
            LOGGER.error("Error while updating URL aliases for " + identifiable, (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage(), e);
        }
        return (I)this.repository.getByUuid(identifiable.getUuid());
    }
}

