/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.web;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.NodeRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.web.WebpageRepository;
import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifierService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.alias.UrlAliasService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.web.WebpageService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.IdentifiableServiceImpl;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.alias.LocalizedUrlAliases;
import de.digitalcollections.model.identifiable.alias.UrlAlias;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebpageServiceImpl
extends IdentifiableServiceImpl<Webpage>
implements WebpageService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebpageServiceImpl.class);

    @Autowired
    public WebpageServiceImpl(WebpageRepository repository, IdentifierService identifierService, UrlAliasService urlAliasService, LocaleService localeService, CudamiConfig cudamiConfig) {
        super(repository, identifierService, urlAliasService, localeService, cudamiConfig);
    }

    @Override
    public boolean addChildren(UUID parentUuid, List<UUID> childrenUuids) {
        return ((NodeRepository)this.repository).addChildren(parentUuid, childrenUuids);
    }

    @Override
    public PageResponse<Webpage> findActiveChildren(UUID uuid, PageRequest pageRequest) {
        Filtering filtering = this.filteringForActive();
        pageRequest.add(filtering);
        return this.findChildren(uuid, pageRequest);
    }

    @Override
    public PageResponse<Webpage> findChildren(UUID uuid, PageRequest pageRequest) {
        return ((NodeRepository)this.repository).findChildren(uuid, pageRequest);
    }

    @Override
    public PageResponse<Webpage> findRootNodes(PageRequest pageRequest) {
        return ((NodeRepository)this.repository).findRootNodes(pageRequest);
    }

    @Override
    public PageResponse<Webpage> findRootWebpagesForWebsite(UUID websiteUuid, PageRequest pageRequest) {
        return ((WebpageRepository)this.repository).findRootWebpagesForWebsite(websiteUuid, pageRequest);
    }

    @Override
    public Webpage getActive(UUID uuid) {
        Filtering filtering = this.filteringForActive();
        Webpage webpage = (Webpage)((WebpageRepository)this.repository).getByUuidAndFiltering(uuid, filtering);
        if (webpage != null) {
            webpage.setChildren(this.getActiveChildren(uuid));
        }
        return webpage;
    }

    @Override
    public Webpage getActive(UUID uuid, Locale pLocale) {
        Webpage webpage = this.getActive(uuid);
        return this.reduceMultilanguageFieldsToGivenLocale(webpage, pLocale);
    }

    @Override
    public List<Webpage> getActiveChildren(UUID uuid) {
        Filtering filtering = this.filteringForActive();
        PageRequest pageRequest = new PageRequest();
        pageRequest.add(filtering);
        return this.findChildren(uuid, pageRequest).getContent();
    }

    @Override
    public List<Webpage> getActiveChildrenTree(UUID uuid) {
        List<Webpage> webpages = this.getActiveChildren(uuid);
        return webpages.stream().peek(w -> w.setChildren(this.getActiveChildrenTree(w.getUuid()))).collect(Collectors.toList());
    }

    @Override
    public BreadcrumbNavigation getBreadcrumbNavigation(UUID uuid) {
        return ((NodeRepository)this.repository).getBreadcrumbNavigation(uuid);
    }

    @Override
    public List<Webpage> getChildren(Webpage webpage) {
        return ((NodeRepository)this.repository).getChildren((Identifiable)webpage);
    }

    @Override
    public List<Webpage> getChildren(UUID uuid) {
        return ((NodeRepository)this.repository).getChildren(uuid);
    }

    @Override
    public List<Webpage> getChildrenTree(UUID uuid) {
        List<Webpage> webpages = this.getChildren(uuid);
        return webpages.stream().peek(w -> w.setChildren(this.getChildrenTree(w.getUuid()))).collect(Collectors.toList());
    }

    @Override
    public Webpage getParent(UUID webpageUuid) {
        return (Webpage)((NodeRepository)this.repository).getParent(webpageUuid);
    }

    @Override
    public List<Webpage> getParents(UUID uuid) {
        return ((NodeRepository)this.repository).getParents(uuid);
    }

    @Override
    public List<Locale> getRootNodesLanguages() {
        return ((NodeRepository)this.repository).getRootNodesLanguages();
    }

    @Override
    public Website getWebsite(UUID webpageUuid) {
        UUID rootWebpageUuid = webpageUuid;
        Webpage parent = this.getParent(webpageUuid);
        while (parent != null) {
            rootWebpageUuid = parent.getUuid();
            parent = this.getParent(parent);
        }
        return ((WebpageRepository)this.repository).getWebsite(rootWebpageUuid);
    }

    @Override
    public boolean removeChild(UUID parentUuid, UUID childUuid) {
        return ((NodeRepository)this.repository).removeChild(parentUuid, childUuid);
    }

    @Override
    public Webpage save(Webpage identifiable) throws IdentifiableServiceException, ValidationException {
        if (identifiable.getLocalizedUrlAliases() != null && !identifiable.getLocalizedUrlAliases().isEmpty()) {
            this.validate(identifiable.getLocalizedUrlAliases());
        }
        return super.save(identifiable);
    }

    @Override
    public Webpage saveWithParent(UUID childUuid, UUID parentUuid) throws IdentifiableServiceException {
        try {
            return (Webpage)((NodeRepository)this.repository).saveWithParent(childUuid, parentUuid);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save webpage " + childUuid + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    @Override
    public Webpage saveWithParentWebsite(Webpage webpage, UUID parentWebsiteUuid) throws IdentifiableServiceException {
        try {
            if (webpage.getUuid() == null) {
                webpage = this.save(webpage);
            }
            return ((WebpageRepository)this.repository).saveWithParentWebsite(webpage.getUuid(), parentWebsiteUuid);
        }
        catch (IdentifiableServiceException | ValidationException e) {
            LOGGER.error("Cannot save top-level webpage " + webpage + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    @Override
    public Webpage update(Webpage identifiable) throws IdentifiableServiceException, ValidationException {
        if (identifiable.getLocalizedUrlAliases() != null && !identifiable.getLocalizedUrlAliases().isEmpty()) {
            this.validate(identifiable.getLocalizedUrlAliases());
        }
        return super.update(identifiable);
    }

    @Override
    public boolean updateChildrenOrder(UUID parentUuid, List<Webpage> children) {
        return ((NodeRepository)this.repository).updateChildrenOrder(parentUuid, children);
    }

    private void validate(LocalizedUrlAliases localizedUrlAliases) throws ValidationException {
        for (UrlAlias urlAlias : localizedUrlAliases.flatten()) {
            if (urlAlias.getWebsite() != null && urlAlias.getWebsite().getUuid() != null) continue;
            throw new ValidationException("Empty website for " + urlAlias);
        }
    }
}

