/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable;

import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierTypeRepository;
import de.digitalcollections.cudami.server.business.api.service.exceptions.CudamiServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifierTypeService;
import de.digitalcollections.model.identifiable.IdentifierType;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.Sorting;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="identifierTypeService")
@Transactional(rollbackFor={Exception.class})
public class IdentifierTypeServiceImpl
implements IdentifierTypeService {
    private final IdentifierTypeRepository repository;
    private Map<String, String> identifierTypeCache;

    @Autowired
    public IdentifierTypeServiceImpl(IdentifierTypeRepository repository) throws CudamiServiceException {
        this.repository = repository;
        this.updateIdentifierTypeCache();
    }

    @Override
    public long count() {
        return this.repository.count();
    }

    @Override
    public void delete(List<UUID> uuids) {
        this.repository.delete(uuids);
    }

    @Override
    public PageResponse<IdentifierType> find(PageRequest pageRequest) {
        this.setDefaultSorting(pageRequest);
        return this.repository.find(pageRequest);
    }

    @Override
    public IdentifierType getByNamespace(String namespace) {
        return this.repository.getByNamespace(namespace);
    }

    @Override
    public IdentifierType getByUuid(UUID uuid) {
        return this.repository.getByUuid(uuid);
    }

    @Override
    public Map<String, String> getIdentifierTypeCache() {
        return this.identifierTypeCache;
    }

    @Override
    public IdentifierType save(IdentifierType identifierType) {
        IdentifierType saved = this.repository.save(identifierType);
        if (saved != null) {
            this.identifierTypeCache.put(saved.getNamespace(), saved.getPattern());
        }
        return saved;
    }

    private void setDefaultSorting(PageRequest pageRequest) {
        if (!pageRequest.hasSorting()) {
            Sorting sorting = new Sorting(Direction.ASC, new String[]{"namespace", "uuid"});
            pageRequest.setSorting(sorting);
        }
    }

    @Override
    public IdentifierType update(IdentifierType identifierType) {
        IdentifierType updated = this.repository.update(identifierType);
        if (updated != null) {
            this.identifierTypeCache.put(updated.getNamespace(), updated.getPattern());
        }
        return updated;
    }

    @Override
    public Map<String, String> updateIdentifierTypeCache() throws CudamiServiceException {
        try {
            this.identifierTypeCache = this.repository.findAll().stream().collect(Collectors.toConcurrentMap(IdentifierType::getNamespace, IdentifierType::getPattern));
        }
        catch (RepositoryException e) {
            throw new CudamiServiceException(e);
        }
        return this.identifierTypeCache;
    }
}

