/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.api.service.identifiable.entity;

import de.digitalcollections.cudami.server.business.api.service.exceptions.CudamiServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.EntityService;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.identifiable.entity.Project;
import de.digitalcollections.model.identifiable.entity.work.Item;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.identifiable.resource.LinkedDataFileResource;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public interface DigitalObjectService
extends EntityService<DigitalObject> {
    public void deleteFileResources(UUID var1);

    public PageResponse<Collection> findActiveCollections(DigitalObject var1, PageRequest var2);

    default public PageResponse<Collection> findCollections(DigitalObject digitalObject, PageRequest pageRequest) {
        return this.findCollections(digitalObject.getUuid(), pageRequest);
    }

    public PageResponse<Collection> findCollections(UUID var1, PageRequest var2);

    default public PageResponse<Project> findProjects(DigitalObject digitalObject, PageRequest pageRequest) {
        return this.findProjects(digitalObject.getUuid(), pageRequest);
    }

    public PageResponse<Project> findProjects(UUID var1, PageRequest var2);

    default public List<FileResource> getFileResources(DigitalObject digitalObject) {
        return this.getFileResources(digitalObject.getUuid());
    }

    public List<FileResource> getFileResources(UUID var1);

    default public List<ImageFileResource> getImageFileResources(DigitalObject digitalObject) {
        return this.getImageFileResources(digitalObject.getUuid());
    }

    public List<ImageFileResource> getImageFileResources(UUID var1);

    default public Item getItem(DigitalObject digitalObject) {
        if (digitalObject == null) {
            return null;
        }
        return this.getItem(digitalObject.getUuid());
    }

    public Item getItem(UUID var1);

    public List<Locale> getLanguagesOfCollections(UUID var1);

    public List<Locale> getLanguagesOfContainedDigitalObjects(UUID var1);

    public List<Locale> getLanguagesOfProjects(UUID var1);

    default public List<LinkedDataFileResource> getLinkedDataFileResources(DigitalObject digitalObject) {
        return this.getLinkedDataFileResources(digitalObject.getUuid());
    }

    public List<LinkedDataFileResource> getLinkedDataFileResources(UUID var1);

    default public List<FileResource> getRenderingResources(DigitalObject digitalObject) throws CudamiServiceException {
        return this.getRenderingResources(digitalObject.getUuid());
    }

    public List<FileResource> getRenderingResources(UUID var1) throws CudamiServiceException;

    default public List<FileResource> setFileResources(DigitalObject digitalObject, List<FileResource> fileResources) {
        if (fileResources == null) {
            return null;
        }
        return this.setFileResources(digitalObject.getUuid(), fileResources);
    }

    public List<FileResource> setFileResources(UUID var1, List<FileResource> var2);

    default public List<LinkedDataFileResource> setLinkedDataFileResources(DigitalObject digitalObject, List<LinkedDataFileResource> linkedDataFileResources) {
        if (linkedDataFileResources == null) {
            return null;
        }
        return this.setLinkedDataFileResources(digitalObject.getUuid(), linkedDataFileResources);
    }

    public List<LinkedDataFileResource> setLinkedDataFileResources(UUID var1, List<LinkedDataFileResource> var2);

    default public List<FileResource> setRenderingFileResources(DigitalObject digitalObject, List<FileResource> renderingFileResources) throws CudamiServiceException {
        if (renderingFileResources == null) {
            return null;
        }
        return this.setRenderingFileResources(digitalObject.getUuid(), renderingFileResources);
    }

    public List<FileResource> setRenderingFileResources(UUID var1, List<FileResource> var2) throws CudamiServiceException;
}

