/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.security;

import de.digitalcollections.cudami.server.backend.api.repository.security.UserRepository;
import de.digitalcollections.cudami.server.business.api.service.security.UserService;
import de.digitalcollections.cudami.server.business.impl.validator.UniqueUsernameValidator;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.Sorting;
import de.digitalcollections.model.security.Role;
import de.digitalcollections.model.security.User;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.validation.Errors;

@Service
public class UserServiceImpl
implements UserService<User>,
InitializingBean {
    private UniqueUsernameValidator uniqueUsernameValidator;
    private final UserRepository userRepository;

    public UserServiceImpl(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    @Override
    public User activate(UUID uuid) {
        User user = this.userRepository.getByUuid(uuid);
        user.setEnabled(true);
        user = this.userRepository.save(user);
        return user;
    }

    public void afterPropertiesSet() {
        this.uniqueUsernameValidator = new UniqueUsernameValidator(this);
    }

    @Override
    public User createAdminUser() {
        User user = this.userRepository.create();
        user.getRoles().add(Role.ADMIN);
        return user;
    }

    @Override
    public User deactivate(UUID uuid) {
        User user = this.userRepository.getByUuid(uuid);
        user.setEnabled(false);
        user = this.userRepository.save(user);
        return user;
    }

    @Override
    public boolean doesActiveAdminUserExist() {
        List findActiveAdminUsers = this.userRepository.getActiveAdminUsers();
        return findActiveAdminUsers != null && !findActiveAdminUsers.isEmpty();
    }

    @Override
    public PageResponse<User> find(PageRequest pageRequest) {
        this.setDefaultSorting(pageRequest);
        return this.userRepository.find(pageRequest);
    }

    @Override
    public List<User> getActiveAdminUsers() {
        return this.userRepository.getActiveAdminUsers();
    }

    @Override
    public User getByUuid(UUID uuid) {
        return this.userRepository.getByUuid(uuid);
    }

    @Override
    public User getByUsername(String username) throws UsernameNotFoundException {
        User user = this.userRepository.getByEmail(username);
        if (user == null || !user.isEnabled()) {
            throw new UsernameNotFoundException(String.format("User \"%s\" was not found.", username));
        }
        return user;
    }

    @Override
    public User save(User user, Errors results) {
        this.uniqueUsernameValidator.validate(user, results);
        if (!results.hasErrors()) {
            return this.userRepository.save(user);
        }
        return null;
    }

    private void setDefaultSorting(PageRequest pageRequest) {
        if (!pageRequest.hasSorting()) {
            Sorting sorting = new Sorting(Direction.ASC, new String[]{"email"});
            pageRequest.setSorting(sorting);
        }
    }

    @Override
    public User update(User user, Errors results) {
        return this.userRepository.update(user);
    }
}

