/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.entity;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifierService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.alias.UrlAliasService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.EntityService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.IdentifiableServiceImpl;
import de.digitalcollections.cudami.server.config.HookProperties;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.EntityType;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="entityService")
public class EntityServiceImpl<E extends Entity>
extends IdentifiableServiceImpl<E>
implements EntityService<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityServiceImpl.class);
    protected HookProperties hookProperties;
    protected HttpClient httpClient = HttpClient.newHttpClient();

    public EntityServiceImpl(@Qualifier(value="entityRepositoryImpl") EntityRepository<E> repository, IdentifierService identifierService, UrlAliasService urlAliasService, HookProperties hookProperties, LocaleService localeService, CudamiConfig cudamiConfig) {
        super(repository, identifierService, urlAliasService, localeService, cudamiConfig);
        this.hookProperties = hookProperties;
    }

    @Override
    public void addRelatedFileresource(E entity, FileResource fileResource) {
        ((EntityRepository)this.repository).addRelatedFileresource(entity, fileResource);
    }

    @Override
    public void addRelatedFileresource(UUID entityUuid, UUID fileResourceUuid) {
        ((EntityRepository)this.repository).addRelatedFileresource(entityUuid, fileResourceUuid);
    }

    protected URI buildNotificationUrl(String urlTemplate, UUID entityUuid, EntityType entityType) {
        String url = String.format(urlTemplate, entityUuid, entityType);
        try {
            return new URL(url).toURI();
        }
        catch (MalformedURLException | URISyntaxException e) {
            LOGGER.warn("Something went wrong when creating the notification url: {}", (Object)e.getMessage());
            return null;
        }
    }

    protected Filtering filteringForActive() {
        LocalDate now = LocalDate.now();
        Filtering filtering = Filtering.builder().add(FilterCriterion.builder().withExpression("publicationStart").lessOrEqualAndSet((Object)now).build()).add(FilterCriterion.builder().withExpression("publicationEnd").greaterOrNotSet((Object)now).build()).build();
        return filtering;
    }

    @Override
    public E getByRefId(long refId) {
        return (E)((EntityRepository)this.repository).getByRefId(refId);
    }

    @Override
    public List<E> getRandom(int count) {
        return ((EntityRepository)this.repository).getRandom(count);
    }

    @Override
    public List<FileResource> getRelatedFileResources(E entity) {
        return ((EntityRepository)this.repository).getRelatedFileResources(entity);
    }

    @Override
    public List<FileResource> getRelatedFileResources(UUID entityUuid) {
        return ((EntityRepository)this.repository).getRelatedFileResources(entityUuid);
    }

    @Override
    public E save(E entity) throws IdentifiableServiceException, ValidationException {
        try {
            Entity entityDb = (Entity)super.save(entity);
            this.sendNotification("save", "POST", entityDb.getUuid(), entityDb.getEntityType());
            return (E)entityDb;
        }
        catch (IdentifiableServiceException e) {
            LOGGER.error("Cannot save entity " + entity + ": ", (Throwable)e);
            throw e;
        }
    }

    @Override
    public List<FileResource> setRelatedFileResources(E entity, List<FileResource> fileResources) {
        return ((EntityRepository)this.repository).setRelatedFileResources(entity, fileResources);
    }

    @Override
    public List<FileResource> setRelatedFileResources(UUID entityUuid, List<FileResource> fileResources) {
        return ((EntityRepository)this.repository).setRelatedFileResources(entityUuid, fileResources);
    }

    protected void sendNotification(String action, String httpVerb, UUID uuid, EntityType entityType) {
        Optional<String> hook = this.hookProperties.getHookForActionAndType(action, entityType);
        if (hook.isEmpty()) {
            return;
        }
        URI url = this.buildNotificationUrl(hook.get(), uuid, entityType);
        if (url == null) {
            LOGGER.warn("No url given, ignoring.");
            return;
        }
        HttpRequest request = HttpRequest.newBuilder().uri(url).method(httpVerb, HttpRequest.BodyPublishers.noBody()).build();
        try {
            HttpResponse<Void> response = this.httpClient.send(request, HttpResponse.BodyHandlers.discarding());
            int statusCode = response.statusCode();
            if (statusCode >= 400) {
                LOGGER.warn("Sending a notification to {} with verb {} gave an error status code {}.", new Object[]{url, httpVerb, statusCode});
            }
        }
        catch (IOException | InterruptedException e) {
            LOGGER.warn("Something went wrong when sending a notification to {}: {}", (Object)url, (Object)e.getMessage());
        }
    }

    @Override
    public E update(E entity) throws IdentifiableServiceException, ValidationException {
        try {
            Entity entityDb = (Entity)super.update(entity);
            this.sendNotification("update", "PUT", entityDb.getUuid(), entityDb.getEntityType());
            return (E)entityDb;
        }
        catch (IdentifiableServiceException e) {
            LOGGER.error("Cannot update identifiable " + entity + ": ", (Throwable)e);
            throw e;
        }
    }
}

