/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.CudamiServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.exceptions.ValidationException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifiableService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.alias.UrlAliasService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.IdentifiableUrlAliasAlignHelper;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.alias.LocalizedUrlAliases;
import de.digitalcollections.model.identifiable.alias.UrlAlias;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import de.digitalcollections.model.text.LocalizedText;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="identifiableService")
@Transactional(rollbackFor={Exception.class})
public class IdentifiableServiceImpl<I extends Identifiable>
implements IdentifiableService<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifiableServiceImpl.class);
    private CudamiConfig cudamiConfig;
    protected IdentifierRepository identifierRepository;
    private LocaleService localeService;
    protected IdentifiableRepository<I> repository;
    private UrlAliasService urlAliasService;

    public IdentifiableServiceImpl(@Qualifier(value="identifiableRepositoryImpl") IdentifiableRepository<I> repository, IdentifierRepository identifierRepository, UrlAliasService urlAliasService, LocaleService localeService, CudamiConfig cudamiConfig) {
        this.repository = repository;
        this.identifierRepository = identifierRepository;
        this.urlAliasService = urlAliasService;
        this.localeService = localeService;
        this.cudamiConfig = cudamiConfig;
    }

    @Override
    public void addRelatedEntity(UUID identifiableUuid, UUID entityUuid) {
        this.repository.addRelatedEntity(identifiableUuid, entityUuid);
    }

    @Override
    public void addRelatedFileresource(UUID identifiableUuid, UUID fileResourceUuid) {
        this.repository.addRelatedFileresource(identifiableUuid, fileResourceUuid);
    }

    @Override
    public long count() {
        return this.repository.count();
    }

    @Override
    public boolean delete(List<UUID> uuids) throws IdentifiableServiceException {
        for (UUID uuid : uuids) {
            try {
                this.urlAliasService.deleteAllForTarget(uuid, true);
                this.deleteIdentifiers(uuid);
            }
            catch (CudamiServiceException e) {
                throw new IdentifiableServiceException("Error while removing UrlAliases. Rollback.", e);
            }
        }
        return this.repository.delete(uuids);
    }

    @Override
    public boolean deleteIdentifiers(UUID identifiableUuid) {
        Identifiable identifiable = this.repository.getByUuid(identifiableUuid);
        if (identifiable == null || identifiable.getIdentifiers() == null) {
            return false;
        }
        this.identifierRepository.delete(identifiable.getIdentifiers().stream().map(UniqueObject::getUuid).collect(Collectors.toList()));
        return true;
    }

    @Override
    public PageResponse<I> find(PageRequest pageRequest) {
        this.setDefaultSorting(pageRequest);
        return this.repository.find(pageRequest);
    }

    @Override
    public List<I> find(String searchTerm, int maxResults) {
        return this.repository.find(searchTerm, maxResults);
    }

    @Override
    public PageResponse<I> findByLanguageAndInitial(PageRequest pageRequest, String language, String initial) {
        PageResponse result = this.repository.findByLanguageAndInitial(pageRequest, language, initial);
        return result;
    }

    @Override
    public List<I> getAllFull() {
        return this.repository.getAllFull();
    }

    @Override
    public List<I> getAllReduced() {
        return this.repository.getAllReduced();
    }

    @Override
    public I getByIdentifier(Identifier identifier) {
        return (I)this.repository.getByIdentifier(identifier);
    }

    @Override
    public I getByIdentifier(String namespace, String id) {
        return (I)this.repository.getByIdentifier(namespace, id);
    }

    @Override
    public I getByUuid(UUID uuid) {
        return (I)this.repository.getByUuid(uuid);
    }

    @Override
    public I getByUuidAndLocale(UUID uuid, Locale locale) throws IdentifiableServiceException {
        I identifiable = this.getByUuid(uuid);
        return this.reduceMultilanguageFieldsToGivenLocale(identifiable, locale);
    }

    @Override
    public List<Locale> getLanguages() {
        return this.repository.getLanguages();
    }

    @Override
    public List<Entity> getRelatedEntities(UUID identifiableUuid) {
        return this.repository.getRelatedEntities(identifiableUuid);
    }

    @Override
    public List<FileResource> getRelatedFileResources(UUID identifiableUuid) {
        return this.repository.getRelatedFileResources(identifiableUuid);
    }

    protected I reduceMultilanguageFieldsToGivenLocale(I identifiable, Locale locale) {
        if (identifiable == null) {
            return null;
        }
        LocalizedText label = identifiable.getLabel();
        if (!(label.containsKey((Object)locale) && locale != null || label.containsKey((Object)(locale = new Locale(this.localeService.getDefaultLanguage()))))) {
            locale = (Locale)label.getLocales().iterator().next();
        }
        if (locale == null) {
            return null;
        }
        Locale fLocale = locale;
        label.entrySet().removeIf(entry -> !((Locale)entry.getKey()).equals(fLocale));
        if (identifiable.getDescription() != null) {
            identifiable.getDescription().entrySet().removeIf(entry -> !((Locale)entry.getKey()).equals(fLocale));
        }
        return identifiable;
    }

    @Override
    public I save(I identifiable) throws IdentifiableServiceException, ValidationException {
        try {
            Identifiable savedIdentifiable = this.repository.save(identifiable);
            this.saveIdentifiers(identifiable.getIdentifiers(), savedIdentifiable);
            savedIdentifiable.setLocalizedUrlAliases(identifiable.getLocalizedUrlAliases());
            IdentifiableUrlAliasAlignHelper.checkDefaultAliases(savedIdentifiable, this.cudamiConfig, this.urlAliasService::generateSlug);
            try {
                this.urlAliasService.validate(identifiable.getLocalizedUrlAliases());
            }
            catch (Exception e) {
                throw new ValidationException("Validation error: " + e, e);
            }
            if (savedIdentifiable.getLocalizedUrlAliases() != null && !savedIdentifiable.getLocalizedUrlAliases().isEmpty()) {
                LocalizedUrlAliases savedUrlAliases = new LocalizedUrlAliases();
                for (UrlAlias urlAlias : savedIdentifiable.getLocalizedUrlAliases().flatten()) {
                    urlAlias.setTargetUuid(savedIdentifiable.getUuid());
                    UrlAlias savedAlias = this.urlAliasService.save(urlAlias);
                    savedUrlAliases.add(new UrlAlias[]{savedAlias});
                }
                savedIdentifiable.setLocalizedUrlAliases(savedUrlAliases);
            }
            return (I)savedIdentifiable;
        }
        catch (CudamiServiceException e) {
            LOGGER.error(String.format("Cannot save UrlAliases for: %s", identifiable), (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
        catch (Exception e) {
            LOGGER.error("Cannot save identifiable " + identifiable + ": " + e, (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    public void saveIdentifiers(Set<Identifier> identifiers, Identifiable identifiable) {
        if (identifiers != null) {
            for (Identifier identifier : identifiers) {
                identifier.setIdentifiable(identifiable.getUuid());
                Identifier savedIdentifier = identifier.getUuid() == null ? this.identifierRepository.save(identifier) : this.identifierRepository.getByUuid(identifier.getUuid());
                identifiable.addIdentifier(savedIdentifier);
            }
        }
    }

    protected void setDefaultSorting(PageRequest pageRequest) {
        if (!pageRequest.hasSorting()) {
            Sorting sorting = new Sorting(new Order[]{new Order(Direction.DESC, "lastModified"), new Order("uuid")});
            pageRequest.setSorting(sorting);
        }
    }

    @Override
    public List<Entity> setRelatedEntities(UUID identifiableUuid, List<Entity> entities) {
        return this.repository.setRelatedEntities(identifiableUuid, entities);
    }

    @Override
    public List<FileResource> setRelatedFileResources(UUID identifiableUuid, List<FileResource> fileResources) {
        return this.repository.setRelatedFileResources(identifiableUuid, fileResources);
    }

    @Override
    public I update(I identifiable) throws IdentifiableServiceException, ValidationException {
        Identifiable identifiableInDb;
        try {
            identifiableInDb = this.repository.getByUuid(identifiable.getUuid());
            this.repository.update(identifiable);
            Map<String, Identifier> existingIdentifierMap = this.identifierRepository.findByIdentifiable(identifiable.getUuid()).stream().collect(Collectors.toMap(i -> i.getNamespace() + ":" + i.getId(), i -> i));
            Set<String> existingIdentifiersByNamespaceAndId = existingIdentifierMap.keySet();
            Map<String, Identifier> providedIdentifierMap = identifiable.getIdentifiers().stream().collect(Collectors.toMap(i -> i.getNamespace() + ":" + i.getId(), i -> {
                i.setIdentifiable(identifiable.getUuid());
                return i;
            }));
            Set<String> providedIdentifiersByNamespaceAndId = providedIdentifierMap.keySet();
            HashSet<String> obsoleteIdentifiers = new HashSet<String>(existingIdentifiersByNamespaceAndId);
            obsoleteIdentifiers.removeAll(providedIdentifiersByNamespaceAndId);
            HashSet<String> missingIdentifiers = new HashSet<String>(providedIdentifiersByNamespaceAndId);
            missingIdentifiers.removeAll(existingIdentifiersByNamespaceAndId);
            if (!missingIdentifiers.isEmpty()) {
                missingIdentifiers.forEach(i -> this.identifierRepository.save((Identifier)providedIdentifierMap.get(i)));
            }
            if (!obsoleteIdentifiers.isEmpty()) {
                obsoleteIdentifiers.forEach(i -> this.identifierRepository.delete(((Identifier)existingIdentifierMap.get(i)).getUuid()));
            }
        }
        catch (Exception e) {
            LOGGER.error("Cannot update identifiable " + identifiable + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
        try {
            if (IdentifiableUrlAliasAlignHelper.checkIdentifiableExcluded(identifiable, this.cudamiConfig)) {
                return (I)this.repository.getByUuid(identifiable.getUuid());
            }
            IdentifiableUrlAliasAlignHelper.alignForUpdate(identifiable, identifiableInDb, this.cudamiConfig, this.urlAliasService::generateSlug);
            this.urlAliasService.deleteAllForTarget(identifiable.getUuid());
            try {
                this.urlAliasService.validate(identifiable.getLocalizedUrlAliases());
            }
            catch (ValidationException e) {
                throw new ValidationException("Validation error: " + e, e);
            }
            if (identifiable.getLocalizedUrlAliases() != null) {
                for (UrlAlias urlAlias : identifiable.getLocalizedUrlAliases().flatten()) {
                    if (urlAlias.getUuid() != null && urlAlias.getLastPublished() != null) {
                        this.urlAliasService.update(urlAlias);
                        continue;
                    }
                    this.urlAliasService.save(urlAlias, true);
                }
            }
        }
        catch (CudamiServiceException e) {
            LOGGER.error("Error while updating URL aliases for " + identifiable, (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage(), e);
        }
        return (I)this.repository.getByUuid(identifiable.getUuid());
    }
}

