/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.entity;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.WebsiteRepository;
import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.alias.UrlAliasService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.WebsiteService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.web.WebpageService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.entity.EntityServiceImpl;
import de.digitalcollections.cudami.server.config.HookProperties;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebsiteServiceImpl
extends EntityServiceImpl<Website>
implements WebsiteService {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsiteServiceImpl.class);
    private final WebpageService webpageService;

    @Autowired
    public WebsiteServiceImpl(WebsiteRepository repository, IdentifierRepository identifierRepository, UrlAliasService urlAliasService, HookProperties hookProperties, CudamiConfig cudamiConfig, LocaleService localeService, WebpageService webpageService) {
        super(repository, identifierRepository, urlAliasService, hookProperties, localeService, cudamiConfig);
        this.webpageService = webpageService;
    }

    @Override
    public PageResponse<Webpage> findRootWebpages(UUID uuid, PageRequest pageRequest) {
        return this.webpageService.findRootWebpagesForWebsite(uuid, pageRequest);
    }

    @Override
    public List<Webpage> getRootWebpages(UUID uuid) {
        return ((WebsiteRepository)this.repository).getRootWebpages(uuid);
    }

    @Override
    public boolean updateRootWebpagesOrder(Website website, List<Webpage> rootPages) {
        return ((WebsiteRepository)this.repository).updateRootWebpagesOrder(website, rootPages);
    }

    @Override
    public boolean updateRootWebpagesOrder(UUID websiteUuid, List<Webpage> rootPages) {
        return ((WebsiteRepository)this.repository).updateRootWebpagesOrder(websiteUuid, rootPages);
    }
}

