/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.VersionRepository;
import de.digitalcollections.cudami.server.business.api.service.identifiable.VersionService;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.Version;
import de.digitalcollections.model.impl.identifiable.VersionImpl;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VersionServiceImpl
implements VersionService {
    @Autowired
    private VersionRepository repository;

    @Override
    public Version create(String instanceKey, String instanceVersionkey) {
        VersionImpl version = new VersionImpl();
        version.setInstanceVersionKey(instanceVersionkey);
        version.setInstanceKey(instanceKey);
        version.setStatus(Version.Status.INITIAL);
        version.setTypeKey(Version.TypeKey.DIGITALOBJECT);
        return this.repository.save((Version)version);
    }

    @Override
    public String extractInstanceVersionkey(Identifiable identifiable) {
        for (Identifier identifier : identifiable.getIdentifiers()) {
            if (!"instanceVersionkey".equals(identifier.getNamespace())) continue;
            return identifier.getId();
        }
        return null;
    }

    @Override
    public Version get(UUID uuid) {
        return this.repository.findOne(uuid);
    }

    @Override
    public Version getByInstanceversionKey(String instanceVersionkey) {
        return this.repository.findOneByInstanceversionKey(instanceVersionkey);
    }

    @Override
    public Version save(Version version) throws Exception {
        return this.repository.save(version);
    }

    @Override
    public Version update(Version version) throws Exception {
        if (version == null || version.getUuid() == null || version.getStatus() == null) {
            throw new Exception("Version must have a uuid and a status: " + version);
        }
        return this.repository.update(version);
    }
}

