/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.api.service.identifiable;

import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifiableService;
import de.digitalcollections.model.api.identifiable.Node;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.view.BreadcrumbNavigation;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public interface NodeService<N extends Node>
extends IdentifiableService<N> {
    default public boolean addChild(N parent, N child) {
        if (parent == null || child == null) {
            return false;
        }
        return this.addChildren(parent.getUuid(), Arrays.asList(child));
    }

    default public boolean addChildren(N parent, List<N> children) {
        if (parent == null || children == null) {
            return false;
        }
        return this.addChildren(parent.getUuid(), children);
    }

    public boolean addChildren(UUID var1, List<N> var2);

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID var1);

    default public BreadcrumbNavigation getBreadcrumbNavigation(UUID nodeUuid, Locale locale, Locale fallbackLocale) {
        BreadcrumbNavigation localizedBreadcrumbNavigation = this.getBreadcrumbNavigation(nodeUuid);
        localizedBreadcrumbNavigation.getNavigationItems().stream().forEach(n -> this.cleanupLabelFromUnwantedLocales(locale, fallbackLocale, (Node)n));
        return localizedBreadcrumbNavigation;
    }

    default public List<N> getChildren(N node) {
        if (node == null) {
            return null;
        }
        return this.getChildren(node.getUuid());
    }

    public List<N> getChildren(UUID var1);

    public PageResponse<N> getChildren(UUID var1, PageRequest var2);

    default public N getParent(N node) {
        if (node == null) {
            return null;
        }
        return this.getParent(node.getUuid());
    }

    public N getParent(UUID var1);

    public List<N> getParents(UUID var1);

    public PageResponse<N> getRootNodes(PageRequest var1);

    public List<Locale> getRootNodesLanguages();

    default public boolean removeChild(N parent, N child) {
        if (parent == null || child == null) {
            return false;
        }
        return this.removeChild(parent.getUuid(), child.getUuid());
    }

    public boolean removeChild(UUID var1, UUID var2);

    public N saveWithParent(N var1, UUID var2) throws IdentifiableServiceException;

    public boolean updateChildrenOrder(UUID var1, List<N> var2);
}

