/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.api.service.identifiable;

import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.Node;
import de.digitalcollections.model.api.identifiable.parts.LocalizedText;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.SearchPageRequest;
import de.digitalcollections.model.api.paging.SearchPageResponse;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public interface IdentifiableService<I extends Identifiable> {
    default public void cleanupLabelFromUnwantedLocales(Locale locale, Locale fallbackLocale, Node n) {
        LocalizedText label = n.getLabel();
        if (label == null || label.getLocales() == null || label.getLocales().isEmpty()) {
            return;
        }
        String defaultLabel = null;
        if (label.getLocales().contains(fallbackLocale)) {
            defaultLabel = label.getText(fallbackLocale);
        }
        Locale firstLocale = (Locale)label.getLocales().get(0);
        String firstLocaleLabel = label.getText(firstLocale);
        label.entrySet().removeIf(e -> e.getKey() != locale);
        if (label.keySet().isEmpty()) {
            if (defaultLabel != null) {
                label.put((Object)fallbackLocale, (Object)defaultLabel);
            } else if (firstLocale != null) {
                label.put((Object)firstLocale, (Object)firstLocaleLabel);
            }
        }
    }

    public long count();

    default public boolean delete(UUID uuid) {
        return this.delete(List.of(uuid));
    }

    public boolean delete(List<UUID> var1);

    public PageResponse<I> find(PageRequest var1);

    public SearchPageResponse<I> find(SearchPageRequest var1);

    public List<I> find(String var1, int var2);

    public List<I> findAllFull();

    public List<I> findAllReduced();

    public PageResponse<I> findByLanguageAndInitial(PageRequest var1, String var2, String var3);

    public I get(Identifier var1);

    public I get(UUID var1);

    public I get(UUID var1, Locale var2) throws IdentifiableServiceException;

    public I getByIdentifier(String var1, String var2);

    public I save(I var1) throws IdentifiableServiceException;

    public I update(I var1) throws IdentifiableServiceException;
}

