/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.entity.parts;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.NodeRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.parts.WebpageRepository;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.parts.WebpageService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.entity.parts.EntityPartServiceImpl;
import de.digitalcollections.model.api.filter.Filtering;
import de.digitalcollections.model.api.identifiable.Node;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.Website;
import de.digitalcollections.model.api.identifiable.entity.parts.Webpage;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.view.BreadcrumbNavigation;
import de.digitalcollections.model.impl.paging.PageRequestImpl;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebpageServiceImpl<E extends Entity>
extends EntityPartServiceImpl<Webpage, E>
implements WebpageService<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebpageServiceImpl.class);

    @Autowired
    public WebpageServiceImpl(WebpageRepository<E> repository) {
        super(repository);
    }

    @Override
    public Webpage get(UUID uuid, Locale locale) throws IdentifiableServiceException {
        Webpage webpage = (Webpage)super.get(uuid, locale);
        if (webpage == null) {
            return null;
        }
        Locale fLocale = (Locale)((Map.Entry)webpage.getLabel().entrySet().iterator().next()).getKey();
        if (webpage.getText() != null) {
            webpage.getText().entrySet().removeIf(entry -> !entry.getKey().equals(fLocale));
        }
        return webpage;
    }

    @Override
    public Webpage getActive(UUID uuid) {
        Filtering filtering = this.filteringForActive();
        Webpage webpage = ((WebpageRepository)this.repository).findOne(uuid, filtering);
        if (webpage != null) {
            webpage.setChildren(this.getActiveChildren(uuid));
        }
        return webpage;
    }

    @Override
    public Webpage getActive(UUID uuid, Locale pLocale) {
        Webpage webpage = this.getActive(uuid);
        return this.reduceMultilanguageFieldsToGivenLocale(webpage, pLocale);
    }

    @Override
    public List<Webpage> getActiveChildren(UUID uuid) {
        Filtering filtering = this.filteringForActive();
        PageRequestImpl pageRequest = new PageRequestImpl();
        pageRequest.add(filtering);
        return this.getChildren(uuid, (PageRequest)pageRequest).getContent();
    }

    @Override
    public PageResponse<Webpage> getActiveChildren(UUID uuid, PageRequest pageRequest) {
        Filtering filtering = this.filteringForActive();
        pageRequest.add(filtering);
        return this.getChildren(uuid, pageRequest);
    }

    @Override
    public BreadcrumbNavigation getBreadcrumbNavigation(UUID uuid) {
        return ((NodeRepository)this.repository).getBreadcrumbNavigation(uuid);
    }

    @Override
    public List<Webpage> getChildren(Webpage webpage) {
        return ((NodeRepository)this.repository).getChildren((Node)webpage);
    }

    @Override
    public List<Webpage> getChildren(UUID uuid) {
        return ((NodeRepository)this.repository).getChildren(uuid);
    }

    @Override
    public PageResponse<Webpage> getChildren(UUID uuid, PageRequest pageRequest) {
        return ((NodeRepository)this.repository).getChildren(uuid, pageRequest);
    }

    @Override
    public Webpage getParent(Webpage webpage) {
        return this.getParent(webpage.getUuid());
    }

    @Override
    public Webpage getParent(UUID webpageUuid) {
        return (Webpage)((NodeRepository)this.repository).getParent(webpageUuid);
    }

    @Override
    public Website getWebsite(UUID webpageUuid) {
        UUID rootWebpageUuid = webpageUuid;
        Webpage parent = this.getParent(webpageUuid);
        while (parent != null) {
            rootWebpageUuid = parent.getUuid();
            parent = this.getParent(parent);
        }
        return ((WebpageRepository)this.repository).getWebsite(rootWebpageUuid);
    }

    @Override
    public Webpage saveWithParentWebsite(Webpage webpage, UUID parentWebsiteUuid) throws IdentifiableServiceException {
        try {
            return ((WebpageRepository)this.repository).saveWithParentWebsite(webpage, parentWebsiteUuid);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save top-level webpage " + webpage + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    @Override
    public Webpage saveWithParentWebpage(Webpage webpage, UUID parentWebpageUuid) throws IdentifiableServiceException {
        try {
            return ((WebpageRepository)this.repository).saveWithParentWebpage(webpage, parentWebpageUuid);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save webpage " + webpage + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }
}

