/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.security;

import de.digitalcollections.cudami.server.backend.api.repository.security.UserRepository;
import de.digitalcollections.cudami.server.business.api.service.security.UserService;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.security.User;
import de.digitalcollections.model.api.security.enums.Role;
import de.digitalcollections.model.impl.security.UserImpl;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Service
public class UserServiceImpl
implements UserService<User> {
    @Autowired
    @Qualifier(value="uniqueUsernameValidator")
    private Validator uniqueUsernameValidator;
    @Autowired
    private UserRepository userRepository;

    @Override
    public User activate(UUID uuid) {
        User user = this.userRepository.findOne(uuid);
        user.setEnabled(true);
        user = this.userRepository.save(user);
        return user;
    }

    @Override
    public PageResponse<User> find(PageRequest pageRequest) {
        return this.userRepository.find(pageRequest);
    }

    @Override
    public User save(User user, Errors results) {
        this.uniqueUsernameValidator.validate((Object)user, results);
        if (!results.hasErrors()) {
            return this.userRepository.save(user);
        }
        return null;
    }

    @Override
    public User createAdminUser() {
        UserImpl user = (UserImpl)this.userRepository.create();
        user.getRoles().add(Role.ADMIN);
        return user;
    }

    @Override
    public User deactivate(UUID uuid) {
        User user = this.userRepository.findOne(uuid);
        user.setEnabled(false);
        user = this.userRepository.save(user);
        return user;
    }

    @Override
    public boolean doesActiveAdminUserExist() {
        List findActiveAdminUsers = this.userRepository.findActiveAdminUsers();
        return findActiveAdminUsers != null && !findActiveAdminUsers.isEmpty();
    }

    @Override
    public User get(UUID uuid) {
        return this.userRepository.findOne(uuid);
    }

    @Override
    public User loadUserByUsername(String username) throws UsernameNotFoundException {
        User user = this.userRepository.findByEmail(username);
        if (user == null || !user.isEnabled()) {
            throw new UsernameNotFoundException(String.format("User \"%s\" was not found.", username));
        }
        return user;
    }

    @Override
    public User update(User user, Errors results) {
        return this.userRepository.update(user);
    }

    @Override
    public List<User> findActiveAdminUsers() {
        return this.userRepository.findActiveAdminUsers();
    }
}

