/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.entity.parts;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.parts.EntityPartRepository;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.parts.EntityPartService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.IdentifiableServiceImpl;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.parts.EntityPart;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import java.util.LinkedHashSet;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class EntityPartServiceImpl<P extends EntityPart, E extends Entity>
extends IdentifiableServiceImpl<P>
implements EntityPartService<P, E> {
    @Autowired
    public EntityPartServiceImpl(@Qualifier(value="entityPartRepositoryImpl") EntityPartRepository<P, E> repository) {
        super(repository);
    }

    @Override
    public void addRelatedEntity(P entityPart, E entity) {
        ((EntityPartRepository)this.repository).addRelatedEntity(entityPart, entity);
    }

    @Override
    public void addRelatedEntity(UUID entityPartUuid, UUID entityUuid) {
        ((EntityPartRepository)this.repository).addRelatedEntity(entityPartUuid, entityUuid);
    }

    @Override
    public void addRelatedFileresource(P entityPart, FileResource fileResource) {
        ((EntityPartRepository)this.repository).addRelatedFileresource(entityPart, fileResource);
    }

    @Override
    public void addRelatedFileresource(UUID entityPartUuid, UUID fileResourceUuid) {
        ((EntityPartRepository)this.repository).addRelatedFileresource(entityPartUuid, fileResourceUuid);
    }

    @Override
    public LinkedHashSet<E> getRelatedEntities(P entityPart) {
        return ((EntityPartRepository)this.repository).getRelatedEntities(entityPart);
    }

    @Override
    public LinkedHashSet<E> getRelatedEntities(UUID entityPartUuid) {
        return ((EntityPartRepository)this.repository).getRelatedEntities(entityPartUuid);
    }

    @Override
    public LinkedHashSet<FileResource> getRelatedFileResources(P entityPart) {
        return ((EntityPartRepository)this.repository).getRelatedFileResources(entityPart);
    }

    @Override
    public LinkedHashSet<FileResource> getRelatedFileResources(UUID entityPartUuid) {
        return ((EntityPartRepository)this.repository).getRelatedFileResources(entityPartUuid);
    }

    @Override
    public LinkedHashSet<E> saveRelatedEntities(P entityPart, LinkedHashSet<E> entities) {
        return ((EntityPartRepository)this.repository).saveRelatedEntities(entityPart, entities);
    }

    @Override
    public LinkedHashSet<E> saveRelatedEntities(UUID entityPartUuid, LinkedHashSet<E> entities) {
        return ((EntityPartRepository)this.repository).saveRelatedEntities(entityPartUuid, entities);
    }

    @Override
    public LinkedHashSet<FileResource> saveRelatedFileResources(P entityPart, LinkedHashSet<FileResource> fileResources) {
        return ((EntityPartRepository)this.repository).saveRelatedFileResources(entityPart, fileResources);
    }

    @Override
    public LinkedHashSet<FileResource> saveRelatedFileResources(UUID entityPartUuid, LinkedHashSet<FileResource> fileResources) {
        return ((EntityPartRepository)this.repository).saveRelatedFileResources(entityPartUuid, fileResources);
    }
}

