/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.DigitalObjectRepository;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.VersionService;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.DigitalObjectService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.entity.EntityServiceImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.Version;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import java.util.LinkedHashSet;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DigitalObjectServiceImpl
extends EntityServiceImpl<DigitalObject>
implements DigitalObjectService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigitalObjectServiceImpl.class);
    @Autowired
    VersionService versionService;

    @Autowired
    public DigitalObjectServiceImpl(DigitalObjectRepository repository) {
        super(repository);
    }

    @Override
    public DigitalObject getByIdentifier(String namespace, String id) {
        long start = System.currentTimeMillis();
        DigitalObject digitalObject = ((DigitalObjectRepository)this.repository).findByIdentifier(namespace, id);
        long end = System.currentTimeMillis();
        LOGGER.info("duration : " + (end - start));
        return digitalObject;
    }

    @Override
    public LinkedHashSet<FileResource> getFileResources(DigitalObject digitalObject) {
        return this.getFileResources(digitalObject.getUuid());
    }

    @Override
    public LinkedHashSet<FileResource> getFileResources(UUID digitalObjectUuid) {
        return ((DigitalObjectRepository)this.repository).getFileResources(digitalObjectUuid);
    }

    @Override
    public LinkedHashSet<ImageFileResource> getImageFileResources(DigitalObject digitalObject) {
        return this.getImageFileResources(digitalObject.getUuid());
    }

    @Override
    public LinkedHashSet<ImageFileResource> getImageFileResources(UUID digitalObjectUuid) {
        return ((DigitalObjectRepository)this.repository).getImageFileResources(digitalObjectUuid);
    }

    Identifier getidentifer(DigitalObject digitalObject, String name) {
        for (Identifier identifier : digitalObject.getIdentifiers()) {
            if (!name.equals(identifier.getNamespace())) continue;
            return identifier;
        }
        return null;
    }

    @Override
    public DigitalObject save(DigitalObject digitalObject) throws IdentifiableServiceException {
        Version version = null;
        if (digitalObject.getVersion() == null) {
            String instanceVersionKey = this.versionService.extractInstanceVersionkey((Identifiable)digitalObject);
            if (instanceVersionKey == null) {
                throw new RuntimeException("No instanceVersionKey defined for: " + digitalObject);
            }
            version = this.versionService.get(instanceVersionKey);
            if (version == null) {
                Identifier zendIdentifier = this.getidentifer(digitalObject, "zend");
                if (zendIdentifier == null) {
                    throw new RuntimeException("No zendid defined for: " + digitalObject);
                }
                String instanceKey = zendIdentifier.getId();
                LOGGER.info("Digital object saved: " + digitalObject);
                version = this.versionService.create(instanceKey, instanceVersionKey);
                digitalObject.setVersion(version);
                return (DigitalObject)this.repository.save((Identifiable)digitalObject);
            }
        }
        LOGGER.info("Digital object version already stored: " + digitalObject + " : " + version);
        return digitalObject;
    }

    @Override
    public LinkedHashSet<FileResource> saveFileResources(DigitalObject digitalObject, LinkedHashSet<FileResource> fileResources) {
        return this.saveFileResources(digitalObject.getUuid(), fileResources);
    }

    @Override
    public LinkedHashSet<FileResource> saveFileResources(UUID digitalObjectUuid, LinkedHashSet<FileResource> fileResources) {
        return ((DigitalObjectRepository)this.repository).saveFileResources(digitalObjectUuid, fileResources);
    }
}

