/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.api.service.identifiable.resource;

import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.IdentifiableService;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.MimeType;
import java.io.InputStream;

public interface FileResourceService
extends IdentifiableService<FileResource> {
    default public FileResource createByContentTypeAndFilename(String contentType, String filename) {
        return this.createByMimeTypeAndFilename(MimeType.fromTypename((String)contentType), filename);
    }

    default public FileResource createByFilename(String filename) {
        MimeType mimeType = MimeType.fromFilename((String)filename);
        FileResource result = this.createByMimeType(mimeType);
        result.setFilename(filename);
        return result;
    }

    default public FileResource createByFilenameExtension(String filenameExtension) {
        MimeType mimeType = MimeType.fromExtension((String)filenameExtension);
        FileResource result = this.createByMimeType(mimeType);
        return result;
    }

    public FileResource createByMimeType(MimeType var1);

    default public FileResource createByMimeTypeAndFilename(MimeType mimeType, String filename) {
        FileResource result = this.createByMimeType(mimeType);
        result.setFilename(filename);
        return result;
    }

    public FileResource save(FileResource var1, InputStream var2) throws IdentifiableServiceException;

    public FileResource getByIdentifier(String var1, String var2) throws IdentifiableServiceException;
}

