/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.entity.parts;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.NodeRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.parts.WebpageRepository;
import de.digitalcollections.cudami.server.business.api.service.LocaleService;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.parts.WebpageService;
import de.digitalcollections.cudami.server.business.impl.service.identifiable.IdentifiableServiceImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Node;
import de.digitalcollections.model.api.identifiable.entity.parts.Webpage;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebpageServiceImpl<I extends Identifiable>
extends IdentifiableServiceImpl<Webpage>
implements WebpageService<Webpage, I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebpageServiceImpl.class);
    @Autowired
    private LocaleService localeService;

    @Autowired
    public WebpageServiceImpl(WebpageRepository<Webpage, I> repository) {
        super(repository);
    }

    @Override
    public void addIdentifiable(UUID webpageUuid, UUID identifiableUuid) {
        ((WebpageRepository)this.repository).addIdentifiable(webpageUuid, identifiableUuid);
    }

    @Override
    public Webpage get(UUID uuid, Locale locale) throws IdentifiableServiceException {
        Webpage webpage = (Webpage)this.repository.findOne(uuid, locale);
        if (webpage == null) {
            webpage = (Webpage)this.repository.findOne(uuid, this.localeService.getDefault());
        }
        if (webpage == null) {
            webpage = (Webpage)this.repository.findOne(uuid, null);
        }
        return webpage;
    }

    @Override
    public List<Webpage> getChildren(Webpage webpage) {
        return ((NodeRepository)this.repository).getChildren((Node)webpage);
    }

    @Override
    public List<Webpage> getChildren(UUID uuid) {
        return ((NodeRepository)this.repository).getChildren(uuid);
    }

    @Override
    public Webpage saveWithParentWebsite(Webpage webpage, UUID parentWebsiteUuid) throws IdentifiableServiceException {
        try {
            return ((WebpageRepository)this.repository).saveWithParentWebsite(webpage, parentWebsiteUuid);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save top-level webpage " + webpage + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    @Override
    public Webpage saveWithParentWebpage(Webpage webpage, UUID parentWebpageUuid) throws IdentifiableServiceException {
        try {
            return ((WebpageRepository)this.repository).saveWithParentWebpage(webpage, parentWebpageUuid);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save webpage " + webpage + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    @Override
    public List<Identifiable> getIdentifiables(Webpage webpage) {
        return this.getIdentifiables(webpage.getUuid());
    }

    @Override
    public List<Identifiable> getIdentifiables(UUID identifiableUuid) {
        return ((WebpageRepository)this.repository).getIdentifiables(identifiableUuid);
    }

    @Override
    public List<Identifiable> saveIdentifiables(Webpage webpage, List<Identifiable> identifiables) {
        return this.saveIdentifiables(webpage.getUuid(), identifiables);
    }

    @Override
    public List<Identifiable> saveIdentifiables(UUID identifiablesContainerUuid, List<Identifiable> identifiables) {
        return ((WebpageRepository)this.repository).saveIdentifiables(identifiablesContainerUuid, identifiables);
    }
}

