/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.business.impl.service.identifiable.entity;

import de.digitalcollections.core.model.api.paging.PageRequest;
import de.digitalcollections.core.model.api.paging.PageResponse;
import de.digitalcollections.cudami.model.api.identifiable.Identifiable;
import de.digitalcollections.cudami.model.api.identifiable.entity.ContentTree;
import de.digitalcollections.cudami.model.api.identifiable.resource.ContentNode;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.ContentTreeRepository;
import de.digitalcollections.cudami.server.business.api.service.exceptions.IdentifiableServiceException;
import de.digitalcollections.cudami.server.business.api.service.identifiable.entity.ContentTreeService;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContentTreeServiceImpl
implements ContentTreeService<ContentTree> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContentTreeServiceImpl.class);
    @Autowired
    private ContentTreeRepository contentTreeRepository;

    @Override
    public long count() {
        return this.contentTreeRepository.count();
    }

    @Override
    public ContentTree create() {
        return (ContentTree)this.contentTreeRepository.create();
    }

    @Override
    public PageResponse<ContentTree> find(PageRequest pageRequest) {
        return this.contentTreeRepository.find(pageRequest);
    }

    @Override
    public ContentTree get(UUID uuid) {
        return (ContentTree)this.contentTreeRepository.findOne(uuid);
    }

    @Override
    public List<ContentNode> getRootNodes(ContentTree contentTree) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ContentTree save(ContentTree contentTree) throws IdentifiableServiceException {
        try {
            return (ContentTree)this.contentTreeRepository.save((Identifiable)contentTree);
        }
        catch (Exception e) {
            LOGGER.error("Cannot save content tree " + contentTree + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    @Override
    public ContentTree update(ContentTree contentTree) throws IdentifiableServiceException {
        try {
            return (ContentTree)this.contentTreeRepository.update((Identifiable)contentTree);
        }
        catch (Exception e) {
            LOGGER.error("Cannot update content tree " + contentTree + ": ", (Throwable)e);
            throw new IdentifiableServiceException(e.getMessage());
        }
    }

    public void setRepository(ContentTreeRepository contentTreeRepository) {
        this.contentTreeRepository = contentTreeRepository;
    }
}

