/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.type;

import de.digitalcollections.model.identifiable.Identifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jdbi.v3.core.array.SqlArrayType;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class DbIdentifierMapper
implements SqlArrayType<Identifier>,
ColumnMapper<Identifier> {
    public String getTypeName() {
        return "dbIdentifier";
    }

    public Object convertArrayElement(Identifier identifier) {
        return String.format("(\"%s\",\"%s\")", identifier.getNamespace(), identifier.getId());
    }

    public Identifier map(ResultSet r, int columnNumber, StatementContext ctx) throws SQLException {
        String dbIdentifier = r.getString(columnNumber);
        Identifier identifier = this.extractIdentifier(dbIdentifier);
        return identifier;
    }

    protected Identifier extractIdentifier(String identifierString) {
        String[] identifierParts;
        if (identifierString == null) {
            return null;
        }
        if ((identifierString = identifierString.replaceFirst("^\\(", "").replaceFirst("\\)$", "")).isBlank()) {
            return null;
        }
        if (!identifierString.startsWith("\"")) {
            identifierString = identifierString.replaceFirst("^(.*?),", "\"$1\",");
        }
        if (!identifierString.endsWith("\"")) {
            identifierString = identifierString.replaceFirst("\",(.*)$", "\",\"$1\"");
        }
        if ((identifierParts = identifierString.split("\",\"")).length != 2) {
            return null;
        }
        String namespace = identifierParts[0].replaceFirst("^\"", "");
        String id = identifierParts[1].replaceFirst("\"$", "");
        if (namespace == null || namespace.isBlank() || id == null || id.isBlank()) {
            return null;
        }
        return (Identifier)Identifier.builder().namespace(namespace).id(id).build();
    }
}

