/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.semantic;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.semantic.HeadwordRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.UniqueObjectRepositoryImpl;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.ListRequest;
import de.digitalcollections.model.list.buckets.Bucket;
import de.digitalcollections.model.list.buckets.BucketObjectsRequest;
import de.digitalcollections.model.list.buckets.BucketObjectsResponse;
import de.digitalcollections.model.list.buckets.BucketsRequest;
import de.digitalcollections.model.list.buckets.BucketsResponse;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import de.digitalcollections.model.semantic.Headword;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class HeadwordRepositoryImpl
extends UniqueObjectRepositoryImpl<Headword>
implements HeadwordRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeadwordRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "hw";
    public static final String TABLE_ALIAS = "hw";
    public static final String TABLE_NAME = "headwords";

    public HeadwordRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, "hw", "hw", Headword.class, cudamiConfig.getOffsetForAlternativePaging());
    }

    public void addRelatedEntity(UUID headwordUuid, UUID entityUuid) throws RepositoryException {
        Integer sortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "headword_entities", "headword_uuid", headwordUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO headword_entities(headword_uuid, entity_uuid, sortindex) VALUES (:headwordUuid, :entityUuid, :sortindex)").bind("headwordUuid", headwordUuid)).bind("entityUuid", entityUuid)).bind("sortindex", sortIndex)).execute());
    }

    public void addRelatedFileresource(UUID headwordUuid, UUID fileResourceUuid) throws RepositoryException {
        Integer sortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "headword_fileresources", "headword_uuid", headwordUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO headword_fileresources(headword_uuid, fileresource_uuid, sortindex) VALUES (:headwordUuid, :fileresourceUuid, :sortindex)").bind("headwordUuid", headwordUuid)).bind("fileresourceUuid", fileResourceUuid)).bind("sortindex", sortIndex)).execute());
    }

    public Headword create() throws RepositoryException {
        return new Headword();
    }

    public void deleteByLabelAndLocale(String label, Locale locale) throws RepositoryException {
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE label = :label AND locale = :locale").bind("label", label)).bind("locale", (Object)locale)).execute());
    }

    @Override
    public int deleteByUuids(List<UUID> uuids) throws RepositoryException {
        uuids.stream().forEach(u -> {
            try {
                this.deleteRelatedEntities((UUID)u);
            }
            catch (RepositoryException e) {
                LOGGER.error("Can not delete related entities of headword " + u, (Throwable)e);
            }
            try {
                this.deleteRelatedFileresources((UUID)u);
            }
            catch (RepositoryException e) {
                LOGGER.error("Can not delete related fileresources of headword " + u, (Throwable)e);
            }
        });
        return super.deleteByUuids(uuids);
    }

    public void deleteRelatedEntities(UUID headwordUuid) throws RepositoryException {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM headword_entities WHERE headword_uuid = :uuid").bind("uuid", headwordUuid)).execute());
    }

    public void deleteRelatedFileresources(UUID headwordUuid) throws RepositoryException {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM headword_fileresources WHERE headword_uuid = :uuid").bind("uuid", headwordUuid)).execute());
    }

    public BucketObjectsResponse<Headword> find(BucketObjectsRequest<Headword> bucketObjectsRequest) throws RepositoryException {
        int offset;
        HashMap<String, UUID> argumentMappings = new HashMap<String, UUID>(0);
        Bucket bucket = bucketObjectsRequest.getBucket();
        UUID startUuid = ((Headword)bucket.getStartObject()).getUuid();
        UUID endUuid = ((Headword)bucket.getEndObject()).getUuid();
        argumentMappings.put("startUuid", startUuid);
        argumentMappings.put("endUuid", endUuid);
        String sortColumn = this.getSortColumn((ListRequest)bucketObjectsRequest);
        Object selectForLabel = this.getColumnName("label");
        if (!sortColumn.equals(selectForLabel)) {
            selectForLabel = (String)selectForLabel + ", " + sortColumn;
        }
        String baseQuery = "WITH headwords_list AS (SELECT row_number() OVER (ORDER BY {{sortColumn}}) as num, {{tableAlias}}.uuid, {{selectForLabel}} FROM {{tableName}} AS {{tableAlias}}),\n  hws AS (SELECT * FROM headwords_list WHERE num <@ int8range((SELECT num FROM headwords_list WHERE uuid = :startUuid), (SELECT num FROM headwords_list WHERE uuid = :endUuid), '[]'))\n".replace("{{selectForLabel}}", (CharSequence)selectForLabel).replace("{{sortColumn}}", sortColumn).replace("{{tableAlias}}", this.tableAlias).replace("{{tableName}}", this.tableName);
        StringBuilder dataQuery = new StringBuilder(baseQuery);
        dataQuery.append(" SELECT uuid, label FROM hws");
        int pageSize = bucketObjectsRequest.getPageSize();
        if (pageSize > 0) {
            dataQuery.append(" ").append("LIMIT").append(" ").append(pageSize);
        }
        if ((offset = bucketObjectsRequest.getOffset()) >= 0) {
            dataQuery.append(" ").append("OFFSET").append(" ").append(offset);
        }
        List content = (List)this.dbi.withHandle(handle -> ((Query)handle.createQuery(dataQuery.toString()).bindMap(argumentMappings)).mapToBean(Headword.class).list());
        StringBuilder countQuery = new StringBuilder(baseQuery);
        countQuery.append(" SELECT count(*) FROM hws");
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(countQuery.toString()).bindMap(argumentMappings)).mapTo(Long.class).findOne().get());
        BucketObjectsResponse bucketObjectsResponse = new BucketObjectsResponse(bucketObjectsRequest, content, total);
        return bucketObjectsResponse;
    }

    public BucketsResponse<Headword> find(BucketsRequest<Headword> bucketsRequest) throws RepositoryException {
        Bucket parentBucket;
        HashMap<String, Comparable<Integer>> argumentMappings = new HashMap<String, Comparable<Integer>>(0);
        int numberOfBuckets = bucketsRequest.getNumberOfBuckets();
        argumentMappings.put("numberOfBuckets", Integer.valueOf(numberOfBuckets));
        String sortColumn = this.getSortColumn((ListRequest)bucketsRequest);
        StringBuilder sqlQuery = new StringBuilder(0);
        Object selectForLabel = this.getColumnName("label");
        if (!sortColumn.equals(selectForLabel)) {
            selectForLabel = (String)selectForLabel + ", " + sortColumn;
        }
        if ((parentBucket = bucketsRequest.getParentBucket()) != null) {
            UUID startUuid = ((Headword)parentBucket.getStartObject()).getUuid();
            UUID endUuid = ((Headword)parentBucket.getEndObject()).getUuid();
            argumentMappings.put("startUuid", startUuid);
            argumentMappings.put("endUuid", endUuid);
            sqlQuery.append("WITH headwords_list AS (SELECT row_number() OVER (ORDER BY {{sortColumn}}) AS num, {{tableAlias}}.uuid, {{selectForLabel}} FROM {{tableName}} AS {{tableAlias}}),\n  hws AS (SELECT * FROM headwords_list WHERE num <@ int8range((SELECT num FROM headwords_list WHERE uuid = :startUuid), (SELECT num FROM headwords_list WHERE uuid = :endUuid), '[]')),\n".replace("{{selectForLabel}}", (CharSequence)selectForLabel).replace("{{sortColumn}}", sortColumn).replace("{{tableAlias}}", this.tableAlias).replace("{{tableName}}", this.tableName));
        } else {
            sqlQuery.append("WITH hws AS (SELECT row_number() OVER (ORDER BY {{sortColumn}}) AS num, {{tableAlias}}.uuid, {{selectForLabel}} FROM {{tableName}} AS {{tableAlias}}),\n".replace("{{selectForLabel}}", (CharSequence)selectForLabel).replace("{{sortColumn}}", sortColumn).replace("{{tableAlias}}", this.tableAlias).replace("{{tableName}}", this.tableName));
        }
        sqlQuery.append("buckets AS (SELECT {{tableAlias}}.num, {{tableAlias}}.uuid, {{tableAlias}}.label, ntile(:numberOfBuckets) OVER (ORDER BY {{sortColumn}} ASC) AS tile_number FROM hws AS {{tableAlias}}),\n  buckets_borders_nums AS (SELECT min(num) AS minNum, max(num) AS maxNum, tile_number FROM buckets GROUP BY tile_number ORDER BY tile_number)\n  SELECT bu.num, bu.uuid, bu.label, bu.tile_number FROM buckets AS bu WHERE bu.num IN (SELECT minNum FROM buckets_borders_nums UNION SELECT maxNum FROM buckets_borders_nums)\n".replace("{{sortColumn}}", sortColumn).replace("{{tableAlias}}", this.tableAlias).replace("{{tableName}}", this.tableName));
        List rows = (List)this.dbi.withHandle(handle -> ((Query)handle.createQuery(sqlQuery.toString()).bindMap(argumentMappings)).mapToMap().list());
        ArrayList<Bucket> content = new ArrayList<Bucket>(0);
        for (int i = 0; i < rows.size(); i += 2) {
            Map lowerBorder = (Map)rows.get(i);
            Map upperBorder = i + 1 < rows.size() ? (Map)rows.get(i + 1) : lowerBorder;
            Headword lowerHeadword = new Headword();
            lowerHeadword.setUuid((UUID)lowerBorder.get("uuid"));
            lowerHeadword.setLabel((String)lowerBorder.get("label"));
            Headword upperHeadword = new Headword();
            upperHeadword.setUuid((UUID)upperBorder.get("uuid"));
            upperHeadword.setLabel((String)upperBorder.get("label"));
            Bucket bucket = new Bucket((UniqueObject)lowerHeadword, (UniqueObject)upperHeadword);
            content.add(bucket);
        }
        BucketsResponse bucketsResponse = new BucketsResponse(bucketsRequest, content);
        return bucketsResponse;
    }

    private String getSortColumn(ListRequest bucketsRequest) {
        String sortProperty = "label";
        Sorting sorting = bucketsRequest.getSorting();
        if (sorting != null) {
            sortProperty = ((Order)sorting.getOrders().get(0)).getProperty();
        }
        String sortColumn = this.getColumnName(sortProperty);
        return sortColumn;
    }

    public List<Headword> find(String label, Locale locale) throws RepositoryException {
        Filtering filtering = Filtering.builder().add(FilterCriterion.builder().withExpression("label").isEquals((Object)label).build()).add(FilterCriterion.builder().withExpression("locale").isEquals((Object)locale).build()).build();
        PageRequest request = new PageRequest(0, 10000, Sorting.builder().order(new Order(Direction.ASC, "label")).build(), filtering);
        PageResponse response = this.find(request);
        return response.getContent();
    }

    public List<Headword> findByLabel(String label) throws RepositoryException {
        Filtering filtering = Filtering.builder().add(FilterCriterion.builder().withExpression("label").isEquals((Object)label).build()).build();
        PageRequest request = new PageRequest(0, 10000, Sorting.builder().order(new Order(Direction.ASC, "label")).build(), filtering);
        PageResponse response = this.find(request);
        return response.getContent();
    }

    public PageResponse<Headword> findByLanguageAndInitial(PageRequest pageRequest, String language, String initial) {
        throw new UnsupportedOperationException();
    }

    public PageResponse<Entity> findRelatedEntities(UUID headwordUuid, PageRequest pageRequest) {
        throw new UnsupportedOperationException();
    }

    public PageResponse<FileResource> findRelatedFileResources(UUID headwordUuid, PageRequest pageRequest) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> allowedOrderByFields = super.getAllowedOrderByFields();
        allowedOrderByFields.addAll(Arrays.asList("label", "labelNormalized", "locale"));
        return allowedOrderByFields;
    }

    public Headword getByLabelAndLocale(String label, Locale locale) {
        StringBuilder sqlQuery = new StringBuilder("SELECT " + this.getSqlSelectAllFields() + " FROM " + this.tableName + " AS " + this.tableAlias);
        Filtering filtering = Filtering.builder().add(FilterCriterion.builder().withExpression("label").isEquals((Object)label).build()).add(FilterCriterion.builder().withExpression("locale").isEquals((Object)locale).build()).build();
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        this.addFiltering(filtering, sqlQuery, argumentMappings);
        Map<String, Object> bindMap = Map.copyOf(argumentMappings);
        Optional result = (Optional)this.dbi.withHandle(h -> ((Query)h.createQuery(sqlQuery.toString()).bindMap(bindMap)).mapToBean(Headword.class).findFirst());
        return result.orElse(null);
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "label": {
                return this.tableAlias + ".label";
            }
            case "labelNormalized": {
                return this.tableAlias + ".label_normalized";
            }
            case "locale": {
                return this.tableAlias + ".locale";
            }
        }
        return super.getColumnName(modelProperty);
    }

    public List<Locale> getLanguages() {
        String query = "SELECT DISTINCT locale FROM " + this.tableName;
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query).mapTo(Locale.class).list());
        return result;
    }

    public List<Headword> getRandom(int count) {
        throw new UnsupportedOperationException();
    }

    public List<Entity> getRelatedEntities(UUID headwordUuid) {
        throw new UnsupportedOperationException();
    }

    public List<FileResource> getRelatedFileResources(UUID headwordUuid) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getSqlInsertFields() {
        return super.getSqlInsertFields() + ", label, locale, label_normalized";
    }

    @Override
    protected String getSqlInsertValues() {
        return super.getSqlInsertValues() + ", :label, :locale, :labelNormalized";
    }

    @Override
    public String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return this.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    @Override
    public String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".label " + mappingPrefix + "_label, " + tableAlias + ".label_normalized " + mappingPrefix + "_labelNormalized, " + tableAlias + ".locale " + mappingPrefix + "_locale";
    }

    @Override
    protected String getSqlUpdateFieldValues() {
        return super.getSqlUpdateFieldValues() + ", label=:label, locale=:locale, label_normalized=:labelNormalized";
    }

    public List<Entity> setRelatedEntities(UUID headwordUuid, List<Entity> entities) {
        throw new UnsupportedOperationException();
    }

    public List<FileResource> setRelatedFileResources(UUID headwordUuid, List<FileResource> fileResources) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        switch (modelProperty) {
            case "label": 
            case "labelNormalized": 
            case "locale": {
                return true;
            }
        }
        return false;
    }
}

