/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.security;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.security.UserRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.UniqueObjectRepositoryImpl;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.security.Role;
import de.digitalcollections.model.security.User;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.springframework.stereotype.Repository;

@Repository
public class UserRepositoryImpl
extends UniqueObjectRepositoryImpl<User>
implements UserRepository {
    public static final String MAPPING_PREFIX = "us";
    public static final String TABLE_ALIAS = "u";
    public static final String TABLE_NAME = "users";

    public UserRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, User.class, cudamiConfig.getOffsetForAlternativePaging());
        this.dbi.registerArrayType(Role.class, "varchar");
    }

    public User create() {
        return new User();
    }

    @Override
    public PageResponse<User> find(PageRequest pageRequest) throws RepositoryException {
        StringBuilder commonSql = new StringBuilder(" FROM " + this.tableName + " AS " + this.tableAlias);
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder query = new StringBuilder("SELECT " + this.getSqlSelectReducedFields() + commonSql);
        this.addPagingAndSorting(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query.toString()).bindMap(argumentMappings)).mapToBean(User.class).list());
        long total = this.count(commonSql.toString(), argumentMappings);
        return new PageResponse(result, pageRequest, total, null);
    }

    public List<User> getActiveAdminUsers() {
        return (List)this.dbi.withHandle(h -> {
            String sql = "SELECT " + this.getSqlSelectReducedFields() + " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE '" + Role.ADMIN.name() + "' = any(roles)";
            return h.createQuery(sql).mapToBean(User.class).list();
        });
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> allowedOrderByFields = super.getAllowedOrderByFields();
        allowedOrderByFields.addAll(Arrays.asList("email", "firstname", "lastname"));
        return allowedOrderByFields;
    }

    public User getByEmail(String email) {
        List users = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT " + this.getSqlSelectAllFields() + " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE email = :email").bind("email", email)).mapToBean(User.class).list());
        if (users.isEmpty()) {
            return null;
        }
        return (User)users.get(0);
    }

    public User getByUuid(UUID uuid) {
        List users = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT " + this.getSqlSelectAllFields() + " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE uuid = :uuid").bind("uuid", uuid)).mapToBean(User.class).list());
        if (users.isEmpty()) {
            return null;
        }
        return (User)users.get(0);
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "email": {
                return this.tableAlias + ".email";
            }
            case "lastname": {
                return this.tableAlias + ".lastname";
            }
            case "firstname": {
                return this.tableAlias + ".firstname";
            }
        }
        return super.getColumnName(modelProperty);
    }

    public List<User> getRandom(int count) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getSqlInsertFields() {
        return super.getSqlInsertFields() + ", email, enabled, firstname, lastname, passwordhash, roles";
    }

    @Override
    protected String getSqlInsertValues() {
        return super.getSqlInsertValues() + ", :email, :enabled, :firstname, :lastname, :passwordHash, :roles";
    }

    @Override
    public String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return this.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    @Override
    public String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return " " + tableAlias + ".uuid, " + tableAlias + ".created, " + tableAlias + ".last_modified, " + tableAlias + ".email, " + tableAlias + ".enabled, " + tableAlias + ".firstname, " + tableAlias + ".lastname, " + tableAlias + ".passwordhash, " + tableAlias + ".roles ";
    }

    @Override
    protected String getSqlUpdateFieldValues() {
        return super.getSqlUpdateFieldValues() + ", email=:email, enabled=:enabled, firstname=:firstname, lastname=:lastname, passwordhash=:passwordHash, roles=:roles";
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        switch (modelProperty) {
            case "firstname": 
            case "lastname": {
                return true;
            }
        }
        return false;
    }

    public void update(User user) {
        user.setLastModified(LocalDateTime.now());
        this.dbi.withHandle(h -> ((Query)((Handle)h.registerArrayType(Role.class, "varchar")).createQuery("UPDATE " + this.tableName + " SET email=:email, enabled=:enabled, firstname=:firstname, lastname=:lastname, last_modified=:lastModified, passwordhash=:passwordHash, roles=:roles WHERE uuid=:uuid RETURNING *").bindBean((Object)user)).mapToBean(User.class).findOne().orElse(null));
    }
}

