/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.alias.UrlAliasRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.work.ManifestationRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent.AgentRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.geo.location.HumanSettlementRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work.DerivedAgentBuildHelper;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work.TitleSqlHelper;
import de.digitalcollections.cudami.server.backend.impl.jdbi.type.LocalDateRangeMapper;
import de.digitalcollections.cudami.server.backend.impl.jdbi.type.MainSubTypeMapper;
import de.digitalcollections.cudami.server.backend.impl.jdbi.type.TitleMapper;
import de.digitalcollections.model.RelationSpecification;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.IdentifiableObjectType;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.agent.Agent;
import de.digitalcollections.model.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.identifiable.entity.agent.Family;
import de.digitalcollections.model.identifiable.entity.agent.Person;
import de.digitalcollections.model.identifiable.entity.geo.location.HumanSettlement;
import de.digitalcollections.model.identifiable.entity.manifestation.DistributionInfo;
import de.digitalcollections.model.identifiable.entity.manifestation.ExpressionType;
import de.digitalcollections.model.identifiable.entity.manifestation.Manifestation;
import de.digitalcollections.model.identifiable.entity.manifestation.ProductionInfo;
import de.digitalcollections.model.identifiable.entity.manifestation.PublicationInfo;
import de.digitalcollections.model.identifiable.entity.manifestation.Publisher;
import de.digitalcollections.model.identifiable.entity.manifestation.PublishingInfo;
import de.digitalcollections.model.identifiable.entity.relation.EntityRelation;
import de.digitalcollections.model.identifiable.entity.work.Work;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.text.LocalizedStructuredContent;
import de.digitalcollections.model.text.LocalizedText;
import de.digitalcollections.model.text.Title;
import de.digitalcollections.model.time.LocalDateRange;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.Vector;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.JdbiException;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.array.SqlArrayType;
import org.jdbi.v3.core.generic.GenericType;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.StatementException;
import org.jdbi.v3.core.statement.Update;
import org.springframework.stereotype.Repository;

@Repository
@SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"}, justification="Newline is OK in multiline strings")
public class ManifestationRepositoryImpl
extends EntityRepositoryImpl<Manifestation>
implements ManifestationRepository {
    public static final String MAPPING_PREFIX = "mf";
    public static final String TABLE_ALIAS = "mf";
    public static final String TABLE_NAME = "manifestations";
    private AgentRepositoryImpl<Agent> agentRepository;
    private EntityRepositoryImpl<Entity> entityRepository;
    private HumanSettlementRepositoryImpl humanSettlementRepository;

    private static void fillPublishers(List<Publisher> publishers, Agent publAgent, HumanSettlement publPlace) {
        if (publishers == null || publishers.isEmpty()) {
            return;
        }
        if (publAgent != null) {
            publishers.parallelStream().filter(p -> p != null && p.getAgent() != null && publAgent.getUuid().equals(p.getAgent().getUuid()) && p.getAgent().getCreated() == null && p.getAgent().getLastModified() == null).forEach(p -> p.setAgent(publAgent));
        }
        if (publPlace != null) {
            publishers.parallelStream().filter(p -> p != null && p.getLocations() != null && !p.getLocations().isEmpty()).map(Publisher::getLocations).forEach(settlements -> {
                Optional<HumanSettlement> old = settlements.parallelStream().filter(s -> s != null && publPlace.getUuid().equals(s.getUuid()) && s.getCreated() == null && s.getLastModified() == null).findAny();
                if (old.isPresent()) {
                    settlements.replaceAll(s -> Objects.equals(s, old.get()) ? publPlace : s);
                }
            });
        }
    }

    public ManifestationRepositoryImpl(Jdbi jdbi, CudamiConfig cudamiConfig, IdentifierRepository identifierRepository, UrlAliasRepository urlAliasRepository, MainSubTypeMapper.ExpressionTypeMapper expressionTypeMapper, LocalDateRangeMapper dateRangeMapper, TitleMapper titleMapper, EntityRepositoryImpl<Entity> entityRepository, AgentRepositoryImpl<Agent> agentRepository, HumanSettlementRepositoryImpl humanSettlementRepository) {
        super(jdbi, TABLE_NAME, "mf", "mf", (Class<? extends Entity>)Manifestation.class, cudamiConfig.getOffsetForAlternativePaging(), identifierRepository, urlAliasRepository);
        this.dbi.registerArrayType((SqlArrayType)expressionTypeMapper);
        this.dbi.registerArgument((ArgumentFactory)dateRangeMapper);
        this.dbi.registerColumnMapper(ExpressionType.class, (ColumnMapper)expressionTypeMapper);
        this.dbi.registerColumnMapper(LocalDateRange.class, (ColumnMapper)dateRangeMapper);
        this.dbi.registerColumnMapper(Title.class, (ColumnMapper)titleMapper);
        this.entityRepository = entityRepository;
        this.agentRepository = agentRepository;
        this.humanSettlementRepository = humanSettlementRepository;
    }

    @Override
    public Manifestation create() throws RepositoryException {
        return new Manifestation();
    }

    @Override
    protected BiConsumer<Map<UUID, Manifestation>, RowView> createAdditionalReduceRowsBiConsumer() {
        return (map, rowView) -> {
            HumanSettlement publPlace;
            Manifestation manifestation = (Manifestation)map.get(rowView.getColumn("mf_uuid", UUID.class));
            Agent publAgent = null;
            if (rowView.getColumn("ag_uuid", UUID.class) != null) {
                Agent ag = (Agent)rowView.getRow(Agent.class);
                publAgent = switch (ag.getIdentifiableObjectType()) {
                    case IdentifiableObjectType.CORPORATE_BODY -> DerivedAgentBuildHelper.build(ag, CorporateBody.class);
                    case IdentifiableObjectType.PERSON -> DerivedAgentBuildHelper.build(ag, Person.class);
                    case IdentifiableObjectType.FAMILY -> DerivedAgentBuildHelper.build(ag, Family.class);
                    default -> ag;
                };
            }
            HumanSettlement humanSettlement = publPlace = rowView.getColumn("hs_uuid", UUID.class) != null ? (HumanSettlement)rowView.getRow(HumanSettlement.class) : null;
            if (manifestation.getDistributionInfo() != null) {
                ManifestationRepositoryImpl.fillPublishers(manifestation.getDistributionInfo().getPublishers(), publAgent, publPlace);
            }
            if (manifestation.getProductionInfo() != null) {
                ManifestationRepositoryImpl.fillPublishers(manifestation.getProductionInfo().getPublishers(), publAgent, publPlace);
            }
            if (manifestation.getPublicationInfo() != null) {
                ManifestationRepositoryImpl.fillPublishers(manifestation.getPublicationInfo().getPublishers(), publAgent, publPlace);
            }
        };
    }

    @Override
    protected void extendReducedIdentifiable(Manifestation manifestation, RowView rowView) {
        Work work;
        UUID entityUuid;
        UUID parentUuid = (UUID)rowView.getColumn("parent_uuid", UUID.class);
        if (parentUuid != null) {
            if (manifestation.getParents() == null) {
                manifestation.setParents(new ArrayList(1));
            }
            String parentTitle = (String)rowView.getColumn("parent_title", String.class);
            if (!manifestation.getParents().parallelStream().anyMatch(relSpec -> Objects.equals(((Manifestation)relSpec.getSubject()).getUuid(), parentUuid) && Objects.equals(relSpec.getTitle(), parentTitle))) {
                Manifestation parent = ((Manifestation.ManifestationBuilder)((Manifestation.ManifestationBuilder)((Manifestation.ManifestationBuilder)((Manifestation.ManifestationBuilder)((Manifestation.ManifestationBuilder)((Manifestation.ManifestationBuilder)((Manifestation.ManifestationBuilder)Manifestation.builder().uuid(parentUuid)).label((LocalizedText)rowView.getColumn("parent_label", LocalizedText.class))).titles((List)rowView.getColumn("parent_titles", (GenericType)new GenericType<List<Title>>(){})).manifestationType((String)rowView.getColumn("parent_manifestationType", String.class)).refId((long)((Integer)rowView.getColumn("parent_refId", Integer.class)).intValue())).notes((List)rowView.getColumn("parent_notes", (GenericType)new GenericType<List<LocalizedStructuredContent>>(){}))).created((LocalDateTime)rowView.getColumn("parent_created", LocalDateTime.class))).lastModified((LocalDateTime)rowView.getColumn("parent_lastModified", LocalDateTime.class))).identifiableObjectType((IdentifiableObjectType)rowView.getColumn("parent_identifiableObjectType", IdentifiableObjectType.class))).build();
                manifestation.getParents().add(RelationSpecification.builder().title(parentTitle).sortKey((String)rowView.getColumn("parent_sortKey", String.class)).subject((UniqueObject)parent).build());
            }
        }
        if ((entityUuid = (UUID)rowView.getColumn(this.entityRepository.getMappingPrefix() + "_uuid", UUID.class)) != null) {
            if (manifestation.getRelations() == null || manifestation.getRelations().isEmpty()) {
                int maxIndex = (Integer)rowView.getColumn("relation_max_sortindex", Integer.class);
                Vector relations = new Vector(++maxIndex);
                relations.setSize(maxIndex);
                manifestation.setRelations(relations);
            }
            String relationPredicate = (String)rowView.getColumn("rel_predicate", String.class);
            if (!manifestation.getRelations().stream().anyMatch(relation -> relation != null && Objects.equals(entityUuid, relation.getSubject().getUuid()) && Objects.equals(relationPredicate, relation.getPredicate()))) {
                Entity relatedEntity = (Entity)rowView.getRow(Entity.class);
                manifestation.getRelations().set((Integer)rowView.getColumn("rel_sortindex", Integer.class), EntityRelation.builder().subject(relatedEntity).predicate(relationPredicate).additionalPredicates((List)rowView.getColumn("rel_additionalPredicates", (GenericType)new GenericType<List<String>>(){})).build());
            }
        }
        if (manifestation.getWork() == null && (work = (Work)rowView.getRow(Work.class)) != null && work.getUuid() != null) {
            manifestation.setWork(work);
        }
    }

    public PageResponse<Manifestation> findManifestationsByWork(UUID workUuid, PageRequest pageRequest) throws RepositoryException {
        String manifestationTableAlias = this.getTableAlias();
        String manifestationTableName = this.getTableName();
        StringBuilder commonSql = new StringBuilder(" FROM " + manifestationTableName + " AS " + manifestationTableAlias + " WHERE " + manifestationTableAlias + ".work = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", workUuid);
        Filtering filtering = pageRequest.getFiltering();
        this.mapFilterExpressionsToOtherTableColumnNames(filtering, this);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT * " + commonSql);
        this.addPagingAndSorting(pageRequest, innerQuery);
        List result = this.retrieveList(this.getSqlSelectReducedFields(), innerQuery, argumentMappings, this.getOrderBy(pageRequest.getSorting()));
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total);
    }

    public PageResponse<Manifestation> findSubParts(UUID uuid, PageRequest pageRequest) throws RepositoryException {
        String doTableName = "manifestation_manifestations";
        String doTableAlias = "mms";
        StringBuilder commonSql = new StringBuilder(" FROM manifestation_manifestations AS mms INNER JOIN " + this.tableName + " " + this.tableAlias + " ON mms.object_uuid = " + this.tableAlias + ".uuid WHERE mms.subject_uuid = :subject_uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("subject_uuid", uuid);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT " + this.tableAlias + ".* " + commonSql);
        this.addPagingAndSorting(pageRequest, innerQuery);
        List result = this.retrieveList(this.getSqlSelectReducedFields(), innerQuery, argumentMappings, this.getOrderBy(pageRequest.getSorting()));
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total);
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> orderByFields = super.getAllowedOrderByFields();
        return orderByFields;
    }

    @Override
    public String getColumnName(String modelProperty) {
        switch (modelProperty) {
            case "composition": 
            case "dimensions": 
            case "language": 
            case "scale": 
            case "titles": 
            case "version": 
            case "work": {
                return modelProperty;
            }
            case "expressionTypes": 
            case "manifestationType": 
            case "manufacturingType": 
            case "mediaTypes": 
            case "otherLanguages": {
                return modelProperty.toLowerCase();
            }
        }
        return super.getColumnName(modelProperty);
    }

    public List<Locale> getLanguagesOfManifestationsForWork(UUID workUuid) {
        String manifestationTableAlias = this.getTableAlias();
        String manifestationTableName = this.getTableName();
        String sql = "SELECT DISTINCT jsonb_object_keys(" + manifestationTableAlias + ".label) as languages FROM " + manifestationTableName + " AS " + manifestationTableAlias + String.format(" WHERE %s.work = :work_uuid;", manifestationTableAlias);
        return (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("work_uuid", workUuid)).mapTo(Locale.class).list());
    }

    @Override
    protected String getSqlInsertFields() {
        return super.getSqlInsertFields() + ", composition, dimensions, expressiontypes,\nlanguage, manifestationtype, manufacturingtype,\nmediatypes, otherlanguages,\nscale, version, work, titles,\npublication_info, publication_nav_date,\nproduction_info, production_nav_date,\ndistribution_info, distribution_nav_date,\npublishing_info_agent_uuids, publishing_info_locations_uuids\n";
    }

    @Override
    protected String getSqlInsertValues() {
        return super.getSqlInsertValues() + ", :composition, :dimensions, :expressionTypes::mainsubtype[],\n:language, :manifestationType, :manufacturingType,\n:mediaTypes::varchar[], :otherLanguages::varchar[],\n:scale, :version, :work?.uuid, {{titles}},\n:publicationInfo::jsonb, :publicationInfo?.navDateRange::daterange,\n:productionInfo::jsonb, :productionInfo?.navDateRange::daterange,\n:distributionInfo::jsonb, :distributionInfo?.navDateRange::daterange,\n:publishingInfoAgentUuids, :publishingInfoLocationsUuids\n";
    }

    @Override
    public String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectAllFields(tableAlias, mappingPrefix) + ", %1$s.composition %2$s_composition, %1$s.dimensions %2$s_dimensions, %1$s.otherlanguages %2$s_otherLanguages,\n%1$s.scale %2$s_scale, %1$s.version %2$s_version,\n%1$s.publication_info %2$s_publicationInfo, %1$s.production_info %2$s_productionInfo,\n%1$s.distribution_info %2$s_distributionInfo,\n".formatted(tableAlias, mappingPrefix) + "%s, %s".formatted(this.agentRepository.getSqlSelectReducedFields(), this.humanSettlementRepository.getSqlSelectReducedFields());
    }

    @Override
    protected String getSqlSelectAllFieldsJoins() {
        return super.getSqlSelectAllFieldsJoins() + "LEFT JOIN %2$s %3$s ON %3$s.uuid = ANY (%1$s.publishing_info_agent_uuids)\nLEFT JOIN %4$s %5$s ON %5$s.uuid = ANY (%1$s.publishing_info_locations_uuids)\n".formatted(this.tableAlias, "agents", "ag", "humansettlements", "h");
    }

    @Override
    public String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", %1$s.expressiontypes %2$s_expressionTypes, %1$s.language %2$s_language, %1$s.manifestationtype %2$s_manifestationType,\n%1$s.manufacturingtype %2$s_manufacturingType, %1$s.mediatypes %2$s_mediaTypes,\n%1$s.titles %2$s_titles,\n%3$s.uuid %4$s_uuid, %3$s.label %4$s_label,\n".formatted(tableAlias, mappingPrefix, "w", "wo") + "mms.title parent_title, mms.sortKey parent_sortKey,\nparent.uuid parent_uuid, parent.label parent_label, parent.titles parent_titles, parent.manifestationtype parent_manifestationType,\nparent.refid parent_refId, parent.notes parent_notes, parent.created parent_created, parent.last_modified parent_lastModified,\nparent.identifiable_objecttype parent_identifiableObjectType,\n" + "%1$s.predicate %2$s_predicate, %1$s.sortindex %2$s_sortindex,\n%1$s.additional_predicates %2$s_additionalPredicates,\nmax(%1$s.sortindex) OVER (PARTITION BY %3$s.uuid) relation_max_sortindex,".formatted("rel", "rel", tableAlias) + this.entityRepository.getSqlSelectReducedFields();
    }

    @Override
    protected String getSqlSelectReducedFieldsJoins() {
        return super.getSqlSelectReducedFieldsJoins() + "LEFT JOIN (\n  manifestation_manifestations mms INNER JOIN manifestations parent\n  ON parent.uuid = mms.subject_uuid\n) ON mms.object_uuid = %1$s.uuid\nLEFT JOIN (\n  %2$s %3$s INNER JOIN %4$s %5$s ON %3$s.subject_uuid = %5$s.uuid\n) ON %3$s.object_uuid = %1$s.uuid\nLEFT JOIN %6$s %7$s ON %7$s.uuid = %1$s.work\n".formatted(this.tableAlias, "rel_entity_entities", "rel", "entities", "e", "works", "w");
    }

    @Override
    public String getSqlUpdateFieldValues() {
        return super.getSqlUpdateFieldValues() + ", composition=:composition, dimensions=:dimensions, expressiontypes=:expressionTypes::mainsubtype[],\nlanguage=:language, manifestationtype=:manifestationType, manufacturingtype=:manufacturingType,\nmediatypes=:mediaTypes::varchar[], otherlanguages=:otherLanguages::varchar[],\nscale=:scale, version=:version, work=:work?.uuid, titles={{titles}},\npublication_info=:publicationInfo::jsonb, publication_nav_date=:publicationInfo?.navDateRange::daterange,\nproduction_info=:productionInfo::jsonb, production_nav_date=:productionInfo?.navDateRange::daterange,\ndistribution_info=:distributionInfo::jsonb, distribution_nav_date=:distributionInfo?.navDateRange::daterange,\npublishing_info_agent_uuids=:publishingInfoAgentUuids, publishing_info_locations_uuids=:publishingInfoLocationsUuids\n";
    }

    private <P extends PublishingInfo> P reducePublisher(P publishingInfo) throws RepositoryException {
        PublishingInfo result;
        if (publishingInfo == null) {
            return null;
        }
        try {
            result = (PublishingInfo)publishingInfo.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RepositoryException("PublishingInfo cannot be instantiated", (Throwable)e);
        }
        result.setDatePresentation(publishingInfo.getDatePresentation());
        result.setNavDateRange(publishingInfo.getNavDateRange());
        result.setTimeValueRange(publishingInfo.getTimeValueRange());
        if (publishingInfo.getPublishers() == null) {
            return (P)result;
        }
        List<Publisher> publishers = publishingInfo.getPublishers().stream().filter(Objects::nonNull).map(publ -> {
            Publisher publisher = new Publisher();
            publisher.setDatePresentation(publ.getDatePresentation());
            if (publ.getAgent() != null) {
                Agent agent;
                try {
                    agent = (Agent)publ.getAgent().getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    agent = new Agent();
                }
                agent.setUuid(publ.getAgent().getUuid());
                publisher.setAgent(agent);
            }
            if (publ.getLocations() != null && !publ.getLocations().isEmpty()) {
                List<HumanSettlement> locations = publ.getLocations().stream().filter(settlement -> settlement != null && settlement.getUuid() != null).map(settlement -> ((HumanSettlement.HumanSettlementBuilder)HumanSettlement.builder().uuid(settlement.getUuid())).build()).toList();
                publisher.setLocations(locations);
            }
            return publisher;
        }).toList();
        result.setPublishers(publishers);
        return (P)result;
    }

    public boolean removeParent(Manifestation manifestation, Manifestation parentManifestation) throws RepositoryException {
        String sql = "DELETE FROM manifestation_manifestations WHERE subject_uuid=:subject_uuid and object_uuid=:object_uuid";
        try {
            return (Integer)this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM manifestation_manifestations WHERE subject_uuid=:subject_uuid and object_uuid=:object_uuid").bind("object_uuid", manifestation.getUuid())).bind("subject_uuid", parentManifestation.getUuid())).execute()) == 1;
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new RepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public void save(Manifestation manifestation, Map<String, Object> bindings) throws RepositoryException {
        if (bindings == null) {
            bindings = new HashMap<String, Object>(3);
        }
        DistributionInfo distributionInfo = manifestation.getDistributionInfo();
        manifestation.setDistributionInfo(this.reducePublisher(distributionInfo));
        ProductionInfo productionInfo = manifestation.getProductionInfo();
        manifestation.setProductionInfo(this.reducePublisher(productionInfo));
        PublicationInfo publicationInfo = manifestation.getPublicationInfo();
        manifestation.setPublicationInfo(this.reducePublisher(publicationInfo));
        this.setPublishingInfoBindings(bindings, new PublishingInfo[]{distributionInfo, productionInfo, publicationInfo});
        super.save(manifestation, bindings, TitleSqlHelper.buildTitleSql(manifestation.getTitles()));
        this.saveParents(manifestation);
        manifestation.setDistributionInfo(distributionInfo);
        manifestation.setProductionInfo(productionInfo);
        manifestation.setPublicationInfo(publicationInfo);
    }

    private void saveParents(Manifestation manifestation) {
        if (manifestation == null) {
            return;
        }
        this.dbi.useHandle(h -> ((Update)h.createUpdate("DELETE FROM manifestation_manifestations WHERE object_uuid = :uuid").bind("uuid", manifestation.getUuid())).execute());
        if (manifestation.getParents() == null || manifestation.getParents().isEmpty()) {
            return;
        }
        this.dbi.useHandle(h -> {
            PreparedBatch batch = h.prepareBatch("INSERT INTO manifestation_manifestations (\n  subject_uuid, object_uuid, title, sortkey\n) VALUES (\n  :subject, :object, :title, :sortkey\n)");
            for (RelationSpecification parent : manifestation.getParents()) {
                if (parent.getSubject() == null || ((Manifestation)parent.getSubject()).getUuid() == null) continue;
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bind("object", manifestation.getUuid())).bind("subject", ((Manifestation)parent.getSubject()).getUuid())).bind("title", parent.getTitle())).bind("sortkey", parent.getSortKey())).add();
            }
            batch.execute();
        });
    }

    private void setPublishingInfoBindings(Map<String, Object> bindings, PublishingInfo ... publishingInfos) {
        if (bindings == null || publishingInfos.length < 1) {
            return;
        }
        bindings.put("publishingInfoAgentUuids", this.extractUuids(Stream.of(publishingInfos).filter(pinfo -> Objects.nonNull(pinfo) && Objects.nonNull(pinfo.getPublishers())).map(p -> p.getPublishers().stream()).flatMap(s -> s).filter(publisher -> Objects.nonNull(publisher) && Objects.nonNull(publisher.getAgent())).map(Publisher::getAgent).toList()));
        bindings.put("publishingInfoLocationsUuids", this.extractUuids(Stream.of(publishingInfos).filter(pinfo -> Objects.nonNull(pinfo) && Objects.nonNull(pinfo.getPublishers())).map(p -> p.getPublishers().stream()).flatMap(s -> s).filter(publisher -> Objects.nonNull(publisher) && Objects.nonNull(publisher.getLocations())).flatMap(publisher -> publisher.getLocations().stream()).toList()));
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        switch (modelProperty) {
            case "composition": 
            case "dimensions": 
            case "language": 
            case "manifestationType": 
            case "manufacturingType": 
            case "publishingDatePresentation": 
            case "scale": 
            case "version": {
                return true;
            }
        }
        return super.supportsCaseSensitivityForProperty(modelProperty);
    }

    @Override
    public void update(Manifestation manifestation, Map<String, Object> bindings) throws RepositoryException {
        if (bindings == null) {
            bindings = new HashMap<String, Object>(3);
        }
        DistributionInfo distributionInfo = manifestation.getDistributionInfo();
        manifestation.setDistributionInfo(this.reducePublisher(distributionInfo));
        ProductionInfo productionInfo = manifestation.getProductionInfo();
        manifestation.setProductionInfo(this.reducePublisher(productionInfo));
        PublicationInfo publicationInfo = manifestation.getPublicationInfo();
        manifestation.setPublicationInfo(this.reducePublisher(publicationInfo));
        this.setPublishingInfoBindings(bindings, new PublishingInfo[]{distributionInfo, productionInfo, publicationInfo});
        super.update(manifestation, bindings, TitleSqlHelper.buildTitleSql(manifestation.getTitles()));
        this.saveParents(manifestation);
        manifestation.setDistributionInfo(distributionInfo);
        manifestation.setProductionInfo(productionInfo);
        manifestation.setPublicationInfo(publicationInfo);
    }
}

