/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.alias.UrlAliasRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.work.ItemRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.DigitalObjectRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent.AgentRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work.DerivedAgentBuildHelper;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.agent.Agent;
import de.digitalcollections.model.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.identifiable.entity.agent.Family;
import de.digitalcollections.model.identifiable.entity.agent.Person;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.identifiable.entity.item.Item;
import de.digitalcollections.model.identifiable.entity.manifestation.Manifestation;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.text.LocalizedText;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository
public class ItemRepositoryImpl
extends EntityRepositoryImpl<Item>
implements ItemRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "it";
    public static final String TABLE_ALIAS = "i";
    public static final String TABLE_NAME = "items";
    private final AgentRepositoryImpl agentRepository;
    private final DigitalObjectRepositoryImpl digitalObjectRepositoryImpl;

    public ItemRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig, IdentifierRepository identifierRepository, UrlAliasRepository urlAliasRepository, @Lazy DigitalObjectRepositoryImpl digitalObjectRepositoryImpl, @Lazy AgentRepositoryImpl agentRepository) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, (Class<? extends Entity>)Item.class, cudamiConfig.getOffsetForAlternativePaging(), identifierRepository, urlAliasRepository);
        this.digitalObjectRepositoryImpl = digitalObjectRepositoryImpl;
        this.agentRepository = agentRepository;
    }

    @Override
    public Item create() throws RepositoryException {
        return new Item();
    }

    @Override
    protected BiConsumer<Map<UUID, Item>, RowView> createAdditionalReduceRowsBiConsumer() {
        return (map, rowView) -> {
            Item item = (Item)map.get(rowView.getColumn("it_uuid", UUID.class));
            if (item.getPartOfItem() != null) {
                if (item.getPartOfItem().getLabel() != null) {
                    return;
                }
                LocalizedText partOfItemLabel = (LocalizedText)rowView.getColumn("poi_label", LocalizedText.class);
                item.getPartOfItem().setLabel(partOfItemLabel);
            }
            if (item.getManifestation() != null) {
                if (item.getManifestation().getLabel() != null) {
                    return;
                }
                LocalizedText manifestationLabel = (LocalizedText)rowView.getColumn("it_manifestation_label", LocalizedText.class);
                item.getManifestation().setLabel(manifestationLabel);
            }
        };
    }

    @Override
    protected void extendReducedIdentifiable(Item identifiable, RowView rowView) {
        super.extendReducedIdentifiable(identifiable, rowView);
        Agent holder = null;
        if (rowView.getColumn("ag_uuid", UUID.class) != null) {
            CorporateBody exactholder;
            holder = (Agent)rowView.getRow(Agent.class);
            switch (holder.getIdentifiableObjectType()) {
                case CORPORATE_BODY: {
                    CorporateBody corporateBody = DerivedAgentBuildHelper.build(holder, CorporateBody.class);
                    break;
                }
                case PERSON: {
                    CorporateBody corporateBody = DerivedAgentBuildHelper.build(holder, Person.class);
                    break;
                }
                case FAMILY: {
                    CorporateBody corporateBody = DerivedAgentBuildHelper.build(holder, Family.class);
                    break;
                }
                default: {
                    CorporateBody corporateBody = exactholder = null;
                }
            }
            if (exactholder != null) {
                holder = exactholder;
            }
        }
        UUID partOfItemUuid = (UUID)rowView.getColumn("it_part_of_item_uuid", UUID.class);
        UUID manifestationUuid = (UUID)rowView.getColumn("it_manifestation_uuid", UUID.class);
        if (identifiable.getHolders() == null) {
            identifiable.setHolders(new ArrayList());
        }
        if (holder != null && !identifiable.getHolders().contains(holder)) {
            identifiable.getHolders().add(holder);
        }
        if (partOfItemUuid != null && identifiable.getPartOfItem() == null) {
            identifiable.setPartOfItem(((Item.ItemBuilder)Item.builder().uuid(partOfItemUuid)).build());
        }
        if (manifestationUuid != null && identifiable.getManifestation() == null) {
            identifiable.setManifestation(((Manifestation.ManifestationBuilder)Manifestation.builder().uuid(manifestationUuid)).build());
        }
    }

    public PageResponse<DigitalObject> findDigitalObjects(UUID itemUuid, PageRequest pageRequest) throws RepositoryException {
        String doTableAlias = this.digitalObjectRepositoryImpl.getTableAlias();
        String doTableName = this.digitalObjectRepositoryImpl.getTableName();
        StringBuilder commonSql = new StringBuilder(" FROM " + doTableName + " AS " + doTableAlias + " WHERE " + doTableAlias + ".item_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", itemUuid);
        Filtering filtering = pageRequest.getFiltering();
        this.mapFilterExpressionsToOtherTableColumnNames(filtering, this.digitalObjectRepositoryImpl);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT * " + commonSql);
        this.digitalObjectRepositoryImpl.addPagingAndSorting(pageRequest, innerQuery);
        List result = this.digitalObjectRepositoryImpl.retrieveList(this.digitalObjectRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, this.getOrderBy(pageRequest.getSorting()));
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total);
    }

    public PageResponse<Item> findItemsByManifestation(UUID manifestationUuid, PageRequest pageRequest) throws RepositoryException {
        String itemTableAlias = this.getTableAlias();
        String itemTableName = this.getTableName();
        StringBuilder commonSql = new StringBuilder(" FROM " + itemTableName + " AS " + itemTableAlias + " WHERE " + itemTableAlias + ".manifestation = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", manifestationUuid);
        Filtering filtering = pageRequest.getFiltering();
        this.mapFilterExpressionsToOtherTableColumnNames(filtering, this);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT * " + commonSql);
        this.addPagingAndSorting(pageRequest, innerQuery);
        List result = this.retrieveList(this.getSqlSelectReducedFields(), innerQuery, argumentMappings, this.getOrderBy(pageRequest.getSorting()));
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total);
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "partOfItem.uuid": {
                return this.tableAlias + ".part_of_item";
            }
        }
        return super.getColumnName(modelProperty);
    }

    public List<Locale> getLanguagesOfDigitalObjects(UUID uuid) {
        String doTableAlias = this.digitalObjectRepositoryImpl.getTableAlias();
        String doTableName = this.digitalObjectRepositoryImpl.getTableName();
        String sql = "SELECT DISTINCT jsonb_object_keys(" + doTableAlias + ".label) as languages FROM " + doTableName + " AS " + doTableAlias + String.format(" WHERE %s.item_uuid = :uuid;", doTableAlias);
        return (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", uuid)).mapTo(Locale.class).list());
    }

    public List<Locale> getLanguagesOfItemsForManifestation(UUID manifestationUuid) {
        String itemTableAlias = this.getTableAlias();
        String itemTableName = this.getTableName();
        String sql = "SELECT DISTINCT jsonb_object_keys(" + itemTableAlias + ".label) as languages FROM " + itemTableName + " AS " + itemTableAlias + String.format(" WHERE %s.manifestation = :manifestation_uuid;", itemTableAlias);
        return (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("manifestation_uuid", manifestationUuid)).mapTo(Locale.class).list());
    }

    @Override
    protected String getSqlInsertFields() {
        return super.getSqlInsertFields() + ", exemplifies_manifestation, manifestation, holder_uuids, part_of_item";
    }

    @Override
    protected String getSqlInsertValues() {
        return super.getSqlInsertValues() + ", :exemplifiesManifestation, :manifestation?.uuid, :holder_uuids::UUID[], :partOfItem?.uuid";
    }

    @Override
    public String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return this.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", %1$s.exemplifies_manifestation %2$s_exemplifies_manifestation,\npoi.label poi_label,\n%3$s.label %2$s_manifestation_label\n".formatted(tableAlias, mappingPrefix, "mf");
    }

    @Override
    protected String getSqlSelectAllFieldsJoins() {
        return super.getSqlSelectAllFieldsJoins() + "LEFT JOIN %1$s poi ON %2$s.part_of_item = poi.uuid\nLEFT JOIN %3$s %4$s ON %4$s.uuid = %2$s.manifestation\n".formatted(this.tableName, this.tableAlias, "manifestations", "mf");
    }

    @Override
    public String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".part_of_item " + mappingPrefix + "_part_of_item_uuid, " + tableAlias + ".manifestation " + mappingPrefix + "_manifestation_uuid, " + this.agentRepository.getSqlSelectReducedFields("holdertable", "ag");
    }

    @Override
    protected String getSqlSelectReducedFieldsJoins() {
        return super.getSqlSelectReducedFieldsJoins() + "LEFT JOIN %2$s %3$s ON %3$s.uuid = ANY(%1$s.holder_uuids)\n".formatted(this.tableAlias, "agents", "holdertable");
    }

    @Override
    public String getSqlUpdateFieldValues() {
        return super.getSqlUpdateFieldValues() + ", exemplifies_manifestation=:exemplifiesManifestation, manifestation=:manifestation?.uuid, holder_uuids=:holder_uuids, part_of_item=:partOfItem?.uuid";
    }

    public void save(Item item) throws RepositoryException {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("holder_uuids", this.extractUuids(item.getHolders()));
        super.save(item, bindings);
    }

    public void update(Item item) throws RepositoryException {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("holder_uuids", this.extractUuids(item.getHolders()));
        super.update(item, (Map<String, Object>)bindings);
    }
}

