/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.alias.UrlAliasRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.agent.PersonRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.agent.FamilyNameRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.agent.GivenNameRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.DigitalObjectRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent.AgentRepositoryImpl;
import de.digitalcollections.model.identifiable.agent.FamilyName;
import de.digitalcollections.model.identifiable.agent.GivenName;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.agent.Person;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.identifiable.entity.geo.location.GeoLocation;
import de.digitalcollections.model.identifiable.entity.geo.location.GeoLocationType;
import de.digitalcollections.model.text.LocalizedText;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class PersonRepositoryImpl
extends AgentRepositoryImpl<Person>
implements PersonRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "pe";
    public static final String TABLE_ALIAS = "p";
    public static final String TABLE_NAME = "persons";
    private final DigitalObjectRepositoryImpl digitalObjectRepositoryImpl;
    private final FamilyNameRepositoryImpl familyNameRepositoryImpl;
    private final GivenNameRepositoryImpl givenNameRepositoryImpl;

    public PersonRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig, IdentifierRepository identifierRepository, UrlAliasRepository urlAliasRepository, DigitalObjectRepositoryImpl digitalObjectRepositoryImpl, FamilyNameRepositoryImpl familyNameRepositoryImpl, GivenNameRepositoryImpl givenNameRepositoryImpl) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, (Class<? extends Entity>)Person.class, cudamiConfig.getOffsetForAlternativePaging(), identifierRepository, urlAliasRepository);
        this.digitalObjectRepositoryImpl = digitalObjectRepositoryImpl;
        this.familyNameRepositoryImpl = familyNameRepositoryImpl;
        this.givenNameRepositoryImpl = givenNameRepositoryImpl;
    }

    @Override
    public Person create() throws RepositoryException {
        return new Person();
    }

    @Override
    protected BiConsumer<Map<UUID, Person>, RowView> createAdditionalReduceRowsBiConsumer() {
        return (map, rowView) -> {
            GeoLocationType geoLocationType;
            LocalizedText label;
            Long glRefId;
            Person person = (Person)map.get(rowView.getColumn(this.mappingPrefix + "_uuid", UUID.class));
            if (rowView.getColumn("glbirth_uuid", UUID.class) != null) {
                UUID glBirthUuid = (UUID)rowView.getColumn("glbirth_uuid", UUID.class);
                glRefId = (Long)rowView.getColumn("glbirth_refid", Long.class);
                label = (LocalizedText)rowView.getColumn("glbirth_label", LocalizedText.class);
                geoLocationType = (GeoLocationType)rowView.getColumn("glbirth_geoLocationType", GeoLocationType.class);
                GeoLocation placeOfBirth = new GeoLocation();
                placeOfBirth.setUuid(glBirthUuid);
                placeOfBirth.setRefId(glRefId.longValue());
                placeOfBirth.setLabel(label);
                placeOfBirth.setGeoLocationType(geoLocationType);
                person.setPlaceOfBirth(placeOfBirth);
            }
            if (rowView.getColumn("gldeath_uuid", UUID.class) != null) {
                UUID glDeathUuid = (UUID)rowView.getColumn("gldeath_uuid", UUID.class);
                glRefId = (Long)rowView.getColumn("gldeath_refid", Long.class);
                label = (LocalizedText)rowView.getColumn("gldeath_label", LocalizedText.class);
                geoLocationType = (GeoLocationType)rowView.getColumn("gldeath_geoLocationType", GeoLocationType.class);
                GeoLocation placeOfDeath = new GeoLocation();
                placeOfDeath.setUuid(glDeathUuid);
                placeOfDeath.setRefId(glRefId.longValue());
                placeOfDeath.setLabel(label);
                placeOfDeath.setGeoLocationType(geoLocationType);
                person.setPlaceOfDeath(placeOfDeath);
            }
            try {
                if (rowView.getColumn("fn_uuid", UUID.class) != null) {
                    person.getFamilyNames().add((FamilyName)rowView.getRow(FamilyName.class));
                }
                if (rowView.getColumn("gn_uuid", UUID.class) != null) {
                    person.getGivenNames().add((GivenName)rowView.getRow(GivenName.class));
                }
            }
            catch (Exception e) {
                LOGGER.debug("No family name or given name in rowview. Skipping.");
            }
        };
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "dateOfBirth": {
                return this.tableAlias + ".dateofbirth";
            }
            case "dateOfDeath": {
                return this.tableAlias + ".dateofdeath";
            }
            case "gender": {
                return this.tableAlias + ".gender";
            }
            case "placeOfBirth": {
                return this.tableAlias + ".locationofbirth";
            }
            case "placeOfDeath": {
                return this.tableAlias + ".locationofdeath";
            }
            case "timeValueOfBirth": {
                return this.tableAlias + ".timevalueofbirth";
            }
            case "timeValueOfDeath": {
                return this.tableAlias + ".timevalueofdeath";
            }
        }
        return super.getColumnName(modelProperty);
    }

    @Override
    public Set<DigitalObject> getDigitalObjects(UUID uuidPerson) throws RepositoryException {
        String doTableAlias = this.digitalObjectRepositoryImpl.getTableAlias();
        String doTableName = this.digitalObjectRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + doTableName + " AS " + doTableAlias + " LEFT JOIN item_digitalobjects AS itdi ON " + doTableAlias + ".uuid = itdi.digitalobject_uuid LEFT JOIN item_works AS itwo ON itdi.item_uuid = itwo.item_uuid LEFT JOIN work_creators AS wocr ON itwo.work_uuid = wocr.work_uuid WHERE wocr.agent_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", uuidPerson);
        List list = this.digitalObjectRepositoryImpl.retrieveList(this.digitalObjectRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, null);
        return list.stream().collect(Collectors.toSet());
    }

    @Override
    protected String getSqlInsertFields() {
        return super.getSqlInsertFields() + ", dateofbirth, dateofdeath, gender, locationofbirth, locationofdeath, timevalueofbirth, timevalueofdeath";
    }

    @Override
    protected String getSqlInsertValues() {
        return super.getSqlInsertValues() + ", :dateOfBirth, :dateOfDeath, :gender, :locationOfBirth, :locationOfDeath, :timeValueOfBirth::JSONB, :timeValueOfDeath::JSONB";
    }

    @Override
    public String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        String familyNameMappingPrefix = "fn";
        String givenNameMappingPrefix = "gn";
        return super.getSqlSelectAllFields(tableAlias, mappingPrefix) + ", glbirth.uuid glbirth_uuid, glbirth.refId glbirth_refid, glbirth.label glbirth_label, glbirth.geolocation_type glbirth_geoLocationType, gldeath.uuid gldeath_uuid, gldeath.refId gldeath_refid, gldeath.label gldeath_label, gldeath.geolocation_type gldeath_geoLocationType, fn.uuid fn_uuid, fn.label fn_label, gn.uuid gn_uuid, gn.label gn_label";
    }

    @Override
    protected String getSqlSelectAllFieldsJoins() {
        return super.getSqlSelectAllFieldsJoins() + "LEFT JOIN geolocations AS glbirth ON glbirth.uuid = %1$s.locationofbirth\nLEFT JOIN geolocations AS gldeath ON gldeath.uuid = %1$s.locationofdeath\nLEFT JOIN (\n  person_familynames pf INNER JOIN familynames fn ON fn.uuid = pf.familyname_uuid\n) ON pf.person_uuid = p.uuid\nLEFT JOIN (\n  person_givennames pg INNER JOIN givennames gn ON gn.uuid = pg.givenname_uuid\n) ON pg.person_uuid = p.uuid\n".formatted(this.tableAlias);
    }

    @Override
    public String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".dateofbirth " + mappingPrefix + "_dateOfBirth, " + tableAlias + ".dateofdeath " + mappingPrefix + "_dateOfDeath, " + tableAlias + ".gender " + mappingPrefix + "_gender, " + tableAlias + ".timevalueofbirth " + mappingPrefix + "_timeValueOfBirth, " + tableAlias + ".timevalueofdeath " + mappingPrefix + "_timeValueOfDeath";
    }

    @Override
    public String getSqlUpdateFieldValues() {
        return super.getSqlUpdateFieldValues() + ", dateofbirth=:dateOfBirth, dateofdeath=:dateOfDeath, gender=:gender, locationofbirth=:locationOfBirth, locationofdeath=:locationOfDeath, timevalueofbirth=:timeValueOfBirth::JSONB, timevalueofdeath=:timeValueOfDeath::JSONB";
    }

    public void save(Person person) throws RepositoryException {
        UUID locationOfBirthUuid = person.getPlaceOfBirth() == null ? null : person.getPlaceOfBirth().getUuid();
        UUID locationOfDeathUuid = person.getPlaceOfDeath() == null ? null : person.getPlaceOfDeath().getUuid();
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("locationOfBirth", locationOfBirthUuid);
        bindings.put("locationOfDeath", locationOfDeathUuid);
        super.save(person, bindings);
        List givenNames = person.getGivenNames();
        this.setRelatedGivenNames(givenNames, person);
        List familyNames = person.getFamilyNames();
        this.setRelatedFamilyNames(familyNames, person);
    }

    private void setRelatedFamilyNames(List<FamilyName> familyNames, Person person) {
        if (familyNames != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO person_familynames(person_uuid, familyname_uuid, sortIndex) VALUES(:uuid, :familynameUuid, :sortIndex)");
                int i = 0;
                for (FamilyName familyName : familyNames) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", person.getUuid())).bind("familynameUuid", familyName.getUuid())).bind("sortIndex", i)).add();
                    ++i;
                }
                preparedBatch.execute();
            });
        }
    }

    private void setRelatedGivenNames(List<GivenName> givenNames, Person person) {
        if (givenNames != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO person_givennames(person_uuid, givenname_uuid, sortIndex) VALUES(:uuid, :givennameUuid, :sortIndex)");
                int i = 0;
                for (GivenName givenName : givenNames) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", person.getUuid())).bind("givennameUuid", givenName.getUuid())).bind("sortIndex", i)).add();
                    ++i;
                }
                preparedBatch.execute();
            });
        }
    }

    public void update(Person person) throws RepositoryException {
        UUID locationOfBirthUuid = person.getPlaceOfBirth() == null ? null : person.getPlaceOfBirth().getUuid();
        UUID locationOfDeathUuid = person.getPlaceOfDeath() == null ? null : person.getPlaceOfDeath().getUuid();
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("locationOfBirth", locationOfBirthUuid);
        bindings.put("locationOfDeath", locationOfDeathUuid);
        super.update(person, (Map<String, Object>)bindings);
        List givenNames = person.getGivenNames();
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM person_givennames WHERE person_uuid = :uuid").bind("uuid", person.getUuid())).execute());
        this.setRelatedGivenNames(givenNames, person);
        List familyNames = person.getFamilyNames();
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM person_familynames WHERE person_uuid = :uuid").bind("uuid", person.getUuid())).execute());
        this.setRelatedFamilyNames(familyNames, person);
    }
}

