/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.alias.UrlAliasRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.agent.CorporateBodyRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent.AgentRepositoryImpl;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class CorporateBodyRepositoryImpl
extends AgentRepositoryImpl<CorporateBody>
implements CorporateBodyRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CorporateBodyRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "cb";
    public static final String TABLE_ALIAS = "c";
    public static final String TABLE_NAME = "corporatebodies";

    public CorporateBodyRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig, IdentifierRepository identifierRepository, UrlAliasRepository urlAliasRepository) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, (Class<? extends Entity>)CorporateBody.class, cudamiConfig.getOffsetForAlternativePaging(), identifierRepository, urlAliasRepository);
    }

    @Override
    public CorporateBody create() throws RepositoryException {
        return new CorporateBody();
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "homepageUrl": {
                return this.tableAlias + ".homepage_url";
            }
        }
        return super.getColumnName(modelProperty);
    }

    @Override
    public String getSqlInsertFields() {
        return super.getSqlInsertFields() + ", homepage_url, text";
    }

    @Override
    public String getSqlInsertValues() {
        return super.getSqlInsertValues() + ", :homepageUrl, :text::JSONB";
    }

    @Override
    public String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectAllFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".text " + mappingPrefix + "_text";
    }

    @Override
    public String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".homepage_url " + mappingPrefix + "_homepageUrl";
    }

    @Override
    public String getSqlUpdateFieldValues() {
        return super.getSqlUpdateFieldValues() + ", homepage_url=:homepageUrl, text=:text::JSONB";
    }

    public List<CorporateBody> findCollectionRelatedCorporateBodies(UUID collectionUuid, Filtering filtering) throws RepositoryException {
        FilterCriterion predicate;
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM {{tableName}} {{tableAlias}}\nLEFT JOIN rel_entity_entities AS r ON {{tableAlias}}.uuid = r.object_uuid\nLEFT JOIN rel_entity_entities AS rel ON r.subject_uuid = rel.subject_uuid\nWHERE rel.object_uuid = :uuid\n  AND rel.predicate = 'is_part_of'".replace("{{tableName}}", this.tableName).replace("{{tableAlias}}", this.tableAlias));
        FilterCriterion filterCriterion = predicate = filtering != null ? filtering.getFilterCriterionFor("predicate") : null;
        if (predicate != null) {
            String predicateFilter = String.format(" AND r.predicate = '%s'", predicate.getValue());
            innerQuery.append(predicateFilter);
        }
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", collectionUuid);
        List<CorporateBody> result = this.retrieveList(this.getSqlSelectReducedFields(), innerQuery, argumentMappings, null);
        return result;
    }

    public PageResponse<CorporateBody> findCollectionRelatedCorporateBodies(UUID collectionUuid, PageRequest pageRequest) {
        throw new UnsupportedOperationException();
    }
}

