/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.alias.UrlAliasRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.NamedEntity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class EntityRepositoryImpl<E extends Entity>
extends IdentifiableRepositoryImpl<E>
implements EntityRepository<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "e";
    public static final String TABLE_ALIAS = "e";
    public static final String TABLE_NAME = "entities";

    @Autowired
    public EntityRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig, IdentifierRepository identifierRepository, UrlAliasRepository urlAliasRepository) {
        this(dbi, TABLE_NAME, "e", "e", Entity.class, cudamiConfig.getOffsetForAlternativePaging(), identifierRepository, urlAliasRepository);
    }

    public EntityRepositoryImpl(Jdbi dbi, String tableName, String tableAlias, String mappingPrefix, Class<? extends Entity> entityImplClass, int offsetForAlternativePaging, IdentifierRepository identifierRepository, UrlAliasRepository urlAliasRepository) {
        super(dbi, tableName, tableAlias, mappingPrefix, entityImplClass, offsetForAlternativePaging, identifierRepository, urlAliasRepository);
    }

    @Override
    public void addRelatedFileresource(UUID entityUuid, UUID fileResourceUuid) throws RepositoryException {
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "rel_entity_fileresources", "entity_uuid", entityUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO rel_entity_fileresources(entity_uuid, fileresource_uuid, sortindex) VALUES (:entity_uuid, :fileresource_uuid, :sortindex)").bind("entity_uuid", entityUuid)).bind("fileresource_uuid", fileResourceUuid)).bind("sortindex", nextSortIndex)).execute());
    }

    @Override
    public PageResponse<Entity> findRelatedEntities(UUID entityUuid, PageRequest pageRequest) throws RepositoryException {
        StringBuilder commonSql = new StringBuilder(" FROM entities e INNER JOIN rel_entity_entities rel ON e.uuid=rel.object_uuid WHERE rel.subject_uuid = :entityUuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("entityUuid", entityUuid);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder query = new StringBuilder("SELECT rel.sortindex AS idx, *" + commonSql);
        pageRequest.setSorting(new Sorting(new Order[]{new Order(Direction.ASC, "idx")}));
        this.addPagingAndSorting(pageRequest, query);
        List list = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(Entity.class).list());
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        PageResponse pageResponse = new PageResponse(list, pageRequest, total);
        return pageResponse;
    }

    @Override
    public PageResponse<FileResource> findRelatedFileResources(UUID entityUuid, PageRequest pageRequest) throws RepositoryException {
        StringBuilder commonSql = new StringBuilder(" FROM FROM fileresources f INNER JOIN rel_entity_fileresources rel ON f.uuid=rel.fileresource_uuid WHERE rel.entitye_uuid = :entityUuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("entityUuid", entityUuid);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder query = new StringBuilder("SELECT rel.sortindex AS idx, *" + commonSql);
        pageRequest.setSorting(new Sorting(new Order[]{new Order(Direction.ASC, "idx")}));
        this.addPagingAndSorting(pageRequest, query);
        List list = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(FileResource.class).list());
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        PageResponse pageResponse = new PageResponse(list, pageRequest, total);
        return pageResponse;
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> allowedOrderByFields = super.getAllowedOrderByFields();
        allowedOrderByFields.addAll(Arrays.asList("refId"));
        return allowedOrderByFields;
    }

    public E getByRefId(long refId) throws RepositoryException {
        Filtering filtering = Filtering.builder().add(FilterCriterion.builder().withExpression("refId").isEquals((Object)refId).build()).build();
        return (E)((Entity)this.retrieveOne(this.getSqlSelectAllFields(), filtering, null));
    }

    @Override
    public String getColumnName(String modelProperty) {
        return switch (modelProperty) {
            case "navdate" -> this.tableAlias + ".navdate";
            case "refId" -> this.tableAlias + ".refid";
            case "name" -> {
                if (this.isRepoForNamedEntity()) {
                    yield "name";
                }
                yield null;
            }
            case "nameLocalesOfOriginalScripts" -> {
                if (this.isRepoForNamedEntity()) {
                    yield "name_locales_original_scripts";
                }
                yield null;
            }
            case "notes" -> this.tableAlias + ".notes";
            default -> super.getColumnName(modelProperty);
        };
    }

    @Override
    protected LinkedHashMap<String, Function<E, Optional<Object>>> getJsonbFields() {
        LinkedHashMap<String, Function<E, Optional<Object>>> jsonbFields = super.getJsonbFields();
        jsonbFields.put("name", i -> {
            Optional<Object> optional;
            if (i instanceof NamedEntity) {
                NamedEntity ne = (NamedEntity)i;
                optional = Optional.ofNullable(ne.getName());
            } else {
                optional = Optional.empty();
            }
            return optional;
        });
        return jsonbFields;
    }

    @Override
    public List<E> getRandom(int count) throws RepositoryException {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " ORDER BY RANDOM() LIMIT " + count);
        return this.retrieveList(this.getSqlSelectReducedFields(), innerQuery, null, null);
    }

    @Override
    protected List<String> getReturnedFieldsOnInsertUpdate() {
        List<String> fields = super.getReturnedFieldsOnInsertUpdate();
        fields.add("refid");
        return fields;
    }

    @Override
    public String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return this.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    @Override
    protected String getSqlInsertFields() {
        return super.getSqlInsertFields() + ", custom_attrs, navdate, notes" + (this.isRepoForNamedEntity() ? ", name, name_locales_original_scripts, split_name" : "");
    }

    @Override
    protected String getSqlInsertValues() {
        return super.getSqlInsertValues() + ", :customAttributes::JSONB, :navDate, :notes::JSONB" + (this.isRepoForNamedEntity() ? ", :name::JSONB, :nameLocalesOfOriginalScripts::varchar[], :split_name::varchar[]" : "");
    }

    @Override
    public String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".custom_attrs " + mappingPrefix + "_customAttributes, " + tableAlias + ".navdate " + mappingPrefix + "_navDate, " + tableAlias + ".refid " + mappingPrefix + "_refId, " + tableAlias + ".notes " + mappingPrefix + "_notes" + (this.isRepoForNamedEntity() ? String.format(", %1$s.name %2$s_name, %1$s.name_locales_original_scripts %2$s_nameLocalesOfOriginalScripts", tableAlias, mappingPrefix) : "");
    }

    @Override
    protected String getSqlUpdateFieldValues() {
        return super.getSqlUpdateFieldValues() + ", custom_attrs=:customAttributes::JSONB, navdate=:navDate, notes=:notes::JSONB" + (this.isRepoForNamedEntity() ? ", name=:name::JSONB, name_locales_original_scripts=:nameLocalesOfOriginalScripts::varchar[], split_name=:split_name::varchar[]" : "");
    }

    @Override
    protected boolean hasSplitColumn(String propertyName) {
        if (this.isRepoForNamedEntity() && "name".equals(propertyName)) {
            return true;
        }
        return super.hasSplitColumn(propertyName);
    }

    @Override
    protected void insertUpdateCallback(E identifiable, Map<String, Object> returnedFields) {
        super.insertUpdateCallback(identifiable, returnedFields);
        identifiable.setRefId(Long.parseLong(returnedFields.getOrDefault("refid", 0).toString()));
    }

    protected boolean isRepoForNamedEntity() {
        return NamedEntity.class.isAssignableFrom(this.uniqueObjectImplClass);
    }

    @Override
    public void save(E entity, Map<String, Object> bindings, BiFunction<String, Map<String, Object>, String> sqlModifier) throws RepositoryException {
        if (bindings == null) {
            bindings = new HashMap<String, Object>(0);
        }
        if (this.isRepoForNamedEntity()) {
            bindings.put("split_name", this.splitToArray(((NamedEntity)entity).getName()));
        }
        super.save(entity, bindings, sqlModifier);
    }

    @Override
    public List<FileResource> setRelatedFileResources(UUID entityUuid, List<FileResource> fileResources) throws RepositoryException {
        if (fileResources == null) {
            return null;
        }
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM rel_entity_fileresources WHERE entity_uuid = :uuid").bind("uuid", entityUuid)).execute());
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO rel_entity_fileresources(entity_uuid, fileresource_uuid, sortIndex) VALUES(:uuid, :fileResourceUuid, :sortIndex)");
            for (FileResource fileResource : fileResources) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", entityUuid)).bind("fileResourceUuid", fileResource.getUuid())).bind("sortIndex", this.getIndex(fileResources, (UniqueObject)fileResource))).add();
            }
            preparedBatch.execute();
        });
        return this.findRelatedFileResources(entityUuid, new PageRequest(0, fileResources.size())).getContent();
    }

    @Override
    public void update(E entity, Map<String, Object> bindings) throws RepositoryException {
        this.update(entity, bindings, (BiFunction<String, Map<String, Object>, String>)null);
    }

    @Override
    public void update(E entity, Map<String, Object> bindings, BiFunction<String, Map<String, Object>, String> sqlModifier) throws RepositoryException {
        if (bindings == null) {
            bindings = new HashMap<String, Object>(0);
        }
        if (this.isRepoForNamedEntity()) {
            bindings.put("split_name", this.splitToArray(((NamedEntity)entity).getName()));
        }
        super.update(entity, bindings, sqlModifier);
    }
}

