/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.alias;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.alias.UrlAliasRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.UniqueObjectRepositoryImpl;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.IdentifiableObjectType;
import de.digitalcollections.model.identifiable.IdentifiableType;
import de.digitalcollections.model.identifiable.alias.LocalizedUrlAliases;
import de.digitalcollections.model.identifiable.alias.UrlAlias;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Sorting;
import de.digitalcollections.model.text.LocalizedText;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.JdbiException;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.StatementException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class UrlAliasRepositoryImpl
extends UniqueObjectRepositoryImpl<UrlAlias>
implements UrlAliasRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlAliasRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "ua";
    public static final String TABLE_ALIAS = "ua";
    public static final String TABLE_NAME = "url_aliases";

    public static String sqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return UrlAliasRepositoryImpl.sqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String sqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return UniqueObjectRepositoryImpl.sqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".last_published " + mappingPrefix + "_lastPublished, " + tableAlias + ".primary " + mappingPrefix + "_primary, " + tableAlias + ".slug " + mappingPrefix + "_slug, " + tableAlias + ".target_language " + mappingPrefix + "_targetLanguage, " + tableAlias + ".target_identifiable_objecttype uaidf_identifiableObjectType, " + tableAlias + ".target_identifiable_type uaidf_identifiableType, " + tableAlias + ".target_uuid uaidf_uuid, uawebs.uuid uawebs_uuid, uawebs.label uawebs_label, uawebs.url uawebs_url";
    }

    public UrlAliasRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, "ua", "ua", UrlAlias.class, cudamiConfig.getOffsetForAlternativePaging());
        dbi.registerRowMapper(BeanMapper.factory(UrlAlias.class, (String)"ua"));
    }

    public UrlAlias create() throws RepositoryException {
        return new UrlAlias();
    }

    @Override
    protected BiConsumer<Map<UUID, UrlAlias>, RowView> createBasicReduceRowsBiConsumer() {
        return (map, rowView) -> {
            UrlAlias urlAlias = map.computeIfAbsent((UUID)rowView.getColumn(this.mappingPrefix + "_uuid", UUID.class), fn -> (UrlAlias)rowView.getRow(this.uniqueObjectImplClass));
            if (rowView.getColumn("uaidf_uuid", UUID.class) != null) {
                UUID targetUuid = (UUID)rowView.getColumn("uaidf_uuid", UUID.class);
                IdentifiableType targetIdentifiableType = (IdentifiableType)rowView.getColumn("uaidf_identifiableType", IdentifiableType.class);
                IdentifiableObjectType targetIdentifiableObjectType = (IdentifiableObjectType)rowView.getColumn("uaidf_identifiableObjectType", IdentifiableObjectType.class);
                Identifiable target = new Identifiable();
                target.setUuid(targetUuid);
                target.setType(targetIdentifiableType);
                target.setIdentifiableObjectType(targetIdentifiableObjectType);
                urlAlias.setTarget(target);
            }
            if (rowView.getColumn("uawebs_uuid", UUID.class) != null) {
                UUID websiteUuid = (UUID)rowView.getColumn("uawebs_uuid", UUID.class);
                LocalizedText websiteLabel = (LocalizedText)rowView.getColumn("uawebs_label", LocalizedText.class);
                Website website = new Website();
                website.setUuid(websiteUuid);
                website.setLabel(websiteLabel);
                urlAlias.setWebsite(website);
            }
        };
    }

    @Override
    protected BiConsumer<Map<UUID, UrlAlias>, RowView> createFullReduceRowsBiConcumer() {
        return this.createBasicReduceRowsBiConsumer();
    }

    public boolean deleteByIdentifiable(UUID identifiableUuid, boolean force) throws RepositoryException {
        LocalizedUrlAliases urlAliases = this.getByIdentifiable(identifiableUuid);
        return this.delete(urlAliases.flatten().stream().filter(ua -> force || ua.getLastPublished() == null).map(ua -> ((UrlAlias.UrlAliasBuilder)UrlAlias.builder().uuid(ua.getUuid())).build()).collect(Collectors.toSet())) > 0;
    }

    private UUID extractWebsiteUuid(UrlAlias urlAlias) {
        if (urlAlias == null) {
            return null;
        }
        return urlAlias.getWebsite() != null ? urlAlias.getWebsite().getUuid() : null;
    }

    public LocalizedUrlAliases findAllPrimaryLinks(String slug) throws RepositoryException {
        if (!StringUtils.hasText((String)slug)) {
            return new LocalizedUrlAliases();
        }
        return this.findPrimaryLinks(false, null, slug, false);
    }

    public PageResponse<LocalizedUrlAliases> findLocalizedUrlAliases(PageRequest pageRequest) throws RepositoryException {
        long count;
        StringBuilder commonSql = new StringBuilder(" FROM " + this.tableName + " AS " + this.tableAlias + this.getSqlSelectReducedFieldsJoins());
        FilterCriterion slug = StringUtils.hasText((String)pageRequest.getSearchTerm()) ? FilterCriterion.builder().withExpression("slug").contains((Object)pageRequest.getSearchTerm()).build() : null;
        Filtering filtering = pageRequest.getFiltering();
        if (filtering == null) {
            filtering = Filtering.builder().add(slug).build();
        } else {
            filtering.add(slug);
        }
        HashMap<String, Object> bindings = new HashMap<String, Object>(0);
        this.addFiltering(filtering, commonSql, bindings);
        try {
            count = (Long)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT count(*) " + commonSql.toString()).bindMap(bindings)).mapTo(Long.class).findOne().orElse(0L));
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new RepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new RepositoryException((Throwable)e);
        }
        if (!pageRequest.hasSorting()) {
            pageRequest.setSorting(new Sorting(new String[]{"slug"}));
        }
        commonSql.insert(0, String.format("SELECT %s ", this.getSqlSelectReducedFields()));
        this.addPagingAndSorting(pageRequest, commonSql);
        try {
            UrlAlias[] resultset = (UrlAlias[])this.dbi.withHandle(h -> (UrlAlias[])((Query)h.createQuery(commonSql.toString()).bindMap(bindings)).reduceRows(this.basicReduceRowsBiConsumer).toArray(UrlAlias[]::new));
            return new PageResponse(List.of(new LocalizedUrlAliases(resultset)), pageRequest, count);
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new RepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private LocalizedUrlAliases findPrimaryLinks(boolean useWebsite, UUID websiteUuid, String slug, boolean considerLanguage) throws RepositoryException {
        StringBuilder innerSel = new StringBuilder(String.format("(SELECT %2$s.target_uuid, %2$s.target_language FROM %1$s AS %2$s ", this.tableName, this.tableAlias));
        Filtering innerFiltering = Filtering.builder().add(FilterCriterion.builder().withExpression("slug").isEquals((Object)slug).build()).build();
        if (useWebsite) {
            innerFiltering.add(FilterCriterion.builder().withExpression("websiteUuid").isEquals((Object)websiteUuid).build());
        }
        HashMap<String, Object> bindings = new HashMap<String, Object>(0);
        this.addFiltering(innerFiltering, innerSel, bindings);
        innerSel.append(")");
        StringBuilder sql = new StringBuilder("WITH target (uuid, language) AS " + innerSel.toString() + " SELECT " + this.getSqlSelectReducedFields() + " FROM " + this.tableName + " AS " + this.tableAlias + this.getSqlSelectReducedFieldsJoins() + " WHERE " + this.tableAlias + ".target_uuid IN (SELECT uuid FROM target)");
        if (considerLanguage) {
            sql.append(" AND " + this.tableAlias + ".target_language IN (SELECT language FROM target)");
        }
        Filtering outerFiltering = Filtering.builder().add(FilterCriterion.builder().withExpression("primary").isEquals((Object)true).build()).build();
        if (useWebsite) {
            outerFiltering.add(FilterCriterion.builder().withExpression("websiteUuid").isEquals((Object)websiteUuid).build());
        }
        this.addFiltering(outerFiltering, sql, bindings);
        List list = this.execSelectForList(sql.toString(), bindings);
        return new LocalizedUrlAliases(list);
    }

    public LocalizedUrlAliases findPrimaryLinksForWebsite(UUID websiteUuid, String slug, boolean considerLanguage) throws RepositoryException {
        if (!StringUtils.hasText((String)slug)) {
            return new LocalizedUrlAliases();
        }
        return this.findPrimaryLinks(true, websiteUuid, slug, considerLanguage);
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> allowedOrderByFields = super.getAllowedOrderByFields();
        allowedOrderByFields.addAll(Arrays.asList("lastPublished", "\"primary\"", "slug", "targetLanguage"));
        return allowedOrderByFields;
    }

    public LocalizedUrlAliases getByIdentifiable(UUID uuid) throws RepositoryException {
        if (uuid == null) {
            return new LocalizedUrlAliases();
        }
        StringBuilder sql = new StringBuilder("SELECT " + this.getSqlSelectAllFields() + " FROM " + this.tableName + " AS " + this.tableAlias + this.getSqlSelectReducedFieldsJoins() + " WHERE " + this.tableAlias + ".target_uuid = :targetUuid");
        HashMap<String, UUID> bindings = new HashMap<String, UUID>();
        bindings.put("targetUuid", uuid);
        try {
            UrlAlias[] resultset = (UrlAlias[])this.dbi.withHandle(h -> (UrlAlias[])((Query)h.createQuery(sql.toString()).bindMap(bindings)).reduceRows(this.basicReduceRowsBiConsumer).toArray(UrlAlias[]::new));
            return new LocalizedUrlAliases(resultset);
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new RepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "lastPublished": {
                return this.tableAlias + ".last_published";
            }
            case "primary": {
                return this.tableAlias + ".primary";
            }
            case "slug": {
                return this.tableAlias + ".slug";
            }
            case "targetLanguage": {
                return this.tableAlias + ".target_language";
            }
            case "websiteUuid": {
                return this.tableAlias + ".website_uuid";
            }
        }
        return super.getColumnName(modelProperty);
    }

    public List<UrlAlias> getRandom(int count) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    private Map<String, Object> getSpecialBindings(UrlAlias urlAlias) {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("targetIdentifiableObjectType", urlAlias.getTarget().getIdentifiableObjectType());
        bindings.put("targetIdentifiableType", urlAlias.getTarget().getType());
        bindings.put("targetUuid", urlAlias.getTarget().getUuid());
        bindings.put("websiteUuid", this.extractWebsiteUuid(urlAlias));
        bindings.put("targetLanguage", UrlAliasRepository.grabLanguage((Locale)urlAlias.getTargetLanguage()));
        return bindings;
    }

    @Override
    protected String getSqlInsertFields() {
        return super.getSqlInsertFields() + ", last_published, \"primary\", slug, target_identifiable_objecttype, target_identifiable_type, target_language, target_uuid, website_uuid";
    }

    @Override
    protected String getSqlInsertValues() {
        return super.getSqlInsertValues() + ", :lastPublished, :primary, :slug, :targetIdentifiableObjectType, :targetIdentifiableType, :targetLanguage, :targetUuid, :websiteUuid";
    }

    @Override
    public String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return UrlAliasRepositoryImpl.sqlSelectAllFields(tableAlias, mappingPrefix);
    }

    @Override
    public String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return UrlAliasRepositoryImpl.sqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    @Override
    public String getSqlSelectReducedFieldsJoins() {
        return super.getSqlSelectReducedFieldsJoins() + " LEFT JOIN websites AS uawebs ON uawebs.uuid = " + this.tableAlias + ".website_uuid";
    }

    @Override
    public String getSqlUpdateFieldValues() {
        return super.getSqlUpdateFieldValues() + ", last_published=:lastPublished, \"primary\"=:primary, slug=:slug, target_identifiable_objecttype=:targetIdentifiableObjectType, target_identifiable_type=:targetIdentifiableType, target_language=:targetLanguage, target_uuid=:targetUuid, website_uuid=:websiteUuid";
    }

    public boolean hasUrlAlias(String slug, UUID websiteUuid, Locale targetLanguage) throws RepositoryException {
        if (!StringUtils.hasText((String)slug)) {
            throw new RepositoryException("UrlAliasRepository.hasUrlAlias: Parameter 'slug' must not be null or empty.");
        }
        StringBuilder sql = new StringBuilder("SELECT uuid FROM " + this.tableName + " AS " + this.tableAlias);
        Filtering filtering = Filtering.builder().add(FilterCriterion.builder().withExpression("websiteUuid").isEquals((Object)websiteUuid).build()).build();
        filtering.add(FilterCriterion.builder().withExpression("targetLanguage").isEquals((Object)UrlAliasRepository.grabLanguage((Locale)targetLanguage)).build());
        filtering.add(FilterCriterion.builder().withExpression("slug").isEquals((Object)slug).build());
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        this.addFiltering(filtering, sql, bindings);
        try {
            return 0 < (Integer)this.dbi.withHandle(h -> (Integer)((Query)h.createQuery(sql.toString()).bindMap(bindings)).reduceRows((Object)0, (count, row) -> {
                count = count + 1;
                return count;
            }));
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new RepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void save(UrlAlias urlAlias) throws RepositoryException {
        Map<String, Object> bindings = this.getSpecialBindings(urlAlias);
        super.save(urlAlias, bindings);
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        return false;
    }

    public void update(UrlAlias urlAlias) throws RepositoryException {
        Map<String, Object> bindings = this.getSpecialBindings(urlAlias);
        super.update(urlAlias, bindings);
    }
}

