/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.UniqueObjectRepositoryImpl;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.springframework.stereotype.Repository;

@Repository
public class IdentifierRepositoryImpl
extends UniqueObjectRepositoryImpl<Identifier>
implements IdentifierRepository {
    public static final String MAPPING_PREFIX = "id";
    public static final String TABLE_ALIAS = "id";
    public static final String TABLE_NAME = "identifiers";

    public static String sqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return IdentifierRepositoryImpl.sqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String sqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return UniqueObjectRepositoryImpl.sqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".identifiable " + mappingPrefix + "_identifiable, " + tableAlias + ".namespace " + mappingPrefix + "_namespace, " + tableAlias + ".identifier " + mappingPrefix + "_id";
    }

    public IdentifierRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, "id", "id", Identifier.class, cudamiConfig.getOffsetForAlternativePaging());
        dbi.registerRowMapper(BeanMapper.factory(Identifier.class, (String)"id"));
    }

    public Identifier create() throws RepositoryException {
        return new Identifier();
    }

    public int deleteByIdentifiable(UUID identifiableUuid) throws RepositoryException {
        String sql = "DELETE FROM " + this.tableName + " WHERE identifiable = :uuid";
        HashMap<String, Object> bindings = new HashMap<String, Object>(0);
        bindings.put("uuid", identifiableUuid);
        return this.execUpdateWithMap(sql, bindings);
    }

    public List<Identifier> findByIdentifiable(UUID uuidIdentifiable) throws RepositoryException {
        String sql = "SELECT " + this.getSqlSelectReducedFields() + " FROM " + this.tableName + " " + this.tableAlias + " WHERE identifiable = :uuid";
        return this.execSelectForList(sql, Map.of("uuid", uuidIdentifiable));
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> allowedOrderByFields = super.getAllowedOrderByFields();
        allowedOrderByFields.addAll(Arrays.asList("id", "identifiable", "namespace"));
        return allowedOrderByFields;
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "id": {
                return this.tableAlias + ".identifier";
            }
            case "identifiable": {
                return this.tableAlias + ".identifiable";
            }
            case "namespace": {
                return this.tableAlias + ".namespace";
            }
        }
        return super.getColumnName(modelProperty);
    }

    public List<Identifier> getRandom(int count) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getSqlInsertFields() {
        return super.getSqlInsertFields() + ", identifiable, namespace, identifier";
    }

    @Override
    protected String getSqlInsertValues() {
        return super.getSqlInsertValues() + ", :identifiable, :namespace, :id";
    }

    @Override
    public String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return IdentifierRepositoryImpl.sqlSelectAllFields(tableAlias, mappingPrefix);
    }

    @Override
    public String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return IdentifierRepositoryImpl.sqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    @Override
    protected String getSqlUpdateFieldValues() {
        return super.getSqlUpdateFieldValues() + ", identifiable=:identifiable, namespace=:namespace, identifier=:id";
    }

    public Set<Identifier> saveForIdentifiable(Identifiable identifiable, Set<Identifier> identifiers) throws RepositoryException {
        if (identifiers == null) {
            return new HashSet<Identifier>(0);
        }
        HashSet<Identifier> savedIdentifiers = new HashSet<Identifier>(identifiers.size());
        for (Identifier identifier : identifiers) {
            if (identifier.getUuid() == null) {
                HashMap<String, Object> bindings = new HashMap<String, Object>();
                bindings.put("identifiable", identifiable.getUuid());
                this.save(identifier, bindings);
                savedIdentifiers.add(identifier);
                continue;
            }
            Identifier dbIdentifier = (Identifier)this.getByUuid(identifier.getUuid());
            savedIdentifiers.add(dbIdentifier);
        }
        return savedIdentifiers;
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        return false;
    }
}

