/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi;

import de.digitalcollections.cudami.server.backend.api.repository.UniqueObjectRepository;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.JdbiException;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.StatementException;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class UniqueObjectRepositoryImpl<U extends UniqueObject>
extends JdbiRepositoryImpl<U>
implements UniqueObjectRepository<U> {
    private static final Logger LOGGER = LoggerFactory.getLogger(UniqueObjectRepositoryImpl.class);
    protected final BiConsumer<Map<UUID, U>, RowView> additionalReduceRowsBiConsumer;
    protected final BiConsumer<Map<UUID, U>, RowView> basicReduceRowsBiConsumer;
    protected final BiConsumer<Map<UUID, U>, RowView> fullReduceRowsBiConsumer;
    protected final Class<? extends UniqueObject> uniqueObjectImplClass;

    public static String sqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return " " + "{{alias}}.uuid {{prefix}}_uuid, {{alias}}.created {{prefix}}_created, {{alias}}.last_modified {{prefix}}_lastModified".replace("{{alias}}", tableAlias).replace("{{prefix}}", mappingPrefix);
    }

    protected UniqueObjectRepositoryImpl() {
        this.additionalReduceRowsBiConsumer = null;
        this.basicReduceRowsBiConsumer = null;
        this.fullReduceRowsBiConsumer = null;
        this.uniqueObjectImplClass = null;
    }

    protected UniqueObjectRepositoryImpl(Jdbi dbi, String tableName, String tableAlias, String mappingPrefix, Class<? extends UniqueObject> uniqueObjectImplClass, int offsetForAlternativePaging) {
        super(dbi, tableName, tableAlias, mappingPrefix, offsetForAlternativePaging);
        this.dbi.registerRowMapper(BeanMapper.factory(uniqueObjectImplClass, (String)mappingPrefix));
        this.uniqueObjectImplClass = uniqueObjectImplClass;
        this.additionalReduceRowsBiConsumer = this.createAdditionalReduceRowsBiConsumer();
        this.basicReduceRowsBiConsumer = this.createBasicReduceRowsBiConsumer();
        this.fullReduceRowsBiConsumer = this.createFullReduceRowsBiConcumer();
    }

    protected BiConsumer<Map<UUID, U>, RowView> createAdditionalReduceRowsBiConsumer() {
        return (map, rowView) -> {};
    }

    protected BiConsumer<Map<UUID, U>, RowView> createBasicReduceRowsBiConsumer() {
        return (map, rowView) -> {
            UniqueObject uniqueObject = map.computeIfAbsent((UUID)rowView.getColumn(this.mappingPrefix + "_uuid", UUID.class), fn -> (UniqueObject)rowView.getRow(this.uniqueObjectImplClass));
        };
    }

    protected BiConsumer<Map<UUID, U>, RowView> createFullReduceRowsBiConcumer() {
        return (map, rowView) -> {
            UniqueObject uniqueObject = map.computeIfAbsent((UUID)rowView.getColumn(this.mappingPrefix + "_uuid", UUID.class), fn -> (UniqueObject)rowView.getRow(this.uniqueObjectImplClass));
        };
    }

    public boolean deleteByUuid(UUID uuid) throws RepositoryException {
        return this.deleteByUuids(List.of(uuid)) > 0;
    }

    public int deleteByUuids(List<UUID> uuids) throws RepositoryException {
        String sql = "DELETE FROM " + this.tableName + " WHERE uuid in (<uuids>)";
        return this.execUpdateWithList(sql, "uuids", uuids);
    }

    private void execInsertUpdate(String sql, U uniqueObject, Map<String, Object> bindings, boolean withCallback) throws RepositoryException {
        try {
            if (withCallback) {
                Map returnedFields = (Map)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery(sql).bindMap(bindings)).bindBean(uniqueObject)).mapToMap().findOne().orElse(Collections.emptyMap()));
                this.insertUpdateCallback(uniqueObject, returnedFields);
            } else {
                int affected = (Integer)this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(sql).bindMap(bindings)).bindBean(uniqueObject)).execute());
                if (affected != 1) {
                    throw new RepositoryException("Insert into table " + this.getTableName() + " failed for %s".formatted(uniqueObject));
                }
            }
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new RepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected List<U> execSelectForList(String sql, Map<String, Object> bindings) throws RepositoryException {
        try {
            if (bindings == null && this.basicReduceRowsBiConsumer == null) {
                return (List)this.dbi.withHandle(handle -> handle.createQuery(sql).mapToBean(this.uniqueObjectImplClass).list());
            }
            if (bindings == null && this.basicReduceRowsBiConsumer != null) {
                return (List)this.dbi.withHandle(handle -> handle.createQuery(sql).reduceRows(this.basicReduceRowsBiConsumer).collect(Collectors.toList()));
            }
            if (bindings != null && this.basicReduceRowsBiConsumer == null) {
                return (List)this.dbi.withHandle(handle -> ((Query)handle.createQuery(sql).bindMap(bindings)).mapToBean(this.uniqueObjectImplClass).list());
            }
            return (List)this.dbi.withHandle(handle -> ((Query)handle.createQuery(sql).bindMap(bindings)).reduceRows(this.basicReduceRowsBiConsumer).collect(Collectors.toList()));
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new RepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected UUID[] extractUuids(Collection<? extends UniqueObject> uniqueObjects) {
        if (uniqueObjects == null || uniqueObjects.isEmpty()) {
            return new UUID[0];
        }
        return uniqueObjects.stream().collect(ArrayList::new, (result, uniqueObject) -> result.add(uniqueObject.getUuid()), ArrayList::addAll).toArray(new UUID[1]);
    }

    public PageResponse<U> find(PageRequest pageRequest) throws RepositoryException {
        return this.find(pageRequest, (Map<String, Object>)null);
    }

    protected PageResponse<U> find(PageRequest pageRequest, Map<String, Object> argumentMappings) throws RepositoryException {
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias;
        return this.find(pageRequest, commonSql, argumentMappings);
    }

    protected PageResponse<U> find(PageRequest pageRequest, String commonSql) throws RepositoryException {
        return this.find(pageRequest, commonSql, null);
    }

    protected PageResponse<U> find(PageRequest pageRequest, String commonSql, Map<String, Object> argumentMappings) throws RepositoryException {
        if (argumentMappings == null) {
            argumentMappings = new HashMap<String, Object>(0);
        }
        StringBuilder commonSqlBuilder = new StringBuilder(commonSql);
        this.addFiltering(pageRequest, commonSqlBuilder, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT " + this.tableAlias + ".* " + commonSqlBuilder);
        this.addPagingAndSorting(pageRequest, innerQuery);
        List<U> result = this.retrieveList(this.getSqlSelectReducedFields(), innerQuery, argumentMappings, this.getOrderBy(pageRequest.getSorting()));
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSqlBuilder);
        long total = this.retrieveCount(countQuery, argumentMappings);
        PageResponse pageResponse = new PageResponse(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return new ArrayList<String>(Arrays.asList("created", "lastModified"));
    }

    public U getByUuidAndFiltering(UUID uuid, Filtering filtering) throws RepositoryException {
        if (filtering == null) {
            filtering = new Filtering();
        }
        filtering.add(FilterCriterion.builder().withExpression("uuid").isEquals((Object)uuid).build());
        U result = this.retrieveOne(this.getSqlSelectAllFields(), filtering, null);
        return result;
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return this.tableAlias + ".created";
            }
            case "lastModified": {
                return this.tableAlias + ".last_modified";
            }
            case "uuid": {
                return this.tableAlias + ".uuid";
            }
        }
        return null;
    }

    public int getIndex(List<? extends UniqueObject> list, UniqueObject uniqueObject) {
        int pos = -1;
        for (UniqueObject uniqueObject2 : list) {
            ++pos;
            if (!uniqueObject2.getUuid().equals(uniqueObject.getUuid())) continue;
            return pos;
        }
        return -1;
    }

    public int getIndex(List<UUID> list, UUID uuid) {
        int pos = -1;
        for (UUID u : list) {
            ++pos;
            if (!u.equals(uuid)) continue;
            return pos;
        }
        return -1;
    }

    protected List<String> getReturnedFieldsOnInsertUpdate() {
        return new ArrayList<String>(0);
    }

    protected String getSqlInsertFields() {
        return "uuid, created, last_modified";
    }

    protected String getSqlInsertValues() {
        return ":uuid, :created, :lastModified";
    }

    public String getSqlSelectAllFields() {
        return this.getSqlSelectAllFields(this.tableAlias, this.mappingPrefix);
    }

    public String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return this.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    protected String getSqlSelectAllFieldsJoins() {
        return "";
    }

    public String getSqlSelectReducedFields() {
        return this.getSqlSelectReducedFields(this.tableAlias, this.mappingPrefix);
    }

    public String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return UniqueObjectRepositoryImpl.sqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    protected String getSqlSelectReducedFieldsJoins() {
        return "";
    }

    protected String getSqlUpdateFieldValues() {
        return " last_modified=:lastModified";
    }

    @Override
    protected String getUniqueField() {
        return "uuid";
    }

    protected void insertUpdateCallback(U uniqueObject, Map<String, Object> returnedFields) {
    }

    @Override
    public long retrieveCount(StringBuilder sqlCount, Map<String, Object> argumentMappings) throws RepositoryException {
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(sqlCount.toString()).bindMap(argumentMappings)).mapTo(Long.class).findOne().get());
        return total;
    }

    protected List<U> retrieveList(String fieldsSql, String fieldsSqlAdditionalJoins, StringBuilder innerQuery, Map<String, Object> argumentMappings, String orderBy) throws RepositoryException {
        String sql = "SELECT " + fieldsSql + " FROM " + (String)(innerQuery != null ? "(" + innerQuery + ")" : this.tableName) + " AS " + this.tableAlias + (StringUtils.hasText((String)fieldsSqlAdditionalJoins) ? " %s".formatted(fieldsSqlAdditionalJoins) : "") + (StringUtils.hasText((String)this.getSqlSelectReducedFieldsJoins()) ? " %s ".formatted(this.getSqlSelectReducedFieldsJoins()) : "") + (String)(orderBy != null && orderBy.matches("(?iu)^\\s*order by.+") ? " " + orderBy : (StringUtils.hasText((String)orderBy) ? " ORDER BY " + orderBy : ""));
        List<U> result = this.execSelectForList(sql, argumentMappings);
        return result;
    }

    public List<U> retrieveList(String fieldsSql, StringBuilder innerQuery, Map<String, Object> argumentMappings, String orderBy) throws RepositoryException {
        return this.retrieveList(fieldsSql, null, innerQuery, argumentMappings, orderBy);
    }

    protected U retrieveOne(String fieldsSql, Filtering filtering, String sqlAdditionalJoins) throws RepositoryException {
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        return this.retrieveOne(fieldsSql, filtering, sqlAdditionalJoins, argumentMappings);
    }

    protected U retrieveOne(String fieldsSql, Filtering filtering, String sqlAdditionalJoins, Map<String, Object> argumentMappings) throws RepositoryException {
        return this.retrieveOne(fieldsSql, filtering, sqlAdditionalJoins, argumentMappings, null);
    }

    protected U retrieveOne(String fieldsSql, Filtering filtering, String sqlAdditionalJoins, Map<String, Object> argumentMappings, String innerSelect) throws RepositoryException {
        StringBuilder sql = new StringBuilder("SELECT" + fieldsSql + " FROM " + (StringUtils.hasText((String)innerSelect) ? "(%s)".formatted(innerSelect) : this.tableName) + " AS " + this.tableAlias + (StringUtils.hasText((String)sqlAdditionalJoins) ? " %s".formatted(sqlAdditionalJoins) : "") + (StringUtils.hasText((String)this.getSqlSelectAllFieldsJoins()) ? " %s".formatted(this.getSqlSelectAllFieldsJoins()) : "") + (StringUtils.hasText((String)this.getSqlSelectReducedFieldsJoins()) ? " %s".formatted(this.getSqlSelectReducedFieldsJoins()) : ""));
        if (argumentMappings == null) {
            argumentMappings = new HashMap<String, Object>(0);
        }
        this.addFiltering(filtering, sql, argumentMappings);
        Map<String, Object> bindMap = Map.copyOf(argumentMappings);
        try {
            UniqueObject result = ((Stream)this.dbi.withHandle(h -> ((Query)h.createQuery(sql.toString()).bindMap(bindMap)).reduceRows((map, rowView) -> {
                this.fullReduceRowsBiConsumer.accept((Map<UUID, RowView>)map, (RowView)rowView);
                this.additionalReduceRowsBiConsumer.accept((Map<UUID, RowView>)map, (RowView)rowView);
            }))).findFirst().orElse(null);
            return (U)result;
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new RepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void save(U uniqueObject, Map<String, Object> bindings) throws RepositoryException {
        this.save(uniqueObject, bindings, null);
    }

    public void save(U uniqueObject, Map<String, Object> bindings, BiFunction<String, Map<String, Object>, String> sqlModifier) throws RepositoryException {
        if (uniqueObject == null) {
            throw new IllegalArgumentException("Given object must not be null");
        }
        if (bindings == null) {
            bindings = new HashMap<String, Object>(0);
        }
        if (uniqueObject.getUuid() == null) {
            uniqueObject.setUuid(UUID.randomUUID());
        }
        LocalDateTime now = LocalDateTime.now();
        if (uniqueObject.getCreated() == null) {
            uniqueObject.setCreated(now);
        }
        if (uniqueObject.getLastModified() == null) {
            uniqueObject.setLastModified(now);
        }
        boolean hasReturningStmt = !this.getReturnedFieldsOnInsertUpdate().isEmpty();
        Object sql = "INSERT INTO " + this.tableName + "(" + this.getSqlInsertFields() + ") VALUES (" + this.getSqlInsertValues() + ")" + (String)(hasReturningStmt ? " RETURNING " + String.join((CharSequence)", ", this.getReturnedFieldsOnInsertUpdate()) : "");
        if (sqlModifier != null) {
            sql = sqlModifier.apply((String)sql, bindings);
        }
        this.execInsertUpdate((String)sql, uniqueObject, bindings, hasReturningStmt);
    }

    public void update(U uniqueObject, Map<String, Object> bindings) throws RepositoryException {
        this.update(uniqueObject, bindings, null);
    }

    public void update(U uniqueObject, Map<String, Object> bindings, BiFunction<String, Map<String, Object>, String> sqlModifier) throws RepositoryException {
        if (uniqueObject == null) {
            throw new IllegalArgumentException("Given object must not be null");
        }
        if (bindings == null) {
            bindings = new HashMap<String, Object>(0);
        }
        uniqueObject.setLastModified(LocalDateTime.now());
        boolean hasReturningStmt = !this.getReturnedFieldsOnInsertUpdate().isEmpty();
        Object sql = "UPDATE " + this.tableName + " SET" + this.getSqlUpdateFieldValues() + " WHERE uuid=:uuid" + (String)(hasReturningStmt ? " RETURNING " + String.join((CharSequence)", ", this.getReturnedFieldsOnInsertUpdate()) : "");
        if (sqlModifier != null) {
            sql = sqlModifier.apply((String)sql, bindings);
        }
        this.execInsertUpdate((String)sql, uniqueObject, bindings, hasReturningStmt);
    }
}

