/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.database.migration;

import com.github.openjson.JSONObject;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class V1_4_2__DML_Change_locales_to_languages
extends BaseJavaMigration {
    public void migrate(Context context) throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(new SingleConnectionDataSource(context.getConnection(), true).getConnection());
        this.migrateJson(jdbcTemplate, "description", "identifiables");
        this.migrateJson(jdbcTemplate, "label", "identifiables");
        this.migrateJson(jdbcTemplate, "text", "articles");
        this.migrateJson(jdbcTemplate, "text", "webpages");
    }

    private String convertJson(String currentJson) {
        JSONObject json = new JSONObject(currentJson);
        JSONObject result = new JSONObject();
        json.keySet().forEach(locale -> {
            if (locale.contains("_")) {
                result.put(locale.substring(0, locale.indexOf("_")), json.get(locale));
            } else {
                result.put(locale, json.get(locale));
            }
        });
        return result.toString();
    }

    private void migrateJson(JdbcTemplate jdbcTemplate, String tableField, String tableName) throws SQLException {
        String selectQuery = String.format("SELECT uuid,%s FROM %s", tableField, tableName);
        String updateQuery = String.format("UPDATE %s SET %s=?::JSONB WHERE uuid=?::uuid", tableName, tableField);
        List identifiables = jdbcTemplate.queryForList(selectQuery, new Object[0]);
        for (Map identifiable : identifiables) {
            String currentJson = (String)identifiable.get(tableField);
            if (currentJson == null) continue;
            jdbcTemplate.update(updateQuery, new Object[]{this.convertJson(currentJson), identifiable.get("uuid")});
        }
    }
}

