/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.database.migration;

import com.github.openjson.JSONObject;
import de.digitalcollections.model.identifiable.IdentifiableObjectType;
import java.util.List;
import java.util.UUID;
import javax.sql.DataSource;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class V11_05_00__DDL_DML_UrlAlias_replace_targetEntityType_with_targetIdentifiableObjectType
extends BaseJavaMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(V11_05_00__DDL_DML_UrlAlias_replace_targetEntityType_with_targetIdentifiableObjectType.class);
    private JdbcTemplate jdbcTemplate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void migrate(Context context) throws Exception {
        SingleConnectionDataSource connectionDataSource = new SingleConnectionDataSource(context.getConnection(), true);
        this.jdbcTemplate = new JdbcTemplate((DataSource)connectionDataSource);
        String selectQuery = "SELECT identifiables.uuid AS target_uuid, identifiable_objecttype FROM identifiables INNER JOIN (SELECT DISTINCT target_uuid FROM url_aliases) url_aliases ON identifiables.uuid=url_aliases.target_uuid";
        List targetData = this.jdbcTemplate.queryForList(selectQuery);
        if (targetData.isEmpty()) {
            LOGGER.info("No migration necessary.");
            return;
        }
        LOGGER.info("Migrating UrlAliases for {} identifiables", (Object)targetData.size());
        try {
            this.jdbcTemplate.execute("ALTER TABLE url_aliases DISABLE TRIGGER tr_url_aliases_target_uuid");
            targetData.forEach(i -> {
                JSONObject jsonObject = new JSONObject(i.toString());
                UUID targetUuid = UUID.fromString(jsonObject.getString("target_uuid"));
                IdentifiableObjectType targetIdentifiableObjectType = IdentifiableObjectType.valueOf((String)jsonObject.getString("identifiable_objecttype"));
                this.jdbcTemplate.update("UPDATE url_aliases SET target_identifiable_objecttype = ? WHERE target_uuid = ?", new Object[]{targetIdentifiableObjectType.toString(), targetUuid});
            });
            LOGGER.info("Migration done");
        }
        finally {
            this.jdbcTemplate.execute("ALTER TABLE url_aliases ENABLE TRIGGER tr_url_aliases_target_uuid");
        }
    }
}

