/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.semantic;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.semantic.HeadwordRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.SearchTermTemplates;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import de.digitalcollections.model.semantic.Headword;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HeadwordRepositoryImpl
extends JdbiRepositoryImpl
implements HeadwordRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeadwordRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "hw";
    public static final String SQL_INSERT_FIELDS = " uuid, created, label, locale, last_modified";
    public static final String SQL_INSERT_VALUES = " :uuid, :created, :label, :locale, :lastModified";
    public static final String SQL_REDUCED_FIELDS_HW = " hw.uuid, hw.label, hw.locale, hw.created, hw.last_modified";
    public static final String SQL_FULL_FIELDS_HW = " hw.uuid, hw.label, hw.locale, hw.created, hw.last_modified";
    public static final String TABLE_ALIAS = "hw";
    public static final String TABLE_NAME = "headwords";

    @Autowired
    public HeadwordRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, "hw", "hw", cudamiConfig.getOffsetForAlternativePaging());
    }

    public void addRelatedEntity(UUID headwordUuid, UUID entityUuid) {
        Integer sortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "headword_entities", "headword_uuid", headwordUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO headword_entities(headword_uuid, entity_uuid, sortindex) VALUES (:headwordUuid, :entityUuid, :sortindex)").bind("headwordUuid", headwordUuid)).bind("entityUuid", entityUuid)).bind("sortindex", sortIndex)).execute());
    }

    public void addRelatedFileresource(UUID headwordUuid, UUID fileResourceUuid) {
        Integer sortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "headword_fileresources", "headword_uuid", headwordUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO headword_fileresources(headword_uuid, fileresource_uuid, sortindex) VALUES (:headwordUuid, :fileresourceUuid, :sortindex)").bind("headwordUuid", headwordUuid)).bind("fileresourceUuid", fileResourceUuid)).bind("sortindex", sortIndex)).execute());
    }

    public void delete(String label, Locale locale) {
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE label = :label AND locale = :locale").bind("label", label)).bind("locale", (Object)locale)).execute());
    }

    public void delete(UUID uuid) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE uuid = :uuid").bind("uuid", uuid)).execute());
    }

    public boolean delete(List<UUID> uuids) {
        uuids.stream().forEach(u -> {
            this.deleteRelatedEntities((UUID)u);
            this.deleteRelatedFileresources((UUID)u);
        });
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE uuid in (<uuids>)").bindList("uuids", (Iterable)uuids)).execute());
        return true;
    }

    public void deleteRelatedEntities(UUID headwordUuid) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM headword_entities WHERE headword_uuid = :uuid").bind("uuid", headwordUuid)).execute());
    }

    public void deleteRelatedFileresources(UUID headwordUuid) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM headword_fileresources WHERE headword_uuid = :uuid").bind("uuid", headwordUuid)).execute());
    }

    public PageResponse<Headword> find(PageRequest pageRequest) {
        StringBuilder commonSql = new StringBuilder(" FROM " + this.tableName + " AS " + this.tableAlias);
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        String executedSearchTerm = this.addSearchTerm(pageRequest, commonSql, argumentMappings);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT " + this.tableAlias + ".* " + commonSql);
        this.addPageRequestParams(pageRequest, innerQuery);
        List<Headword> result = this.retrieveList(" hw.uuid, hw.label, hw.locale, hw.created, hw.last_modified", innerQuery, argumentMappings, this.getOrderBy(pageRequest.getSorting()));
        StringBuilder countQuery = new StringBuilder("SELECT count(" + this.tableAlias + ".uuid)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total, executedSearchTerm);
    }

    public List<Headword> find(String label, Locale locale) {
        Filtering filtering = Filtering.builder().add(FilterCriterion.builder().withExpression("label").isEquals((Object)label).build()).add(FilterCriterion.builder().withExpression("locale").isEquals((Object)locale).build()).build();
        PageRequest request = new PageRequest(0, 10000, Sorting.builder().order(new Order(Direction.ASC, "label")).build(), filtering);
        PageResponse<Headword> response = this.find(request);
        return response.getContent();
    }

    public List<Headword> findByLabel(String label) {
        Filtering filtering = Filtering.builder().add(FilterCriterion.builder().withExpression("label").isEquals((Object)label).build()).build();
        PageRequest request = new PageRequest(0, 10000, Sorting.builder().order(new Order(Direction.ASC, "label")).build(), filtering);
        PageResponse<Headword> response = this.find(request);
        return response.getContent();
    }

    public Headword findByLabelAndLocale(String label, Locale locale) {
        StringBuilder sqlQuery = new StringBuilder("SELECT  hw.uuid, hw.label, hw.locale, hw.created, hw.last_modified FROM " + this.tableName + " AS " + this.tableAlias);
        Filtering filtering = Filtering.builder().add(FilterCriterion.builder().withExpression("label").isEquals((Object)label).build()).add(FilterCriterion.builder().withExpression("locale").isEquals((Object)locale).build()).build();
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        this.addFiltering(filtering, sqlQuery, argumentMappings);
        Map<String, Object> bindMap = Map.copyOf(argumentMappings);
        Optional result = (Optional)this.dbi.withHandle(h -> ((Query)h.createQuery(sqlQuery.toString()).bindMap(bindMap)).mapToBean(Headword.class).findFirst());
        return result.orElse(null);
    }

    public PageResponse<Headword> findByLanguageAndInitial(PageRequest pageRequest, String language, String initial) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Headword findByUuidAndFiltering(UUID uuid, Filtering filtering) {
        StringBuilder sqlQuery = new StringBuilder("SELECT  hw.uuid, hw.label, hw.locale, hw.created, hw.last_modified FROM " + this.tableName + " AS " + this.tableAlias);
        if (filtering == null) {
            filtering = Filtering.builder().build();
        }
        filtering.add(FilterCriterion.builder().withExpression("uuid").isEquals((Object)uuid).build());
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        this.addFiltering(filtering, sqlQuery, argumentMappings);
        Map<String, Object> bindMap = Map.copyOf(argumentMappings);
        Optional result = (Optional)this.dbi.withHandle(h -> ((Query)h.createQuery(sqlQuery.toString()).bindMap(bindMap)).mapToBean(Headword.class).findFirst());
        return result.orElse(null);
    }

    public PageResponse<Entity> findRelatedEntities(UUID headwordUuid, PageRequest pageRequest) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PageResponse<FileResource> findRelatedFileResources(UUID headwordUuid, PageRequest pageRequest) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<Headword> getAll() {
        return this.retrieveList(" hw.uuid, hw.label, hw.locale, hw.created, hw.last_modified", null, null);
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return new ArrayList<String>(Arrays.asList("created", "label", "lastModified"));
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return this.tableAlias + ".created";
            }
            case "label": {
                return this.tableAlias + ".label";
            }
            case "lastModified": {
                return this.tableAlias + ".last_modified";
            }
            case "locale": {
                return this.tableAlias + ".locale";
            }
            case "uuid": {
                return this.tableAlias + ".uuid";
            }
        }
        return null;
    }

    public List<Locale> getLanguages() {
        String query = "SELECT DISTINCT locale FROM " + this.tableName;
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query).mapTo(Locale.class).list());
        return result;
    }

    public List<Headword> getRandom(int count) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<Entity> getRelatedEntities(UUID headwordUuid) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<FileResource> getRelatedFileResources(UUID headwordUuid) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected List<String> getSearchTermTemplates(String tableAlias, String originalSearchTerm) {
        return List.of(SearchTermTemplates.ILIKE_STARTS_WITH.renderTemplate(tableAlias, "label"));
    }

    @Override
    protected String getUniqueField() {
        return "uuid";
    }

    public long retrieveCount(StringBuilder sqlCount, Map<String, Object> argumentMappings) {
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(sqlCount.toString()).bindMap(argumentMappings)).mapTo(Long.class).findOne().get());
        return total;
    }

    public List<Headword> retrieveList(String fieldsSql, StringBuilder innerQuery, String orderBy) {
        String sql = "SELECT " + fieldsSql + " FROM " + (String)(innerQuery != null ? "(" + innerQuery + ")" : this.tableName) + " AS " + this.tableAlias + (String)(orderBy != null ? " " + orderBy : "");
        List result = (List)this.dbi.withHandle(handle -> (List)handle.createQuery(sql).mapToBean(Headword.class).collect(Collectors.toList()));
        return result;
    }

    private List<Headword> retrieveList(String fieldsSql, StringBuilder innerQuery, Map<String, Object> argumentMappings, String orderBy) {
        String sql = "SELECT " + fieldsSql + " FROM " + (String)(innerQuery != null ? "(" + innerQuery + ")" : this.tableName) + " AS " + this.tableAlias + (String)(orderBy != null ? " " + orderBy : "");
        List result = (List)this.dbi.withHandle(handle -> (List)((Query)handle.createQuery(sql).bindMap(argumentMappings)).mapToBean(Headword.class).collect(Collectors.toList()));
        return result;
    }

    public Headword save(Headword headword) {
        if (headword.getUuid() == null) {
            headword.setUuid(UUID.randomUUID());
        }
        headword.setCreated(LocalDateTime.now());
        headword.setLastModified(LocalDateTime.now());
        String sql = "INSERT INTO " + this.tableName + "( uuid, created, label, locale, last_modified) VALUES ( :uuid, :created, :label, :locale, :lastModified)";
        this.dbi.withHandle(h -> ((Update)h.createUpdate(sql).bindBean((Object)headword)).execute());
        return headword;
    }

    public List<Entity> setRelatedEntities(UUID headwordUuid, List<Entity> entities) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<FileResource> setRelatedFileResources(UUID headwordUuid, List<FileResource> fileResources) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        switch (modelProperty) {
            case "label": 
            case "locale": {
                return true;
            }
        }
        return false;
    }

    public Headword update(Headword headword) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

