/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.security;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.security.UserRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.SearchTermTemplates;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.security.Role;
import de.digitalcollections.model.security.User;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class UserRepositoryImpl
extends JdbiRepositoryImpl
implements UserRepository {
    public static final String MAPPING_PREFIX = "u";
    public static final String SQL_INSERT_FIELDS = " email, enabled, firstname, lastname, passwordhash, roles, uuid";
    public static final String SQL_INSERT_VALUES = " :email, :enabled, :firstname, :lastname, :passwordHash, :roles, :uuid";
    public static final String TABLE_ALIAS = "u";
    public static final String SQL_REDUCED_FIELDS_US;
    public static final String SQL_FULL_FIELDS_US;
    public static final String TABLE_NAME = "users";

    @Autowired
    public UserRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, "u", "u", cudamiConfig.getOffsetForAlternativePaging());
    }

    public User create() {
        return new User();
    }

    public PageResponse<User> find(PageRequest pageRequest) {
        StringBuilder commonSql = new StringBuilder(" FROM " + this.tableName + " AS " + this.tableAlias);
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        String executedSearchTerm = this.addSearchTerm(pageRequest, commonSql, argumentMappings);
        StringBuilder query = new StringBuilder("SELECT " + SQL_REDUCED_FIELDS_US + commonSql);
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query.toString()).bindMap(argumentMappings)).mapToBean(User.class).list());
        long total = this.count(commonSql.toString(), argumentMappings);
        return new PageResponse(result, pageRequest, total, executedSearchTerm);
    }

    public List<User> getActiveAdminUsers() {
        return (List)this.dbi.withHandle(h -> h.createQuery("SELECT " + SQL_REDUCED_FIELDS_US + " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE '" + Role.ADMIN.name() + "' = any(roles)").mapToBean(User.class).list());
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return new ArrayList<String>(Arrays.asList("email", "firstname", "lastname"));
    }

    public User getByEmail(String email) {
        List users = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT " + SQL_FULL_FIELDS_US + " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE email = :email").bind("email", email)).mapToBean(User.class).list());
        if (users.isEmpty()) {
            return null;
        }
        return (User)users.get(0);
    }

    public User getByUuid(UUID uuid) {
        List users = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT " + SQL_FULL_FIELDS_US + " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE uuid = :uuid").bind("uuid", uuid)).mapToBean(User.class).list());
        if (users.isEmpty()) {
            return null;
        }
        return (User)users.get(0);
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return this.tableAlias + ".created";
            }
            case "email": {
                return this.tableAlias + ".email";
            }
            case "lastname": {
                return this.tableAlias + ".lastname";
            }
            case "firstname": {
                return this.tableAlias + ".firstname";
            }
            case "lastModified": {
                return this.tableAlias + ".last_modified";
            }
            case "uuid": {
                return this.tableAlias + ".uuid";
            }
        }
        return null;
    }

    @Override
    protected List<String> getSearchTermTemplates(String tableAlias, String originalSearchTerm) {
        return new ArrayList<String>(Arrays.asList(SearchTermTemplates.ILIKE_SEARCH.renderTemplate(tableAlias, "email"), SearchTermTemplates.ILIKE_SEARCH.renderTemplate(tableAlias, "firstname"), SearchTermTemplates.ILIKE_SEARCH.renderTemplate(tableAlias, "lastname")));
    }

    @Override
    protected String getUniqueField() {
        return "uuid";
    }

    public User save(User user) {
        user.setUuid(UUID.randomUUID());
        user.setCreated(LocalDateTime.now());
        user.setLastModified(LocalDateTime.now());
        String sql = "INSERT INTO " + this.tableName + "( email, enabled, firstname, lastname, passwordhash, roles, uuid) VALUES ( :email, :enabled, :firstname, :lastname, :passwordHash, :roles, :uuid) RETURNING *";
        User result = (User)this.dbi.withHandle(h -> ((Query)((Handle)h.registerArrayType(Role.class, "varchar")).createQuery(sql).bindBean((Object)user)).mapToBean(User.class).findOne().orElse(null));
        return result;
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        switch (modelProperty) {
            case "firstname": 
            case "lastname": {
                return true;
            }
        }
        return false;
    }

    public User update(User user) {
        user.setLastModified(LocalDateTime.now());
        User result = (User)this.dbi.withHandle(h -> ((Query)((Handle)h.registerArrayType(Role.class, "varchar")).createQuery("UPDATE " + this.tableName + " SET email=:email, enabled=:enabled, firstname=:firstname, lastname=:lastname, last_modified=:lastModified, passwordhash=:passwordHash, roles=:roles WHERE uuid=:uuid RETURNING *").bindBean((Object)user)).mapToBean(User.class).findOne().orElse(null));
        return result;
    }

    static {
        SQL_FULL_FIELDS_US = SQL_REDUCED_FIELDS_US = String.format(" %1$s.uuid, %1$s.created, %1$s.email, %1$s.enabled, %1$s.firstname, %1$s.lastname, %1$s.last_modified, %1$s.passwordhash, %1$s.roles", "u");
    }
}

