/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.relation;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.relation.PredicateRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.model.relation.Predicate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PredicateRepositoryImpl
extends JdbiRepositoryImpl
implements PredicateRepository {
    public static final String MAPPING_PREFIX = "pred";
    public static final String SQL_INSERT_FIELDS = " value, label, description, created, last_modified, uuid";
    public static final String SQL_INSERT_VALUES = " :value, :label::JSONB, :description::JSONB, :created, :lastModified, :uuid";
    public static final String TABLE_ALIAS = "pred";
    public static final String SQL_REDUCED_FIELDS_PRED = String.format(" %1$s.uuid, %1$s.value, %1$s.label, %1$s.created, %1$s.last_modified", "pred");
    public static final String SQL_FULL_FIELDS_PRED = SQL_REDUCED_FIELDS_PRED + String.format(", %s.description", "pred");
    public static final String TABLE_NAME = "predicates";

    @Autowired
    public PredicateRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, "pred", "pred", cudamiConfig.getOffsetForAlternativePaging());
    }

    public void delete(String value) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE value = :value").bind("value", value)).execute());
    }

    public List<Predicate> getAll() {
        String sql = "SELECT " + SQL_REDUCED_FIELDS_PRED + " FROM " + this.tableName + " AS " + this.tableAlias;
        List result = (List)this.dbi.withHandle(h -> (List)h.createQuery(sql).mapToBean(Predicate.class).collect(Collectors.toList()));
        return result;
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return new ArrayList<String>(Arrays.asList("created", "label", "lastModified"));
    }

    public Predicate getByValue(String value) {
        String query = "SELECT " + SQL_FULL_FIELDS_PRED + " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE value = :value";
        Optional result = (Optional)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("value", value)).mapToBean(Predicate.class).findFirst());
        return result.orElse(null);
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return this.tableAlias + ".created";
            }
            case "label": {
                return this.tableAlias + ".label";
            }
            case "lastModified": {
                return this.tableAlias + ".last_modified";
            }
            case "uuid": {
                return this.tableAlias + ".uuid";
            }
            case "value": {
                return this.tableAlias + ".value";
            }
        }
        return null;
    }

    @Override
    protected String getUniqueField() {
        return "value";
    }

    public Predicate save(Predicate predicate) {
        Predicate existingPredicate = this.getByValue(predicate.getValue());
        if (existingPredicate != null) {
            predicate.setCreated(existingPredicate.getCreated());
        }
        predicate.setLastModified(LocalDateTime.now());
        if (existingPredicate != null) {
            String updateQuery = "UPDATE " + this.tableName + " SET label=:label::JSONB, description=:description::JSONB, last_modified=:lastModified WHERE value=:value";
            this.dbi.withHandle(h -> ((Update)h.createUpdate(updateQuery).bindBean((Object)predicate)).execute());
        } else {
            predicate.setUuid(UUID.randomUUID());
            predicate.setCreated(predicate.getLastModified());
            String createQuery = "INSERT INTO " + this.tableName + "( value, label, description, created, last_modified, uuid) VALUES ( :value, :label::JSONB, :description::JSONB, :created, :lastModified, :uuid)";
            this.dbi.withHandle(h -> ((Update)h.createUpdate(createQuery).bindBean((Object)predicate)).execute());
        }
        return this.getByValue(predicate.getValue());
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        switch (modelProperty) {
            case "label": 
            case "description": {
                return true;
            }
        }
        return false;
    }
}

