/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.WebsiteRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.SearchTermTemplates;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.web.WebpageRepositoryImpl;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.list.filtering.Filtering;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WebsiteRepositoryImpl
extends EntityRepositoryImpl<Website>
implements WebsiteRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsiteRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "ws";
    public static final String TABLE_ALIAS = "w";
    public static final String TABLE_NAME = "websites";
    private final WebpageRepositoryImpl webpageRepositoryImpl;

    public static String getSqlInsertFields() {
        return EntityRepositoryImpl.getSqlInsertFields() + ", registration_date, url";
    }

    public static String getSqlInsertValues() {
        return EntityRepositoryImpl.getSqlInsertValues() + ", :registrationDate, :url";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return WebsiteRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return EntityRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".url " + mappingPrefix + "_url, " + tableAlias + ".registration_date " + mappingPrefix + "_registrationDate";
    }

    public static String getSqlUpdateFieldValues() {
        return EntityRepositoryImpl.getSqlUpdateFieldValues() + ", registration_date=:registrationDate, url=:url";
    }

    @Autowired
    public WebsiteRepositoryImpl(Jdbi dbi, WebpageRepositoryImpl webpageRepositoryImpl, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, Website.class, WebsiteRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), WebsiteRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), WebsiteRepositoryImpl.getSqlInsertFields(), WebsiteRepositoryImpl.getSqlInsertValues(), WebsiteRepositoryImpl.getSqlUpdateFieldValues(), cudamiConfig.getOffsetForAlternativePaging());
        this.webpageRepositoryImpl = webpageRepositoryImpl;
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> allowedOrderByFields = super.getAllowedOrderByFields();
        allowedOrderByFields.addAll(Arrays.asList("url"));
        return allowedOrderByFields;
    }

    @Override
    public Website getByIdentifier(Identifier identifier) {
        Website website = (Website)super.getByIdentifier(identifier);
        if (website != null) {
            website.setRootPages(this.getRootPages(website));
        }
        return website;
    }

    @Override
    public Website getByUuidAndFiltering(UUID uuid, Filtering filtering) {
        Website website = (Website)super.getByUuidAndFiltering(uuid, filtering);
        if (website != null) {
            website.setRootPages(this.getRootPages(website));
        }
        return website;
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        if (super.getColumnName(modelProperty) != null) {
            return super.getColumnName(modelProperty);
        }
        switch (modelProperty) {
            case "url": {
                return this.tableAlias + ".url";
            }
            case "registrationDate": {
                return this.tableAlias + ".registration_date";
            }
        }
        return null;
    }

    public List<Webpage> getRootWebpages(UUID uuid) {
        String wpTableAlias = this.webpageRepositoryImpl.getTableAlias();
        String wpTableName = this.webpageRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + wpTableName + " AS " + wpTableAlias + " INNER JOIN website_webpages ww ON " + wpTableAlias + ".uuid = ww.webpage_uuid WHERE ww.website_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", uuid);
        List<Webpage> result = this.webpageRepositoryImpl.retrieveList(this.webpageRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, null);
        return result;
    }

    @Override
    protected List<String> getSearchTermTemplates(String tblAlias, String originalSearchTerm) {
        if (originalSearchTerm == null) {
            return Collections.EMPTY_LIST;
        }
        List<String> searchTermTemplates = super.getSearchTermTemplates(tblAlias, originalSearchTerm);
        searchTermTemplates.add(SearchTermTemplates.ILIKE_SEARCH.renderTemplate(tblAlias, "url"));
        return searchTermTemplates;
    }

    public Website save(Website website) {
        super.save((Identifiable)website);
        Website result = (Website)this.getByUuid(website.getUuid());
        return result;
    }

    public Website update(Website website) {
        super.update((Identifiable)website);
        Website result = (Website)this.getByUuid(website.getUuid());
        return result;
    }

    public boolean updateRootWebpagesOrder(UUID websiteUuid, List<Webpage> rootPages) {
        if (websiteUuid == null || rootPages == null) {
            return false;
        }
        String query = "UPDATE website_webpages SET sortindex = :idx WHERE website_uuid = :websiteUuid AND webpage_uuid = :webpageUuid;";
        this.dbi.withHandle(h -> {
            PreparedBatch batch = h.prepareBatch(query);
            int idx = 0;
            for (Webpage webpage : rootPages) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bind("idx", idx++)).bind("webpageUuid", webpage.getUuid())).bind("websiteUuid", websiteUuid)).add();
            }
            return batch.execute();
        });
        return true;
    }
}

