/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.HeadwordEntryRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.ArticleRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.EntityType;
import de.digitalcollections.model.identifiable.entity.HeadwordEntry;
import de.digitalcollections.model.identifiable.entity.agent.Agent;
import de.digitalcollections.model.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.identifiable.entity.agent.Family;
import de.digitalcollections.model.identifiable.entity.agent.Person;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.semantic.Headword;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class HeadwordEntryRepositoryImpl
extends EntityRepositoryImpl<HeadwordEntry>
implements HeadwordEntryRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeadwordEntryRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "he";
    private static final String SQL_SELECT_ALL_FIELDS_JOINS = " LEFT JOIN headwords AS hw ON hw.uuid = he.headword";
    public static final String TABLE_ALIAS = "he";
    public static final String TABLE_NAME = "headwordentries";
    private final EntityRepositoryImpl<Entity> entityRepositoryImpl;

    private static BiFunction<Map<UUID, HeadwordEntry>, RowView, Map<UUID, HeadwordEntry>> createAdditionalReduceRowsBiFunction() {
        return (map, rowView) -> {
            HeadwordEntry headwordEntry = (HeadwordEntry)map.get(rowView.getColumn("he_uuid", UUID.class));
            if (rowView.getColumn("hw_uuid", UUID.class) != null) {
                UUID headwordUuid = (UUID)rowView.getColumn("hw_uuid", UUID.class);
                String label = (String)rowView.getColumn("hw_label", String.class);
                Headword headword = new Headword();
                headword.setUuid(headwordUuid);
                headword.setLabel(label);
                headwordEntry.setHeadword(headword);
            }
            return map;
        };
    }

    public static String getSqlInsertFields() {
        return ArticleRepositoryImpl.getSqlInsertFields() + ", headword";
    }

    public static String getSqlInsertValues() {
        return ArticleRepositoryImpl.getSqlInsertValues() + ", :headword";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return HeadwordEntryRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".text " + mappingPrefix + "_text, hw.uuid hw_uuid, hw.label hw_label";
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return ArticleRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String getSqlUpdateFieldValues() {
        return ArticleRepositoryImpl.getSqlUpdateFieldValues() + ", headword=:headword";
    }

    @Autowired
    public HeadwordEntryRepositoryImpl(Jdbi dbi, @Qualifier(value="entityRepositoryImpl") EntityRepositoryImpl<Entity> entityRepositoryImpl, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, "he", "he", (Class)HeadwordEntry.class, HeadwordEntryRepositoryImpl.getSqlSelectAllFields("he", "he"), HeadwordEntryRepositoryImpl.getSqlSelectReducedFields("he", "he"), HeadwordEntryRepositoryImpl.getSqlInsertFields(), HeadwordEntryRepositoryImpl.getSqlInsertValues(), HeadwordEntryRepositoryImpl.getSqlUpdateFieldValues(), SQL_SELECT_ALL_FIELDS_JOINS, HeadwordEntryRepositoryImpl.createAdditionalReduceRowsBiFunction(), cudamiConfig.getOffsetForAlternativePaging());
        this.entityRepositoryImpl = entityRepositoryImpl;
    }

    public List<HeadwordEntry> getByHeadword(UUID headwordUuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " WHERE headword = :uuid ORDER BY date_published ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", headwordUuid);
        List<HeadwordEntry> result = this.retrieveList(this.sqlSelectAllFields, innerQuery, argumentMappings, "ORDER BY " + this.tableAlias + ".date_published ASC");
        return result;
    }

    @Override
    public HeadwordEntry getByIdentifier(Identifier identifier) {
        HeadwordEntry headwordEntry = (HeadwordEntry)super.getByIdentifier(identifier);
        if (headwordEntry != null) {
            headwordEntry.setCreators(this.getCreators(headwordEntry.getUuid()));
        }
        return headwordEntry;
    }

    @Override
    public HeadwordEntry getByRefId(long refId) {
        HeadwordEntry headwordEntry = (HeadwordEntry)super.getByRefId(refId);
        if (headwordEntry != null) {
            headwordEntry.setCreators(this.getCreators(headwordEntry.getUuid()));
        }
        return headwordEntry;
    }

    @Override
    public HeadwordEntry getByUuidAndFiltering(UUID uuid, Filtering filtering) {
        HeadwordEntry headwordEntry = (HeadwordEntry)super.getByUuidAndFiltering(uuid, filtering);
        if (headwordEntry != null) {
            List<Agent> creators = this.getCreators(uuid);
            headwordEntry.setCreators(creators);
        }
        return headwordEntry;
    }

    public List<Agent> getCreators(UUID headwordEntryUuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT hec.sortindex AS idx, * FROM entities AS e LEFT JOIN headwordentry_creators AS hec ON e.uuid = hec.agent_uuid WHERE hec.headwordentry_uuid = :uuid ORDER BY hec.sortindex ASC");
        String fieldsSql = this.entityRepositoryImpl.getSqlSelectReducedFields();
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", headwordEntryUuid);
        List entityList = this.entityRepositoryImpl.retrieveList(fieldsSql, innerQuery, argumentMappings, "ORDER BY idx ASC");
        List agents = null;
        if (entityList != null) {
            agents = entityList.stream().map(entity -> {
                EntityType entityType = entity.getEntityType();
                switch (entityType) {
                    case CORPORATE_BODY: {
                        CorporateBody corporateBody = new CorporateBody();
                        corporateBody.setLabel(entity.getLabel());
                        corporateBody.setRefId(entity.getRefId());
                        corporateBody.setUuid(entity.getUuid());
                        return corporateBody;
                    }
                    case FAMILY: {
                        Family family = new Family();
                        family.setLabel(entity.getLabel());
                        family.setRefId(entity.getRefId());
                        family.setUuid(entity.getUuid());
                        return family;
                    }
                    case PERSON: {
                        Person person = new Person();
                        person.setLabel(entity.getLabel());
                        person.setRefId(entity.getRefId());
                        person.setUuid(entity.getUuid());
                        return person;
                    }
                }
                return null;
            }).collect(Collectors.toList());
        }
        return agents;
    }

    @Override
    public List<FileResource> getRelatedFileResources(UUID entityUuid) {
        return this.entityRepositoryImpl.getRelatedFileResources(entityUuid);
    }

    public HeadwordEntry save(HeadwordEntry headwordEntry) {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        UUID headwordUuid = null;
        if (headwordEntry.getHeadword() != null) {
            headwordUuid = headwordEntry.getHeadword().getUuid();
        }
        bindings.put("headword", headwordUuid);
        super.save(headwordEntry, (Map<String, Object>)bindings);
        List creators = headwordEntry.getCreators();
        this.setCreatorsList(headwordEntry, creators);
        HeadwordEntry result = (HeadwordEntry)this.getByUuid(headwordEntry.getUuid());
        return result;
    }

    private void setCreatorsList(HeadwordEntry headwordEntry, List<Agent> creators) {
        UUID headwordEntryUuid = headwordEntry.getUuid();
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM headwordentry_creators WHERE headwordentry_uuid = :uuid").bind("uuid", headwordEntryUuid)).execute());
        if (creators != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO headwordentry_creators(headwordentry_uuid, agent_uuid, sortIndex) VALUES(:uuid, :agentUuid, :sortIndex)");
                for (Agent agent : creators) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", headwordEntryUuid)).bind("agentUuid", agent.getUuid())).bind("sortIndex", this.getIndex(creators, (Identifiable)agent))).add();
                }
                preparedBatch.execute();
            });
        }
    }

    public HeadwordEntry update(HeadwordEntry headwordEntry) {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        UUID headwordUuid = null;
        if (headwordEntry.getHeadword() != null) {
            headwordUuid = headwordEntry.getHeadword().getUuid();
        }
        bindings.put("headword", headwordUuid);
        super.update(headwordEntry, (Map<String, Object>)bindings);
        List creators = headwordEntry.getCreators();
        this.setCreatorsList(headwordEntry, creators);
        HeadwordEntry result = (HeadwordEntry)this.getByUuid(headwordEntry.getUuid());
        return result;
    }
}

