/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.database.migration;

import java.util.List;
import java.util.Map;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class V1_6_5__DML_Change_imagefileresource_iiifBaseUrl
extends BaseJavaMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(V1_6_5__DML_Change_imagefileresource_iiifBaseUrl.class);

    public void migrate(Context context) throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(new SingleConnectionDataSource(context.getConnection(), true).getConnection());
        String selectQuery = "SELECT uuid, uri, iiif_base_url FROM fileresources_image";
        String updateQuery = "UPDATE fileresources_image SET iiif_base_url=? WHERE uuid=?::uuid";
        List imageFileResources = jdbcTemplate.queryForList(selectQuery, new Object[0]);
        for (Map imageFileResource : imageFileResources) {
            String currentUri = (String)imageFileResource.get("uri");
            Object newIiifBaseUrl = null;
            if (currentUri != null && currentUri.startsWith("file")) {
                newIiifBaseUrl = (String)imageFileResource.get("iiif_base_url");
                if (!((String)newIiifBaseUrl).endsWith("/")) {
                    newIiifBaseUrl = (String)newIiifBaseUrl + "/";
                }
                newIiifBaseUrl = (String)newIiifBaseUrl + (String)imageFileResource.get("uuid");
            }
            jdbcTemplate.update(updateQuery, new Object[]{newIiifBaseUrl, imageFileResource.get("uuid")});
        }
    }
}

