/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.EntityRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.FileResourceMetadataRepositoryImpl;
import de.digitalcollections.model.filter.Filtering;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class EntityRepositoryImpl<E extends Entity>
extends IdentifiableRepositoryImpl<E>
implements EntityRepository<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "e";
    public static final String TABLE_ALIAS = "e";
    public static final String TABLE_NAME = "entities";
    private FileResourceMetadataRepositoryImpl fileResourceMetadataRepositoryImpl;

    public static String getSqlInsertFields() {
        return IdentifiableRepositoryImpl.getSqlInsertFields() + ", custom_attrs, entity_type";
    }

    public static String getSqlInsertValues() {
        return IdentifiableRepositoryImpl.getSqlInsertValues() + ", :customAttributes::JSONB, :entityType";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return EntityRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return IdentifiableRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".custom_attrs " + mappingPrefix + "_customAttributes, " + tableAlias + ".entity_type " + mappingPrefix + "_entityType, " + tableAlias + ".refid " + mappingPrefix + "_refId";
    }

    public static String getSqlUpdateFieldValues() {
        return IdentifiableRepositoryImpl.getSqlUpdateFieldValues() + ", custom_attrs=:customAttributes::JSONB";
    }

    @Autowired
    private EntityRepositoryImpl(Jdbi dbi, FileResourceMetadataRepositoryImpl fileResourceMetadataRepositoryImpl) {
        this(dbi, TABLE_NAME, "e", "e", Entity.class, EntityRepositoryImpl.getSqlSelectAllFields("e", "e"), EntityRepositoryImpl.getSqlSelectReducedFields("e", "e"), EntityRepositoryImpl.getSqlInsertFields(), EntityRepositoryImpl.getSqlInsertValues(), EntityRepositoryImpl.getSqlUpdateFieldValues());
        this.fileResourceMetadataRepositoryImpl = fileResourceMetadataRepositoryImpl;
    }

    protected EntityRepositoryImpl(Jdbi dbi, String tableName, String tableAlias, String mappingPrefix, Class entityImplClass, String sqlSelectAllFields, String sqlSelectReducedFields, String sqlInsertFields, String sqlInsertValues, String sqlUpdateFieldValues) {
        this(dbi, tableName, tableAlias, mappingPrefix, entityImplClass, sqlSelectAllFields, sqlSelectReducedFields, sqlInsertFields, sqlInsertValues, sqlUpdateFieldValues, null);
    }

    protected EntityRepositoryImpl(Jdbi dbi, String tableName, String tableAlias, String mappingPrefix, Class entityImplClass, String sqlSelectAllFields, String sqlSelectReducedFields, String sqlInsertFields, String sqlInsertValues, String sqlUpdateFieldValues, String sqlSelectAllFieldsJoins) {
        this(dbi, tableName, tableAlias, mappingPrefix, entityImplClass, sqlSelectAllFields, sqlSelectReducedFields, sqlInsertFields, sqlInsertValues, sqlUpdateFieldValues, sqlSelectAllFieldsJoins, (BiFunction<Map<UUID, E>, RowView, Map<UUID, E>>)null);
    }

    protected EntityRepositoryImpl(Jdbi dbi, String tableName, String tableAlias, String mappingPrefix, Class entityImplClass, String sqlSelectAllFields, String sqlSelectReducedFields, String sqlInsertFields, String sqlInsertValues, String sqlUpdateFieldValues, String sqlSelectAllFieldsJoins, BiFunction<Map<UUID, E>, RowView, Map<UUID, E>> additionalReduceRowsBiFunction) {
        super(dbi, tableName, tableAlias, mappingPrefix, entityImplClass, sqlSelectAllFields, sqlSelectReducedFields, sqlInsertFields, sqlInsertValues, sqlUpdateFieldValues, sqlSelectAllFieldsJoins, additionalReduceRowsBiFunction);
    }

    @Override
    public void addRelatedFileresource(UUID entityUuid, UUID fileResourceUuid) {
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "rel_entity_fileresources", "entity_uuid", entityUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO rel_entity_fileresources(entity_uuid, fileresource_uuid, sortindex) VALUES (:entity_uuid, :fileresource_uuid, :sortindex)").bind("entity_uuid", entityUuid)).bind("fileresource_uuid", fileResourceUuid)).bind("sortindex", nextSortIndex)).execute());
    }

    public E findOneByRefId(long refId) {
        Filtering filtering = Filtering.defaultBuilder().filter("refId").isEquals((Object)refId).build();
        return (E)((Entity)this.retrieveOne(this.sqlSelectAllFields, this.sqlSelectAllFieldsJoins, filtering));
    }

    public List<E> findRandom(int count) {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " ORDER BY RANDOM() LIMIT " + count);
        return this.retrieveList(this.sqlSelectReducedFields, innerQuery, null, null);
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> allowedOrderByFields = super.getAllowedOrderByFields();
        allowedOrderByFields.addAll(Arrays.asList("entityType", "refId"));
        return allowedOrderByFields;
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        if (super.getColumnName(modelProperty) != null) {
            return super.getColumnName(modelProperty);
        }
        switch (modelProperty) {
            case "entityType": {
                return this.tableAlias + ".entity_type";
            }
            case "refId": {
                return this.tableAlias + ".refid";
            }
        }
        return null;
    }

    @Override
    public List<FileResource> getRelatedFileResources(UUID entityUuid) {
        String frTableAlias = this.fileResourceMetadataRepositoryImpl.getTableAlias();
        String frTableName = this.fileResourceMetadataRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT ref.sortindex AS idx, * FROM " + frTableName + " AS " + frTableAlias + " INNER JOIN rel_entity_fileresources ref ON " + frTableAlias + ".uuid = ref.fileresource_uuid WHERE ref.entity_uuid = :entityUuid ORDER BY idx ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("entityUuid", entityUuid);
        return this.fileResourceMetadataRepositoryImpl.retrieveList(this.fileResourceMetadataRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, "ORDER BY idx ASC");
    }

    @Override
    public E save(E entity, Map<String, Object> bindings) {
        return (E)((Entity)super.save(entity, bindings));
    }

    @Override
    public List<FileResource> saveRelatedFileResources(UUID entityUuid, List<FileResource> fileResources) {
        if (fileResources == null) {
            return null;
        }
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM rel_entity_fileresources WHERE entity_uuid = :uuid").bind("uuid", entityUuid)).execute());
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO rel_entity_fileresources(entity_uuid, fileresource_uuid, sortIndex) VALUES(:uuid, :fileResourceUuid, :sortIndex)");
            for (FileResource fileResource : fileResources) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", entityUuid)).bind("fileResourceUuid", fileResource.getUuid())).bind("sortIndex", this.getIndex(fileResources, (Identifiable)fileResource))).add();
            }
            preparedBatch.execute();
        });
        return this.getRelatedFileResources(entityUuid);
    }

    @Override
    public E update(E entity, Map<String, Object> bindings) {
        return (E)((Entity)super.update(entity, bindings));
    }
}

