/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.CollectionRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.DigitalObjectRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent.CorporateBodyRepositoryImpl;
import de.digitalcollections.model.filter.FilterCriterion;
import de.digitalcollections.model.filter.Filtering;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import de.digitalcollections.model.view.BreadcrumbNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class CollectionRepositoryImpl
extends EntityRepositoryImpl<Collection>
implements CollectionRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "col";
    public static final String TABLE_ALIAS = "c";
    public static final String TABLE_NAME = "collections";
    @Lazy
    @Autowired
    private CorporateBodyRepositoryImpl corporateBodyRepositoryImpl;
    @Lazy
    @Autowired
    private DigitalObjectRepositoryImpl digitalObjectRepositoryImpl;

    public static String getSqlInsertFields() {
        return EntityRepositoryImpl.getSqlInsertFields() + ", publication_end, publication_start, text";
    }

    public static String getSqlInsertValues() {
        return EntityRepositoryImpl.getSqlInsertValues() + ", :publicationEnd, :publicationStart, :text::JSONB";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return CollectionRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".text " + mappingPrefix + "_text";
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return EntityRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".publication_start " + mappingPrefix + "_publicationStart, " + tableAlias + ".publication_end " + mappingPrefix + "_publicationEnd";
    }

    public static String getSqlUpdateFieldValues() {
        return EntityRepositoryImpl.getSqlUpdateFieldValues() + ", publication_end=:publicationEnd, publication_start=:publicationStart, text=:text::JSONB";
    }

    @Autowired
    public CollectionRepositoryImpl(Jdbi dbi) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, Collection.class, CollectionRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), CollectionRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), CollectionRepositoryImpl.getSqlInsertFields(), CollectionRepositoryImpl.getSqlInsertValues(), CollectionRepositoryImpl.getSqlUpdateFieldValues());
    }

    public boolean addChildren(UUID parentUuid, List<UUID> childrenUuids) {
        if (parentUuid == null || childrenUuids == null) {
            return false;
        }
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "collection_collections", "parent_collection_uuid", parentUuid);
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO collection_collections(parent_collection_uuid, child_collection_uuid, sortIndex) VALUES (:parentCollectionUuid, :childCollectionUuid, :sortIndex) ON CONFLICT (parent_collection_uuid, child_collection_uuid) DO NOTHING");
            childrenUuids.forEach(childUuid -> ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("parentCollectionUuid", parentUuid)).bind("childCollectionUuid", childUuid)).bind("sortIndex", nextSortIndex + this.getIndex(childrenUuids, (UUID)childUuid))).add());
            preparedBatch.execute();
        });
        return true;
    }

    public boolean addDigitalObjects(UUID collectionUuid, List<DigitalObject> digitalObjects) {
        if (collectionUuid != null && digitalObjects != null) {
            Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "collection_digitalobjects", "collection_uuid", collectionUuid);
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO collection_digitalobjects(collection_uuid, digitalobject_uuid, sortIndex) VALUES (:uuid, :digitalObjectUuid, :sortIndex) ON CONFLICT (collection_uuid, digitalobject_uuid) DO NOTHING");
                digitalObjects.forEach(digitalObject -> ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", collectionUuid)).bind("digitalObjectUuid", digitalObject.getUuid())).bind("sortIndex", nextSortIndex + this.getIndex(digitalObjects, (Identifiable)digitalObject))).add());
                preparedBatch.execute();
            });
            return true;
        }
        return false;
    }

    public SearchPageResponse<Collection> findChildren(UUID uuid, SearchPageRequest searchPageRequest) {
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN collection_collections cc ON " + this.tableAlias + ".uuid = cc.child_collection_uuid WHERE cc.parent_collection_uuid = :uuid";
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", uuid);
        String searchTerm = searchPageRequest.getQuery();
        if (StringUtils.hasText((String)searchTerm)) {
            commonSql = commonSql + " AND " + this.getCommonSearchSql(this.tableAlias);
            argumentMappings.put("searchTerm", this.escapeTermForJsonpath(searchTerm));
        }
        StringBuilder innerQuery = new StringBuilder("SELECT cc.sortindex AS idx, *" + commonSql);
        this.addFiltering((PageRequest)searchPageRequest, innerQuery, argumentMappings);
        String orderBy = this.getOrderBy(searchPageRequest.getSorting());
        if (!StringUtils.hasText((String)orderBy)) {
            orderBy = "ORDER BY idx ASC";
            innerQuery.append(" ").append(orderBy);
        }
        this.addPageRequestParams((PageRequest)searchPageRequest, innerQuery);
        List result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(" + this.tableAlias + ".uuid)" + commonSql);
        this.addFiltering((PageRequest)searchPageRequest, countQuery, argumentMappings);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new SearchPageResponse(result, searchPageRequest, total);
    }

    @Override
    public Collection findOne(UUID uuid, Filtering filtering) {
        Collection collection = (Collection)super.findOne(uuid, filtering);
        if (collection != null) {
            collection.setChildren(this.getChildren((Identifiable)collection));
        }
        return collection;
    }

    @Override
    public Collection findOne(Identifier identifier) {
        Collection collection = (Collection)super.findOne(identifier);
        if (collection != null) {
            collection.setChildren(this.getChildren((Identifiable)collection));
        }
        return collection;
    }

    @Override
    public Collection findOneByRefId(long refId) {
        Collection collection = (Collection)super.findOneByRefId(refId);
        if (collection != null) {
            collection.setChildren(this.getChildren((Identifiable)collection));
        }
        return collection;
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> allowedOrderByFields = super.getAllowedOrderByFields();
        allowedOrderByFields.addAll(Arrays.asList("publicationEnd", "publicationStart"));
        return allowedOrderByFields;
    }

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID nodeUuid) {
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("WITH recursive breadcrumb (uuid,label,refId,parentId,depth) AS (        SELECT c.uuid AS uuid, c.label AS label, c.refid AS refId, cc.parent_collection_uuid AS parentId, 99 AS depth        FROM collections c, collection_collections cc        WHERE uuid= :uuid and cc.child_collection_uuid = c.uuid        UNION ALL        SELECT c.uuid AS uuid, c.label AS label, c.refid AS refID, cc.parent_collection_uuid AS parentId, depth-1 AS depth        FROM collections c, collection_collections cc, breadcrumb b        WHERE b.uuid = cc.child_collection_uuid AND cc.parent_collection_uuid = c.uuid AND cc.parent_collection_uuid IS NOT null    ) SELECT cast(refId AS VARCHAR) as targetId, label, depth FROM breadcrumb ORDER BY depth ASC").bind("uuid", nodeUuid)).mapTo(BreadcrumbNode.class).list());
        if (result.isEmpty()) {
            result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT cast(refId AS VARCHAR) as targetId, label AS label FROM collections WHERE uuid= :uuid").bind("uuid", nodeUuid)).mapTo(BreadcrumbNode.class).list());
        }
        return new BreadcrumbNavigation(result);
    }

    public List<Collection> getChildren(UUID uuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT cc.sortindex AS idx, * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN collection_collections cc ON " + this.tableAlias + ".uuid = cc.child_collection_uuid WHERE cc.parent_collection_uuid = :uuid ORDER BY cc.sortindex ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", uuid);
        List<Collection> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, "ORDER BY idx ASC");
        return result;
    }

    public PageResponse<Collection> getChildren(UUID uuid, PageRequest pageRequest) {
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN collection_collections cc ON " + this.tableAlias + ".uuid = cc.child_collection_uuid WHERE cc.parent_collection_uuid = :uuid";
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", uuid);
        StringBuilder innerQuery = new StringBuilder("SELECT cc.sortindex AS idx, *" + commonSql);
        this.addFiltering(pageRequest, innerQuery, argumentMappings);
        pageRequest.setSorting(null);
        innerQuery.append(" ORDER BY idx ASC");
        this.addPageRequestParams(pageRequest, innerQuery);
        List result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, "ORDER BY idx ASC");
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        this.addFiltering(pageRequest, countQuery, argumentMappings);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total);
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        if (super.getColumnName(modelProperty) != null) {
            return super.getColumnName(modelProperty);
        }
        switch (modelProperty) {
            case "publicationEnd": {
                return this.tableAlias + ".publication_end";
            }
            case "publicationStart": {
                return this.tableAlias + ".publication_start";
            }
        }
        return null;
    }

    public SearchPageResponse<DigitalObject> getDigitalObjects(UUID collectionUuid, SearchPageRequest searchPageRequest) {
        String doTableAlias = this.digitalObjectRepositoryImpl.getTableAlias();
        String doTableName = this.digitalObjectRepositoryImpl.getTableName();
        String commonSql = " FROM " + doTableName + " AS " + doTableAlias + " LEFT JOIN collection_digitalobjects AS cd ON " + doTableAlias + ".uuid = cd.digitalobject_uuid WHERE cd.collection_uuid = :uuid";
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", collectionUuid);
        String searchTerm = searchPageRequest.getQuery();
        if (StringUtils.hasText((String)searchTerm)) {
            commonSql = commonSql + " AND " + this.getCommonSearchSql(doTableAlias);
            argumentMappings.put("searchTerm", this.escapeTermForJsonpath(searchTerm));
        }
        StringBuilder innerQuery = new StringBuilder("SELECT cd.sortindex AS idx, *" + commonSql);
        this.addFiltering((PageRequest)searchPageRequest, innerQuery, argumentMappings);
        String orderBy = null;
        if (searchPageRequest.getSorting() == null) {
            orderBy = "ORDER BY idx ASC";
            innerQuery.append(" ").append(orderBy);
        }
        this.addPageRequestParams((PageRequest)searchPageRequest, innerQuery);
        List result = this.digitalObjectRepositoryImpl.retrieveList(this.digitalObjectRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        this.addFiltering((PageRequest)searchPageRequest, countQuery, argumentMappings);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new SearchPageResponse(result, searchPageRequest, total);
    }

    public PageResponse<DigitalObject> getDigitalObjects(UUID collectionUuid, PageRequest pageRequest) {
        String doTableAlias = this.digitalObjectRepositoryImpl.getTableAlias();
        String doTableName = this.digitalObjectRepositoryImpl.getTableName();
        String commonSql = " FROM " + doTableName + " AS " + doTableAlias + " LEFT JOIN collection_digitalobjects AS cd ON " + doTableAlias + ".uuid = cd.digitalobject_uuid WHERE cd.collection_uuid = :uuid";
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", collectionUuid);
        StringBuilder innerQuery = new StringBuilder("SELECT cd.sortindex AS idx, *" + commonSql);
        this.addFiltering(pageRequest, innerQuery, argumentMappings);
        pageRequest.setSorting(null);
        innerQuery.append(" ORDER BY idx ASC");
        this.addPageRequestParams(pageRequest, innerQuery);
        List result = this.digitalObjectRepositoryImpl.retrieveList(this.digitalObjectRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, "ORDER BY idx ASC");
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        this.addFiltering(pageRequest, countQuery, argumentMappings);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total);
    }

    public Collection getParent(UUID uuid) {
        String sqlAdditionalJoins = " INNER JOIN collection_collections cc ON " + this.tableAlias + ".uuid = cc.parent_collection_uuid";
        Filtering filtering = Filtering.defaultBuilder().filterNative("cc.child_collection_uuid").isEquals((Object)uuid).build();
        Collection result = (Collection)this.retrieveOne(this.sqlSelectReducedFields, sqlAdditionalJoins, filtering);
        return result;
    }

    public List<Collection> getParents(UUID uuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN collection_collections cc ON " + this.tableAlias + ".uuid = cc.parent_collection_uuid WHERE cc.child_collection_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", uuid);
        List<Collection> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, null);
        return result;
    }

    public List<CorporateBody> getRelatedCorporateBodies(UUID uuid, Filtering filtering) {
        String cbTableAlias = this.corporateBodyRepositoryImpl.getTableAlias();
        String cbTableName = this.corporateBodyRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + cbTableName + " AS " + cbTableAlias + " LEFT JOIN rel_entity_entities AS r ON " + cbTableAlias + ".uuid = r.object_uuid LEFT JOIN rel_entity_entities AS rel ON r.subject_uuid = rel.subject_uuid WHERE rel.object_uuid = :uuid AND rel.predicate = 'is_part_of'");
        FilterCriterion predicate = filtering.getFilterCriterionFor("predicate");
        if (predicate != null) {
            String predicateFilter = String.format(" AND r.predicate = '%s'", predicate.getValue());
            innerQuery.append(predicateFilter);
        }
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", uuid);
        List<CorporateBody> result = this.corporateBodyRepositoryImpl.retrieveList(this.corporateBodyRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, null);
        return result;
    }

    public PageResponse<Collection> getRootNodes(PageRequest pageRequest) {
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE NOT EXISTS (SELECT FROM collection_collections WHERE child_collection_uuid = " + this.tableAlias + ".uuid)";
        return this.find(pageRequest, commonSql, new HashMap<String, Object>());
    }

    public SearchPageResponse<Collection> findRootNodes(SearchPageRequest searchPageRequest) {
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE ( NOT EXISTS (SELECT FROM collection_collections WHERE child_collection_uuid = " + this.tableAlias + ".uuid))";
        String searchTerm = searchPageRequest.getQuery();
        if (!StringUtils.hasText((String)searchTerm)) {
            return this.find(searchPageRequest, commonSql, (Map<String, Object>)Collections.EMPTY_MAP);
        }
        commonSql = commonSql + " AND " + this.getCommonSearchSql(this.tableAlias);
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("searchTerm", this.escapeTermForJsonpath(searchTerm));
        return this.find(searchPageRequest, commonSql, argumentMappings);
    }

    public List<Locale> getRootNodesLanguages() {
        String query = "SELECT DISTINCT languages FROM " + this.tableName + " AS " + this.tableAlias + ", jsonb_object_keys(" + this.tableAlias + ".label) AS languages WHERE NOT EXISTS (SELECT FROM collection_collections WHERE child_collection_uuid = " + this.tableAlias + ".uuid)";
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query).mapTo(Locale.class).list());
        return result;
    }

    public boolean removeChild(UUID parentUuid, UUID childUuid) {
        if (parentUuid == null || childUuid == null) {
            return false;
        }
        String sql = "DELETE FROM collection_collections WHERE parent_collection_uuid=:parentCollectionUuid AND child_collection_uuid=:childCollectionUuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM collection_collections WHERE parent_collection_uuid=:parentCollectionUuid AND child_collection_uuid=:childCollectionUuid").bind("parentCollectionUuid", parentUuid)).bind("childCollectionUuid", childUuid)).execute());
        return true;
    }

    public boolean removeDigitalObject(UUID collectionUuid, UUID digitalObjectUuid) {
        if (collectionUuid != null && digitalObjectUuid != null) {
            String sql = "DELETE FROM collection_digitalobjects WHERE collection_uuid=:collectionUuid AND digitalobject_uuid=:digitalObjectUuid";
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM collection_digitalobjects WHERE collection_uuid=:collectionUuid AND digitalobject_uuid=:digitalObjectUuid").bind("collectionUuid", collectionUuid)).bind("digitalObjectUuid", digitalObjectUuid)).execute());
            return true;
        }
        return false;
    }

    public boolean removeDigitalObjectFromAllCollections(DigitalObject digitalObject) {
        if (digitalObject == null) {
            return false;
        }
        String sql = "DELETE FROM collection_digitalobjects WHERE digitalobject_uuid=:digitalObjectUuid";
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM collection_digitalobjects WHERE digitalobject_uuid=:digitalObjectUuid").bind("digitalObjectUuid", digitalObject.getUuid())).execute());
        return true;
    }

    public Collection save(Collection collection) {
        super.save((Identifiable)collection);
        Collection result = (Collection)this.findOne(collection.getUuid());
        return result;
    }

    public boolean saveDigitalObjects(UUID collectionUuid, List<DigitalObject> digitalObjects) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM collection_digitalobjects WHERE collection_uuid = :uuid").bind("uuid", collectionUuid)).execute());
        if (digitalObjects != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO collection_digitalobjects(collection_uuid, digitalobject_uuid, sortIndex) VALUES (:uuid, :digitalObjectUuid, :sortIndex)");
                for (DigitalObject digitalObject : digitalObjects) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", collectionUuid)).bind("digitalObjectUuid", digitalObject.getUuid())).bind("sortIndex", this.getIndex(digitalObjects, (Identifiable)digitalObject))).add();
                }
                preparedBatch.execute();
            });
            return true;
        }
        return false;
    }

    public Collection saveWithParent(UUID childUuid, UUID parentUuid) {
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "collection_collections", "parent_collection_uuid", parentUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO collection_collections(parent_collection_uuid, child_collection_uuid, sortindex) VALUES (:parent_collection_uuid, :child_collection_uuid, :sortindex)").bind("parent_collection_uuid", parentUuid)).bind("child_collection_uuid", childUuid)).bind("sortindex", nextSortIndex)).execute());
        return (Collection)this.findOne(childUuid);
    }

    public Collection update(Collection collection) {
        super.update((Identifiable)collection);
        Collection result = (Collection)this.findOne(collection.getUuid());
        return result;
    }

    public boolean updateChildrenOrder(UUID parentUuid, List<Collection> children) {
        if (parentUuid == null || children == null) {
            return false;
        }
        String query = "UPDATE collection_collections SET sortindex = :idx WHERE child_collection_uuid = :childUuid AND parent_collection_uuid = :parentUuid;";
        this.dbi.withHandle(h -> {
            PreparedBatch batch = h.prepareBatch(query);
            int idx = 0;
            for (Collection collection : children) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bind("idx", idx++)).bind("childUuid", collection.getUuid())).bind("parentUuid", parentUuid)).add();
            }
            return batch.execute();
        });
        return true;
    }
}

