/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.commons.jdbi.DcCommonsJdbiPlugin;
import de.digitalcollections.cudami.server.backend.impl.jdbi.plugins.JsonbJdbiPlugin;
import de.digitalcollections.model.view.BreadcrumbNode;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.postgres.PostgresPlugin;
import org.jdbi.v3.spring5.JdbiFactoryBean;
import org.jdbi.v3.sqlobject.SqlObjectPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.security.web.authentication.rememberme.JdbcTokenRepositoryImpl;
import org.springframework.security.web.authentication.rememberme.PersistentTokenRepository;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@ComponentScan(basePackages={"de.digitalcollections.cudami.server.backend.impl.jdbi"})
@EnableTransactionManagement
public class SpringConfigBackendDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpringConfigBackendDatabase.class);

    @Autowired
    @Bean
    @Qualifier(value="pds")
    public PersistentTokenRepository persistentTokenRepository(DataSource pds) {
        JdbcTokenRepositoryImpl tokenRepository = new JdbcTokenRepositoryImpl();
        tokenRepository.setDataSource(pds);
        return tokenRepository;
    }

    @Bean
    public Jdbi dbi(JdbiFactoryBean factory) throws Exception {
        Jdbi dbi = (Jdbi)factory.getObject();
        if (dbi != null) {
            dbi.registerRowMapper(BeanMapper.factory(BreadcrumbNode.class));
        }
        return dbi;
    }

    @Bean
    public JdbiFactoryBean jdbi(DataSource ds, ObjectMapper objectMapper) throws Exception {
        JdbiFactoryBean jdbiFactoryBean = new JdbiFactoryBean(ds);
        ArrayList<Object> plugins = new ArrayList<Object>();
        plugins.add(new SqlObjectPlugin());
        plugins.add(new PostgresPlugin());
        plugins.add(new DcCommonsJdbiPlugin());
        plugins.add(new JsonbJdbiPlugin(objectMapper));
        jdbiFactoryBean.setPlugins(plugins);
        return jdbiFactoryBean;
    }

    @Bean
    public DataSourceTransactionManager transactionManager(DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }
}

