/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class IdentifierRepositoryImpl
extends JdbiRepositoryImpl
implements IdentifierRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifierRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "id";
    public static final String SQL_FULL_FIELDS_ID = " id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id";
    public static final String TABLE_ALIAS = "id";
    public static final String TABLE_NAME = "identifiers";

    @Autowired
    public IdentifierRepositoryImpl(Jdbi dbi) {
        super(dbi, TABLE_NAME, "id", "id");
        dbi.registerRowMapper(BeanMapper.factory(Identifier.class, (String)"id"));
    }

    public void delete(List<UUID> uuids) {
        if (uuids == null || uuids.isEmpty()) {
            return;
        }
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE uuid in (<uuids>)").bindList("uuids", (Iterable)uuids)).execute());
    }

    public void deleteByIdentifiable(UUID identifiableUuid) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE identifiable = :uuid").bind("uuid", identifiableUuid)).execute());
    }

    public PageResponse<Identifier> find(PageRequest pageRequest) {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName);
        this.addFiltering(pageRequest, innerQuery);
        this.addPageRequestParams(pageRequest, innerQuery);
        String sql = innerQuery.toString();
        List result = (List)this.dbi.withHandle(h -> h.createQuery(sql).mapToBean(Identifier.class).list());
        StringBuilder sqlCount = new StringBuilder("SELECT count(*) FROM " + this.tableName);
        this.addFiltering(pageRequest, sqlCount);
        long total = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sqlCount.toString()).mapTo(Long.class).findOne().get());
        return new PageResponse(result, pageRequest, total);
    }

    public SearchPageResponse<Identifier> find(SearchPageRequest searchPageRequest) {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " WHERE namespace ILIKE '%' || :searchTerm || '%'");
        this.addFiltering((PageRequest)searchPageRequest, innerQuery);
        this.addPageRequestParams((PageRequest)searchPageRequest, innerQuery);
        String sql = innerQuery.toString();
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("searchTerm", searchPageRequest.getQuery())).mapToBean(Identifier.class).map(Identifier.class::cast).list());
        StringBuilder countQuery = new StringBuilder("SELECT count(*) FROM " + this.tableName + " WHERE namespace ILIKE '%' || :searchTerm || '%'");
        this.addFiltering((PageRequest)searchPageRequest, countQuery);
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(countQuery.toString()).bind("searchTerm", searchPageRequest.getQuery())).mapTo(Long.class).findOne().get());
        return new SearchPageResponse(result, searchPageRequest, total);
    }

    public List<Identifier> findByIdentifiable(UUID uuidIdentifiable) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE identifiable = :uuid";
        List result = (List)this.dbi.withHandle(h -> (List)((Query)h.createQuery(sql).bind("uuid", uuidIdentifiable)).mapToBean(Identifier.class).map(Identifier.class::cast).collect(Collectors.toList()));
        return result;
    }

    public Identifier findOne(String namespace, String id) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE namespace = :namespace, identifier = :identifier";
        Identifier identifier = (Identifier)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery(sql).bind("namespace", namespace)).bind("identifier", id)).mapToBean(Identifier.class).findOne().orElse(null));
        return identifier;
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return Arrays.asList("id", "identifiable", "namespace");
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "id": {
                return "id";
            }
            case "identifiable": {
                return "identifiable";
            }
            case "namespace": {
                return "namespace";
            }
        }
        return null;
    }

    public Identifier save(Identifier identifier) {
        identifier.setUuid(UUID.randomUUID());
        String sql = "INSERT INTO " + this.tableName + "(uuid, identifiable, namespace, identifier) VALUES (:uuid, :identifiable, :namespace, :id) RETURNING *";
        Identifier result = (Identifier)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bindBean((Object)identifier)).mapToBean(Identifier.class).findOne().orElse(null));
        return result;
    }

    public Identifier update(Identifier identifier) {
        throw new UnsupportedOperationException("An update on identifiable, namespace and identifier has no use case.");
    }
}

