/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.VersionRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Version;
import de.digitalcollections.model.impl.identifiable.VersionImpl;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class VersionRepositoryImpl
extends JdbiRepositoryImpl
implements VersionRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "ver";
    public static final String TABLE_ALIAS = "v";
    public static final String TABLE_NAME = "versions";

    @Autowired
    public VersionRepositoryImpl(Jdbi dbi) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX);
    }

    public Version findOne(UUID uuid) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE uuid = :uuid";
        Version version = (Version)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", uuid)).mapToBean(VersionImpl.class).findOne().orElse(null));
        return version;
    }

    public Version findOneByInstanceversionKey(String instVersionKey) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE instance_version_key = :instance_version_key";
        Version version = (Version)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("instance_version_key", instVersionKey)).mapToBean(VersionImpl.class).findFirst().orElse(null));
        return version;
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected String getColumnName(String modelProperty) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Version save(Version version) {
        version.setUuid(UUID.randomUUID());
        version.setCreated(new Date());
        String sql = "INSERT INTO " + this.tableName + "(uuid, version_value, type_key, instance_key, instance_version_key, description, created, status) VALUES (:uuid, :versionValue, :typeKey, :instanceKey, :instanceVersionKey, :description, :created, :status) RETURNING *";
        VersionImpl result = (VersionImpl)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bindBean((Object)version)).mapToBean(VersionImpl.class).findOne().orElse(null));
        return result;
    }

    public Version update(Version version) {
        String sql = "UPDATE " + this.tableName + " SET status=:status WHERE uuid=:uuid RETURNING *";
        Version result = (Version)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bindBean((Object)version)).mapToBean(VersionImpl.class).findOne().orElse(null));
        return result;
    }
}

